/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.runner;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.util.NumberUtil;
import org.apache.log4j.Logger;

public class SetHardenedAirportsRunner {
    private static final Logger log = Logger.getLogger(SetHardenedAirportsRunner.class);
    private List<Airport> airports;

    public SetHardenedAirportsRunner(List<Airport> airports) {
        this.airports = airports;
    }

    public void process() {
        log.debug("START: " + this.airports.size());
        for (Airport a : this.airports) {
            if (a.getRunways().size() <= 0) continue;
            ArrayList<Runway> mainRunway = new ArrayList<Runway>();
            double maxLength = 0.0;
            for (Runway r : a.getRunways()) {
                if (r.getLength() == null) continue;
                if (NumberUtil.doubleEqualsDouble(r.getLength(), maxLength)) {
                    mainRunway.add(r);
                    continue;
                }
                if (!(r.getLength() > maxLength)) continue;
                mainRunway = new ArrayList();
                mainRunway.add(r);
                maxLength = r.getLength();
            }
            if (mainRunway.size() <= 0) continue;
            boolean hardened = false;
            for (Runway r : mainRunway) {
                if (r.getSurface() == null || !r.getSurface().isHardened()) continue;
                hardened = true;
                break;
            }
            a.setHardened(hardened);
        }
    }
}

