/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade.callable;

import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.util.GpsUtil;

public class SetMountainousAirportsCallable
implements Callable<List<Airport>> {
    private List<Airport> airports;
    private List<Elevation> elevations;

    public SetMountainousAirportsCallable(List<Airport> airports, List<Elevation> elevations) {
        this.airports = airports;
        this.elevations = elevations;
    }

    @Override
    public List<Airport> call() throws Exception {
        if (this.airports != null && this.elevations != null) {
            for (Airport a : this.airports) {
                a.setMountainous(this.isMountainous(a));
                a.setSkewedIls(this.hasSkewedIls(a));
            }
        }
        return this.airports;
    }

    private Boolean isMountainous(Airport airport) {
        if (airport == null || airport.getElev() == null) {
            return null;
        }
        short elevThreshold = (short)(Math.round((double)airport.getElev().intValue() / 100.0) + 45L);
        GpsPlace center = airport.getGpsPlace();
        for (Elevation el : this.elevations) {
            if (el.getElev() == null || el.getElev() < elevThreshold || !(GpsUtil.getDistance(el.getGpsPlace(), center) <= 10.0)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean hasSkewedIls(Airport airport) {
        if (airport == null || airport.getRunways().size() == 0) {
            return null;
        }
        for (Runway r : airport.getRunways()) {
            if (!r.hasSkewedIls()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

