/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.sql.service.UserPointService;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class UserPointFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(UserPointFacade.class);
    private final SqlService sqlService;
    private final UserPointService userPointService;

    public UserPointFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.userPointService = new UserPointService(dataSource);
    }

    public long getUserPointsNumber() {
        return this.sqlService.countRecordsInTable(UserPoint.class.getName());
    }

    public List<GpsPlace> getUserPointsInArea(GpsArea area) {
        ArrayList<GpsPlace> result = new ArrayList<GpsPlace>();
        List<UserPoint> points = this.userPointService.findUserPointsInArea(area);
        if (points == null) {
            log.error("Unexpected error -> SqlUtil.findUserPointsInArea(" + area + ")");
        } else {
            for (UserPoint p : points) {
                result.add(p.getGpsPlace());
            }
        }
        return result;
    }

    public List<UserPoint> findUserPointsInArea(GpsArea area) {
        return this.userPointService.findUserPointsInArea(area);
    }

    public UserPoint findUserPointById(int id) {
        return this.userPointService.findUserPointById(id);
    }

    public List<GpsPlace> getUserPoints(String query, boolean sort) {
        ArrayList<GpsPlace> result = new ArrayList<GpsPlace>();
        if (query != null && query.length() > 0) {
            List<UserPoint> points = this.userPointService.findUserPoints(query != null ? query.trim() : null, sort);
            if (points == null) {
                log.error("Unexpected error -> SqlUtil.findUserPoints(" + query + ")");
            } else {
                for (UserPoint p : points) {
                    result.add(p.getGpsPlace());
                }
            }
        }
        return result;
    }

    public int addNewUserPoints(List<UserPoint> points, boolean checkIfExists) {
        int total = 0;
        if (checkIfExists) {
            for (UserPoint point : points) {
                boolean exists = this.userPointService.isUserPointExists(point);
                if (exists || !this.userPointService.insertUserPoint(point)) continue;
                ++total;
            }
        } else {
            Session session = this.dataSource.getHibernateSession();
            for (UserPoint point : points) {
                if (!this.userPointService.insertUserPoint(point, session)) continue;
                ++total;
            }
        }
        return total;
    }

    public List<GpsPlace> getUserPointsByName(String name) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        List<UserPoint> points = this.userPointService.findUserPointsByName(name);
        if (points == null) {
            log.error("Unexpected error -> SqlUtil.findUserPointsByName(" + name + ")");
        } else {
            for (UserPoint p : points) {
                results.add(p.getGpsPlace());
            }
        }
        return results;
    }

    public boolean deleteUserPointById(int id) {
        return this.userPointService.deleteUserPointById(id);
    }

    public void updateUserPoint(UserPoint place) {
        this.userPointService.updateUserPoint(place);
    }

    public List<UserPoint> findUserPoints(String txt, boolean sort) {
        return this.userPointService.findUserPoints(txt, sort);
    }

    public void insertUserPoint(UserPoint place) {
        this.userPointService.insertUserPoint(place);
    }

    public void insertUserPoints(List<UserPoint> importedUserpoints) {
        this.userPointService.insertUserPoints(importedUserpoints);
    }

    public boolean truncateUserPointsTable() {
        return this.sqlService.truncateTable("user_points");
    }
}

