/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.List;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.ObstacleService;
import main.java.guru.vfrflight.sql.service.SqlService;
import org.hibernate.Session;

public class ObstacleFacade
extends BaseFacade {
    private final SqlService sqlService;
    private final ObstacleService obstacleService;

    public ObstacleFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.obstacleService = new ObstacleService(dataSource);
    }

    public long getObstaclesNumber() {
        return this.sqlService.countRecordsInTable(Obstacle.class.getName());
    }

    public void insertObstacles(List<Obstacle> obstacles, boolean truncateTable) {
        if (truncateTable) {
            this.truncateObstaclesTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (Obstacle o : obstacles) {
            this.obstacleService.insertObstacle(o, session);
        }
        session.clear();
        session.flush();
    }

    public boolean truncateObstaclesTable() {
        return this.sqlService.truncateTable("obstacles");
    }

    public void deleteObstacles(Double fromLat, Double fromLon, Double toLat, Double toLon) {
        this.obstacleService.deleteObstacles(fromLat, fromLon, toLat, toLon);
    }
}

