/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.NavaidService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class NavaidFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(NavaidFacade.class);
    private final SqlService sqlService;
    private final NavaidService navaidService;

    public NavaidFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.navaidService = new NavaidService(dataSource);
    }

    public List<Navaid> findAllVors() {
        return this.navaidService.findAllVors();
    }

    public List<GpsPlace> getNavaids(String query, String type, boolean sort) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        if (query != null) {
            query = query.trim();
        }
        if (type != null) {
            type = type.trim();
        }
        if (query == null || query.length() > 0) {
            List<Navaid> navaids = this.navaidService.findNavaids(query, type, sort);
            if (navaids == null) {
                log.error("Unexpected error -> SqlUtil.findNavaids(" + query + ")");
            } else {
                for (Navaid n : navaids) {
                    GpsPlace place = n.getGpsPlace();
                    place.setDesc(n.getType() + " " + n.getIdent() + " " + n.getName() + " (" + n.getCountry() + ")");
                    results.add(place);
                }
            }
        }
        return results;
    }

    public List<GpsPlace> getNavaidsInArea(GpsArea area, String type, boolean sort) {
        return this.findNavaidsInArea(area.getMinLat(), area.getMinLon(), area.getMaxLat(), area.getMaxLon(), type, sort);
    }

    public List<Navaid> findNavaids(String type, boolean sort) {
        return this.navaidService.findNavaidsInArea(null, type, sort);
    }

    public List<Navaid> findNavaidsInArea(GpsArea area, String type, boolean sort) {
        return this.navaidService.findNavaidsInArea(area, type, sort);
    }

    private List<GpsPlace> findNavaidsInArea(double minLat, double minLon, double maxLat, double maxLon, String type, boolean sort) {
        List<Navaid> navaids;
        if (type != null) {
            type = type.trim();
        }
        if ((navaids = this.navaidService.findNavaidsInArea(minLat, minLon, maxLat, maxLon, type, sort)) != null) {
            ArrayList<GpsPlace> results = new ArrayList<GpsPlace>(navaids.size());
            for (Navaid n : navaids) {
                GpsPlace place = n.getGpsPlace();
                place.setDesc(n.getType() + " " + n.getIdent() + " " + n.getName() + " (" + n.getCountry() + ")");
                results.add(place);
            }
            return results;
        }
        log.error("Unexpected error -> SqlUtil.findNavaids(" + minLat + "," + minLon + "," + maxLat + "," + maxLon + ")");
        return new ArrayList<GpsPlace>();
    }

    public List<GpsPlace> getVorsInArea(GpsArea area, boolean dme, boolean sort) {
        return this.getVors(area.getMinLat(), area.getMinLon(), area.getMaxLat(), area.getMaxLon(), dme, sort);
    }

    private List<GpsPlace> getVors(double minLat, double minLon, double maxLat, double maxLon, boolean dme, boolean sort) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        results.addAll(this.getNavaids(minLat, minLon, maxLat, maxLon, "VOR", sort));
        results.addAll(this.getNavaids(minLat, minLon, maxLat, maxLon, "VOR-DME", sort));
        if (dme) {
            results.addAll(this.getNavaids(minLat, minLon, maxLat, maxLon, "DME", sort));
        }
        return results;
    }

    public List<Navaid> findVorsInArea(GpsArea area, boolean dme, boolean sort) {
        ArrayList<Navaid> result = new ArrayList<Navaid>();
        result.addAll(this.findNavaidsInArea(area, "VOR", sort));
        result.addAll(this.findNavaidsInArea(area, "VOR-DME", sort));
        if (dme) {
            result.addAll(this.findNavaidsInArea(area, "DME", sort));
        }
        return result;
    }

    public List<GpsPlace> findNdbsInArea(GpsArea area, boolean sort) {
        return this.getNdbs(area.getMinLat(), area.getMinLon(), area.getMaxLat(), area.getMaxLon(), sort);
    }

    public List<GpsPlace> getNdbs(double minLat, double minLon, double maxLat, double maxLon, boolean sort) {
        return this.getNavaids(minLat, minLon, maxLat, maxLon, "NDB", sort);
    }

    private List<GpsPlace> getNavaids(double minLat, double minLon, double maxLat, double maxLon, String type, boolean sort) {
        return this.findNavaidsInArea(minLat, minLon, maxLat, maxLon, type, sort);
    }

    public Set<GpsPlace> findInRadius(GpsPlace place, double radius, boolean vor, boolean ndb, boolean dme) {
        HashSet<GpsPlace> vors = new HashSet<GpsPlace>();
        double minLat = place.getLat().getValue() - radius / 15.0;
        double minLon = place.getLon().getValue() - radius / 30.0;
        double maxLat = place.getLat().getValue() + radius / 15.0;
        double maxLon = place.getLon().getValue() + radius / 30.0;
        ArrayList<GpsPlace> navaids = new ArrayList<GpsPlace>();
        if (vor) {
            navaids.addAll(this.getVors(minLat, minLon, maxLat, maxLon, dme, false));
        }
        if (ndb) {
            navaids.addAll(this.getNdbs(minLat, minLon, maxLat, maxLon, false));
        }
        for (GpsPlace v : navaids) {
            if (!(GpsUtil.getDistance(place, v) <= radius)) continue;
            vors.add(v);
        }
        return vors;
    }

    public Set<GpsPlace> findInRadius(List<LineSegment> segments, double radius, boolean vor, boolean ndb, boolean dme) {
        HashSet<GpsPlace> vors = new HashSet<GpsPlace>();
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = Double.MIN_VALUE;
        double maxLon = Double.MIN_VALUE;
        ArrayList<GpsPlace> points = new ArrayList<GpsPlace>();
        points.add(segments.get(0).getFrom());
        for (int i = 0; i < segments.size(); ++i) {
            points.add(segments.get(i).getTo());
        }
        for (GpsPlace point : points) {
            if (point.getLat().getValue() < minLat) {
                minLat = point.getLat().getValue();
            }
            if (point.getLat().getValue() > maxLat) {
                maxLat = point.getLat().getValue();
            }
            if (point.getLon().getValue() < minLon) {
                minLon = point.getLon().getValue();
            }
            if (!(point.getLon().getValue() > maxLon)) continue;
            maxLon = point.getLon().getValue();
        }
        minLat -= radius / 15.0;
        minLon -= radius / 30.0;
        maxLat += radius / 15.0;
        maxLon += radius / 30.0;
        ArrayList<GpsPlace> navaids = new ArrayList<GpsPlace>();
        if (vor) {
            navaids.addAll(this.getVors(minLat, minLon, maxLat, maxLon, dme, false));
        }
        if (ndb) {
            navaids.addAll(this.getNdbs(minLat, minLon, maxLat, maxLon, false));
        }
        for (GpsPlace v : navaids) {
            for (LineSegment segment : segments) {
                GpsPlace place;
                int steps = (int)Math.ceil(segment.getDistance() / radius / 2.0);
                for (int i = 0; i < steps; ++i) {
                    GpsPlace place2 = segment.getFrom();
                    if (i > 0) {
                        place2 = MapFrame.getInstance().getPointOnSegment(segment, (double)i * radius * 2.0);
                    }
                    if (!(GpsUtil.getDistance(place2, v) <= radius)) continue;
                    vors.add(v);
                    break;
                }
                if (!(GpsUtil.getDistance(place = segment.getTo(), v) <= radius)) continue;
                vors.add(v);
            }
        }
        return vors;
    }

    public List<GpsPlace> findVorById(String vorId) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        List<Navaid> vors = this.navaidService.findNavaidsByIdent(vorId, "VOR");
        if (vors == null) {
            log.error("Unexpected error -> SqlUtil.findVorById(" + vorId + ")");
        } else {
            vors.addAll(this.navaidService.findNavaidsByIdent(vorId, "VOR-DME"));
            for (Navaid v : vors) {
                GpsPlace place = v.getGpsPlace();
                place.setDesc(v.getType() + " " + v.getIdent() + " " + v.getName() + " (" + v.getCountry() + ")");
                results.add(place);
            }
        }
        return results;
    }

    public long getNavaidsNumber() {
        return this.sqlService.countRecordsInTable(Navaid.class.getName());
    }

    public boolean truncateNavaidsTable() {
        return this.sqlService.truncateTable("navaids");
    }

    public void insertNavaids(List<Navaid> navaids, boolean truncateTable) {
        if (truncateTable) {
            this.truncateNavaidsTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (Navaid n : navaids) {
            this.navaidService.insertNavaid(n, session);
        }
        session.clear();
        session.flush();
    }

    public void deleteNavaidById(int id) {
        this.navaidService.deleteNavaidById(id);
    }

    public void deleteNavaids(String ident, Double fromLat, Double fromLon, Double toLat, Double toLon) {
        this.navaidService.deleteNavaids(ident, fromLat, fromLon, toLat, toLon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importNavaids(String fileName, boolean truncateTable) {
        if (SqlConnector.getInstance().isServerRunning()) {
            log.info("Importing navaids ... [" + fileName + "]");
            Session session = this.dataSource.getHibernateSession();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(fileName));
                if (truncateTable) {
                    this.truncateNavaidsTable();
                }
                int total = 0;
                int lineNo = 0;
                String line = null;
                br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] split = StringUtil.splitCsvLine(',', line.replace("\"\"", ""));
                    log.trace("importNavaids: line " + lineNo++);
                    String type = split[4].toUpperCase();
                    if ("VORTAC".equals(type)) {
                        type = "VOR";
                    }
                    if (split.length < 6 || !"DME".equals(type) && !"NDB".equals(type) && !"VOR-DME".equals(type) && !"VOR".equals(type)) continue;
                    try {
                        Navaid n = new Navaid();
                        if (split.length >= 9 && split[8].trim().length() > 0) {
                            n.setAlt(Integer.valueOf(split[8]));
                        }
                        n.setIdent(split[2].toUpperCase());
                        n.setName(split[3]);
                        n.setType(type);
                        n.setLat(Double.valueOf(split[6]));
                        n.setLon(Double.valueOf(split[7]));
                        if (!StringUtil.isEmpty(split[8])) {
                            n.setAlt(Integer.valueOf(split[8]));
                        }
                        if (split.length >= 10) {
                            n.setCountry(split[9].toUpperCase());
                        }
                        n.setFreq(Integer.valueOf(split[5]));
                        if (split.length >= 17 && split[16].trim().length() > 0) {
                            n.setMagvar(Double.valueOf(split[16]));
                        }
                        this.navaidService.insertNavaid(n, session);
                        if (n.getId() == null || ++total % 100 != 0) continue;
                        HibernateUtil.checkAvailableMemory();
                    }
                    catch (NumberFormatException e) {
                        log.error("Couldn't convert values to numbers: " + line, e);
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception: " + line, e);
                    }
                }
                SettingsBean.getInstance().setNavaidsTableSource("DATAFILES");
                log.info("Finished importing " + total + " navaids");
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException e) {
                log.error("Couldn't load navaids file tmp/navaids.csv", e);
            }
            catch (IOException e) {
                log.error("Couldn't load navaids file tmp/navaids.csv", e);
            }
            finally {
                session.clear();
                session.flush();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            log.error("Couldn't import navaids data: HSQL server is not running");
        }
        return false;
    }
}

