/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.entity.VfrPoint;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.service.AirportService;
import main.java.guru.vfrflight.sql.service.AirspaceService;
import main.java.guru.vfrflight.sql.service.CityService;
import main.java.guru.vfrflight.sql.service.ElevationService;
import main.java.guru.vfrflight.sql.service.IfrRouteService;
import main.java.guru.vfrflight.sql.service.ObstacleService;
import main.java.guru.vfrflight.sql.service.UserPointService;
import main.java.guru.vfrflight.sql.service.VfrPointService;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.geo.DeclinationCalculator;

public class MapFacade
extends BaseFacade {
    private final AirportService airportService;
    private final AirspaceService airspaceService;
    private final ObstacleService obstacleService;
    private final VfrPointService vfrPointService;
    private final CityService cityService;
    private final ElevationService elevationService;
    private final IfrRouteService ifrRouteService;
    private final UserPointService userPointService;

    public MapFacade(DataSource dataSource) {
        super(dataSource);
        this.airportService = new AirportService(dataSource);
        this.airspaceService = new AirspaceService(dataSource);
        this.cityService = new CityService(dataSource);
        this.elevationService = new ElevationService(dataSource);
        this.ifrRouteService = new IfrRouteService(dataSource);
        this.userPointService = new UserPointService(dataSource);
        this.obstacleService = new ObstacleService(dataSource);
        this.vfrPointService = new VfrPointService(dataSource);
    }

    public List<GpsPlace> getMapNdbsInArea(GpsArea area) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        if (area != null) {
            NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
            results.addAll(navaidFacade.findNdbsInArea(area, false));
        }
        return results;
    }

    public List<GpsPlace> getMapVorsInArea(GpsArea area, boolean dme) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        if (area != null) {
            NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
            results.addAll(navaidFacade.getVorsInArea(area, dme, false));
        }
        return results;
    }

    public List<Airport> findAirports(int region) {
        return this.findAirports(region, false);
    }

    public List<Airport> findAirports(GpsArea area, boolean eagerLoad) {
        return this.airportService.findAirportsInArea(area, eagerLoad);
    }

    public List<Airport> findAirports(int region, boolean eagerLoad) {
        return this.findAirports(this.getAreaByRegion(region), eagerLoad);
    }

    private GpsArea getAreaByRegion(int region) {
        GpsArea area = null;
        if (region == 1) {
            area = SettingsBean.getInstance().getMapObjectsUserRegion();
        } else if (region != 0) {
            area = Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()];
        }
        return area;
    }

    public List<AirspaceArea> findAirspaces(GpsArea area) {
        return this.airspaceService.findAirspacesInArea(area);
    }

    public List<AirspaceArea> findAirspaces(int region) {
        return this.findAirspaces(this.getAreaByRegion(region));
    }

    public List<City> findCities(GpsArea area) {
        return this.cityService.findCitiesInArea(area, null);
    }

    public List<City> findCities(int region) {
        return this.findCities(this.getAreaByRegion(region));
    }

    public List<Obstacle> findObstacles(GpsArea area) {
        return this.obstacleService.findObstaclesInArea(area);
    }

    public List<Obstacle> findObstacles(int region) {
        return this.findObstacles(this.getAreaByRegion(region));
    }

    public List<VfrPoint> findVfrPoints(GpsArea area) {
        return this.vfrPointService.findVfrPointsInArea(area);
    }

    public List<VfrPoint> findVfrPoints(int region) {
        return this.findVfrPoints(this.getAreaByRegion(region));
    }

    public List<Elevation> findElevations(int region) {
        List<Elevation> elevations = null;
        elevations = region == 0 ? this.elevationService.getAllElevations() : (region == 1 ? this.elevationService.findElevationsInArea(SettingsBean.getInstance().getMapObjectsUserRegion()) : this.elevationService.findElevationsInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]));
        return elevations;
    }

    public List<Waypoint> findWaypoints(GpsArea area) {
        return this.ifrRouteService.findIfrPointsInArea(area);
    }

    public List<Waypoint> findWaypoints(int region) {
        return this.findWaypoints(this.getAreaByRegion(region));
    }

    public List<Route> findRoutes(GpsArea area) {
        return this.ifrRouteService.findIfrRoutesInArea(area);
    }

    public List<Route> findRoutes(int region) {
        return this.findRoutes(this.getAreaByRegion(region));
    }

    public List<Runway> findRunways(int region) {
        List<Runway> runways = null;
        runways = region == 0 ? this.airportService.getAllRunways() : (region == 1 ? this.airportService.findRunwaysInArea(SettingsBean.getInstance().getMapObjectsUserRegion()) : this.airportService.findRunwaysInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]));
        return runways;
    }

    public List<Ils> findIls(int region) {
        List<Ils> ils = null;
        ils = region == 0 ? this.airportService.getAllIls() : (region == 1 ? this.airportService.findIlsInArea(SettingsBean.getInstance().getMapObjectsUserRegion()) : this.airportService.findIlsInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]));
        return ils;
    }

    public List<Navaid> findNdbs(int region) {
        NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
        List<Navaid> ndbs = null;
        ndbs = region == 0 ? navaidFacade.findNavaids("NDB", false) : (region == 1 ? navaidFacade.findNavaidsInArea(SettingsBean.getInstance().getMapObjectsUserRegion(), "NDB", false) : navaidFacade.findNavaidsInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()], "NDB", false));
        return ndbs;
    }

    public List<UserPoint> findUserPoints(int region) {
        List<UserPoint> userPoints = null;
        userPoints = region == 0 ? this.userPointService.findUserPoints(null, false) : (region == 1 ? this.userPointService.findUserPointsInArea(SettingsBean.getInstance().getMapObjectsUserRegion()) : this.userPointService.findUserPointsInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]));
        return userPoints;
    }

    public List<Navaid> findVors(int region) {
        NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
        List<Navaid> vors = null;
        vors = region == 0 ? navaidFacade.findAllVors() : (region == 1 ? navaidFacade.findVorsInArea(SettingsBean.getInstance().getMapObjectsUserRegion(), true, false) : navaidFacade.findVorsInArea(Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()], true, false));
        return vors;
    }

    public Set<NamedWaypoint> createMagneticDeclinations(DeclinationCalculator calculator, int region) {
        if (region == 0) {
            return this.createMagneticDeclinationsForArea(calculator, null);
        }
        if (region == 1) {
            return this.createMagneticDeclinationsForArea(calculator, SettingsBean.getInstance().getMapObjectsUserRegion());
        }
        return this.createMagneticDeclinationsForArea(calculator, Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()]);
    }

    public Set<NamedWaypoint> createMagneticDeclinationsForArea(DeclinationCalculator calculator, GpsArea area) {
        HashSet<NamedWaypoint> declinations = new HashSet<NamedWaypoint>();
        float latStart = -90.0f;
        float latEnd = 90.0f;
        float lonStart = -180.0f;
        float lonEnd = 180.0f;
        if (area != null) {
            latStart = area.getMinLat().floatValue();
            latEnd = area.getMaxLat().floatValue();
            lonStart = area.getMinLon().floatValue();
            lonEnd = area.getMaxLon().floatValue();
        }
        float step = 2.0f;
        for (float lat = latStart; lat <= latEnd; lat += step) {
            for (float lon = lonStart; lon <= lonEnd; lon += step) {
                declinations.add(new NamedWaypoint(Double.valueOf(lat), Double.valueOf(lon), String.valueOf(NumberUtil.roundDouble(calculator.getMagneticDeclination(new GpsPlace(lat, lon)), 1))));
            }
            System.gc();
        }
        if (declinations.size() == 0) {
            return null;
        }
        return declinations;
    }
}

