/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.List;
import main.java.guru.vfrflight.core.ImportBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.ObstacleFacade;
import main.java.guru.vfrflight.sql.facade.runner.SetHardenedAirportsRunner;
import main.java.guru.vfrflight.sql.facade.runner.SetMountainousAirportsRunner;
import main.java.guru.vfrflight.sql.facade.runner.SetNdbVorAirportsRunner;
import main.java.guru.vfrflight.sql.service.SqlService;

public class ImportFacade
extends BaseFacade {
    private final SqlService sqlService;

    public ImportFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
    }

    public List<Airport> setMountanousAirports(List<Airport> airports, List<Elevation> elevations) {
        SetMountainousAirportsRunner runner = new SetMountainousAirportsRunner(airports, elevations);
        return runner.process();
    }

    public List<Airport> setNdbVorAirports(List<Airport> airports, List<GpsPlace> vors, List<GpsPlace> ndbs) {
        SetNdbVorAirportsRunner runner = new SetNdbVorAirportsRunner(airports, vors, ndbs);
        return runner.process();
    }

    public void setHardenedAirports(List<Airport> airports) {
        SetHardenedAirportsRunner runner = new SetHardenedAirportsRunner(airports);
        runner.process();
    }

    public void initBeforeImport(ImportBean importBean) {
        this.sqlService.checkDBStructure();
        if (!importBean.isSelectiveTruncate()) {
            ObstacleFacade obstacleFacade = new ObstacleFacade(this.dataSource);
            obstacleFacade.truncateObstaclesTable();
            AirportFacade airportFacade = new AirportFacade(this.dataSource);
            if (importBean.isImportNavaids()) {
                NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
                navaidFacade.truncateNavaidsTable();
            }
            if (importBean.isImportAirports()) {
                airportFacade.truncateAirportsTable();
            }
            IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(this.dataSource);
            if (importBean.isImportWaypoints()) {
                ifrRouteFacade.truncateWaypointsTable();
                airportFacade.truncateVfrPointsTable();
            }
            if (importBean.isImportRoutes()) {
                ifrRouteFacade.truncateRoutesTable();
            }
            if (importBean.isImportBoundaries()) {
                AirspaceFacade airspaceFacade = new AirspaceFacade(this.dataSource);
                airspaceFacade.truncateAirspacesTable();
            }
        }
    }
}

