/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.core.dto.IfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.IfrRouteService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class IfrRouteFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(IfrRouteFacade.class);
    private final SqlService sqlService;
    private final IfrRouteService ifrRouteService;

    public long getIfrPointsNumber() {
        return this.sqlService.countRecordsInTable(Waypoint.class.getName());
    }

    public long getIfrRoutesNumber() {
        return this.sqlService.countRecordsInTable(Route.class.getName());
    }

    public IfrRouteFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.ifrRouteService = new IfrRouteService(dataSource);
    }

    public boolean truncateWaypointsTable() {
        return this.sqlService.truncateTable("waypoints");
    }

    public boolean truncateRoutesTable() {
        return this.sqlService.truncateTable("routes");
    }

    public List<IfrPointDTO> findIfrPointsInArea(GpsArea area) {
        ArrayList<IfrPointDTO> results = new ArrayList<IfrPointDTO>();
        List<Waypoint> points = this.ifrRouteService.findIfrPointsInArea(area);
        if (points == null) {
            log.error("Unexpected error -> SqlUtil.findIfrPointsInArea(" + area + ")");
        } else {
            for (Waypoint w : points) {
                results.add(new IfrPointDTO(w));
            }
        }
        return results;
    }

    public List<GpsPlace> findIfrPoints(String query, boolean sort) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        if (query != null) {
            query = query.trim();
        }
        if (query == null || query.length() > 0) {
            List<Waypoint> points = this.ifrRouteService.findIfrPoints(query, sort);
            if (points == null) {
                log.error("Unexpected error -> SqlUtil.findIfrPoints(" + query + ")");
            } else {
                for (Waypoint w : points) {
                    GpsPlace place = w.getGpsPlace();
                    String desc = w.getIdent();
                    if (w.getRegion() != null) {
                        desc = desc + " (" + w.getRegion() + ")";
                    }
                    place.setDesc(desc);
                    results.add(place);
                }
            }
        }
        return results;
    }

    public void insertIfrPoints(List<Waypoint> waypoints, boolean truncateTable) {
        if (truncateTable) {
            this.truncateWaypointsTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (Waypoint w : waypoints) {
            this.ifrRouteService.insertWaypoint(w, session);
        }
        session.clear();
        session.flush();
    }

    public void insertIfrRoutes(List<Route> routes, boolean truncateTable) {
        if (truncateTable) {
            this.truncateRoutesTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (Route r : routes) {
            this.ifrRouteService.insertRoute(r, session);
        }
        session.clear();
        session.flush();
    }

    public void deleteIfrPoints(String ident, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        this.ifrRouteService.deleteIfrPoints(ident, minLat, minLon, maxLat, maxLon);
    }

    public void deleteIfrRoutes(JXMapViewer map, String name, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        List<Route> routes = this.ifrRouteService.findIfrRoutes(name);
        if (minLat == null) {
            minLat = -200.0;
        }
        if (maxLat == null) {
            maxLat = 200.0;
        }
        if (minLon == null) {
            minLon = -200.0;
        }
        if (maxLon == null) {
            maxLon = 200.0;
        }
        GpsArea area = new GpsArea(maxLat, minLon, minLat, maxLon);
        for (Route r : routes) {
            if (!MapUtil.isSegmentInsideArea(map, r.getSegment(), area)) continue;
            log.debug("Deleting " + r);
            this.ifrRouteService.deleteIfrRouteById(r.getId());
        }
    }

    public void deleteIfrPointById(Integer id) {
        this.ifrRouteService.deleteIfrPointById(id);
    }
}

