/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.ElevationService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.Timer;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class ElevationFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(ElevationFacade.class);
    private final SqlService sqlService;
    private final ElevationService elevationService;

    public ElevationFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.elevationService = new ElevationService(dataSource);
    }

    public long getElevationsNumber() {
        return this.sqlService.countRecordsInTable(Elevation.class.getName());
    }

    public boolean truncateElevationsTable() {
        return this.sqlService.truncateTable("elevations");
    }

    public void importSrtm(String fileName, int scale) {
        Elevation[] elevations = ElevationsUtil.getElevationsFromFile(fileName, scale, true, null);
        Session session = this.dataSource.getHibernateSession();
        for (int count = 0; count < elevations.length; ++count) {
            Elevation el = elevations[count];
            el.setElev((short)(Math.round((double)el.getElev().shortValue() / 100.0) + 10L));
            this.elevationService.insertElevation(el, session);
            if (count % 100 != 0) continue;
            HibernateUtil.checkAvailableMemory();
        }
        session.flush();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dumpElevationsTableToFile(String fileName) {
        List<Elevation> elevations = this.elevationService.getAllElevations();
        log.info("Dumping " + elevations.size() + " to file " + fileName);
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new FileOutputStream(fileName));
            os.writeInt(elevations.size());
            for (Elevation el : elevations) {
                os.writeDouble(el.getLat());
                os.writeDouble(el.getLon());
                os.writeShort(el.getElev().shortValue());
            }
        }
        catch (FileNotFoundException e) {
            log.error(e, e);
            IOUtil.closeQuietly(os);
        }
        catch (IOException e2) {
            log.error(e2, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(os);
        }
        IOUtil.closeQuietly(os);
        log.info("Done.");
    }

    public void importSrtmFromHgtFiles(String directoryPath, int scale, GpsArea overRegion) {
        Elevation[] elevations = ElevationsUtil.loadElevationsFromHgtFiles(directoryPath, scale, true, overRegion, true);
        Session session = this.dataSource.getHibernateSession();
        for (int count = 0; count < elevations.length; ++count) {
            Elevation el = elevations[count];
            el.setElev((short)(Math.round((double)el.getElev().shortValue() / 100.0) + 10L));
            this.elevationService.insertElevation(el, session);
            if (count % 100 != 0) continue;
            HibernateUtil.checkAvailableMemory();
        }
        session.flush();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadElevationsTableFromFile(String outputFolder, String archiveName, String fileName) {
        block11: {
            block9: {
                try {
                    IOUtil.unZipFile(archiveName, outputFolder);
                }
                catch (IOException e) {
                    log.error(e, e);
                }
                if (!new File(fileName).exists()) break block9;
                log.info("Loading elevations from file " + fileName);
                this.truncateElevationsTable();
                Session session = this.dataSource.getHibernateSession();
                Timer.getInstance().start("loadElevationsTableFromFile");
                byte[] twoBytes = new byte[2];
                byte[] fourBytes = new byte[4];
                byte[] eightBytes1 = new byte[8];
                byte[] eightBytes2 = new byte[8];
                BufferedInputStream os = null;
                try {
                    os = new BufferedInputStream(new FileInputStream(fileName));
                    os.read(fourBytes);
                    int size = VfrUtil.byte2int(fourBytes);
                    for (int i = 0; i < size; ++i) {
                        os.read(eightBytes1);
                        os.read(eightBytes2);
                        os.read(twoBytes);
                        this.elevationService.insertElevation(new Elevation(VfrUtil.byte2double(eightBytes1), VfrUtil.byte2double(eightBytes2), VfrUtil.byte2short(twoBytes)), session);
                        if (i % 100 != 0) continue;
                        HibernateUtil.checkAvailableMemory();
                    }
                }
                catch (FileNotFoundException e) {
                    log.error(e, e);
                    IOUtil.closeQuietly(os);
                }
                catch (IOException e2) {
                    log.error(e2, e2);
                    {
                        catch (Throwable throwable) {
                            IOUtil.closeQuietly(os);
                            throw throwable;
                        }
                    }
                    IOUtil.closeQuietly(os);
                }
                IOUtil.closeQuietly(os);
                Timer.getInstance().stop("loadElevationsTableFromFile", false);
                IOUtil.deleteFile(fileName);
                session.flush();
                session.close();
                log.info("Done.");
                break block11;
            }
            log.error("Couldn't find file " + fileName);
        }
    }

    public TerrainElevationDTO[] getTerrainElevationsForSegments(List<RouteSegment> segments) {
        GpsArea rectangleOver = GpsUtil.getRectangleOverVertices(GpsUtil.getPointsFromSegments(new ArrayList<LineSegment>(segments)));
        rectangleOver.expand(0.25);
        return ElevationsUtil.loadTerrainElevations(rectangleOver);
    }

    public Integer getMsaforPlace(GpsPlace place) {
        TerrainElevationDTO[] elevations = ElevationsUtil.loadTerrainElevations(new GpsArea(place, place));
        if (elevations != null && elevations.length > 0) {
            for (TerrainElevationDTO dto : elevations) {
                if (!place.isInside(dto.getArea())) continue;
                return (dto.getElev() + 10) * 100;
            }
        }
        return null;
    }

    public Integer calculateMsaEnRoute(JXMapViewer map, List<RouteSegment> segments) {
        TerrainElevationDTO[] elevations = this.getTerrainElevationsForSegments(segments);
        boolean foundValue = false;
        short result = Short.MIN_VALUE;
        for (LineSegment lineSegment : segments) {
            for (TerrainElevationDTO dto : elevations) {
                if (!MapUtil.isSegmentIntersectsArea(map, lineSegment, dto.getArea()) && (!lineSegment.getFrom().isInside(dto.getArea()) || !lineSegment.getTo().isInside(dto.getArea())) || dto.getElev() <= result) continue;
                result = dto.getElev();
                foundValue = true;
            }
        }
        return foundValue ? Integer.valueOf((result + 10) * 100) : null;
    }

    public Integer calculateMsa(JXMapViewer map, List<RouteSegment> segments) {
        Integer msa = this.calculateMsaEnRoute(map, segments);
        if (msa != null) {
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                msa = (int)Math.ceil(UnitUtil.recalculateAltitude(msa.intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false) / 100.0) * 100;
            }
            return msa;
        }
        return null;
    }

    public List<Elevation> findElevationsInArea(GpsArea region) {
        return this.elevationService.findElevationsInArea(region);
    }
}

