/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.ImportFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class DataFilesImportFacade
extends ImportFacade {
    private static final Logger log = Logger.getLogger(DataFilesImportFacade.class);

    public DataFilesImportFacade(DataSource dataSource) {
        super(dataSource);
    }

    public boolean downloadAndImportNavaids(boolean forceDownload) {
        boolean result = false;
        File fileNavaids = new File("tmp/navaids.csv");
        if (forceDownload && fileNavaids.exists() && !fileNavaids.isDirectory()) {
            fileNavaids.delete();
        }
        try {
            if (forceDownload || !fileNavaids.exists()) {
                log.info("Downloading navaids file ...");
                IOUtil.downloadFile(SettingsBean.getInstance().getParamNavaidsUrl(), "tmp/navaids.csv");
                log.info("Navaids file download successful");
            } else {
                log.info("Using existing navaids file");
            }
            NavaidFacade navaidFacade = new NavaidFacade(this.dataSource);
            result = navaidFacade.importNavaids("tmp/navaids.csv", true);
        }
        catch (IOException e) {
            log.error("Couldn't download navaids file", e);
        }
        if (fileNavaids.exists() && !fileNavaids.isDirectory()) {
            fileNavaids.delete();
        }
        return result;
    }

    public boolean downloadAndImportAirports(boolean forceDownload) {
        boolean result = false;
        File fileAirports = new File("tmp/airports.csv");
        if (forceDownload && fileAirports.exists() && !fileAirports.isDirectory()) {
            fileAirports.delete();
        }
        try {
            if (forceDownload || !fileAirports.exists()) {
                log.info("Downloading airports file ...");
                IOUtil.downloadFile(SettingsBean.getInstance().getParamAirportsUrl(), "tmp/airports.csv");
                log.info("Airports file download successful");
            } else {
                log.info("Using existing airports file");
            }
            AirportFacade airportFacade = new AirportFacade(this.dataSource);
            result = airportFacade.importAirports();
        }
        catch (IOException e) {
            log.error("Couldn't download airports file", e);
        }
        if (fileAirports.exists() && !fileAirports.isDirectory()) {
            fileAirports.delete();
        }
        return result;
    }

    public boolean downloadAndImportFiles(boolean showInfo, boolean forceDownload) {
        File tmpDir = new File("tmp");
        if (!(tmpDir.exists() && tmpDir.isDirectory() || tmpDir.mkdir())) {
            log.fatal("Couldn't create temp dir tmp");
        }
        if (!this.downloadAndImportNavaids(forceDownload) || !this.downloadAndImportAirports(forceDownload)) {
            if (showInfo) {
                JOptionPane.showMessageDialog(null, Messages.getInstance().get("some_data_files_missing"), "", 0);
            }
            return false;
        }
        return true;
    }
}

