/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.CityService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.util.CitiesUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class CityFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(CityFacade.class);
    private final SqlService sqlService;
    private final CityService cityService;

    public CityFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.cityService = new CityService(dataSource);
    }

    public long getCitiesNumber() {
        return this.sqlService.countRecordsInTable(City.class.getName());
    }

    public boolean truncateCitiesTable() {
        return this.sqlService.truncateTable("cities");
    }

    public List<GpsPlace> getCitiesInArea(GpsArea area, Short size) {
        List<City> cities = this.cityService.findCitiesInArea(area, size);
        if (cities != null) {
            ArrayList<GpsPlace> results = new ArrayList<GpsPlace>(cities.size());
            for (City c : cities) {
                results.add(c.getGpsPlace());
            }
            return results;
        }
        log.error("Unexpected error -> SqlUtil.findCitiesInArea(" + area + ")");
        return new ArrayList<GpsPlace>();
    }

    public List<CityDTO> findCitiesInArea(GpsArea area, Short size) {
        List<City> cities = this.cityService.findCitiesInArea(area, size);
        if (cities != null) {
            ArrayList<CityDTO> results = new ArrayList<CityDTO>(cities.size());
            for (City c : cities) {
                results.add(new CityDTO(c));
            }
            return results;
        }
        log.error("Unexpected error -> SqlUtil.findCitiesInArea(" + area + ")");
        return new ArrayList<CityDTO>();
    }

    public List<GpsPlace> getCities(String query, boolean sort) {
        if ((query = query.trim()) != null && query.length() > 0) {
            List<City> cities = this.cityService.findCities(query = query.trim(), sort);
            if (cities == null) {
                log.error("Unexpected error -> SqlUtil.findCities(" + query.trim() + ")");
            } else {
                ArrayList<GpsPlace> results = new ArrayList<GpsPlace>(cities.size());
                for (City c : cities) {
                    GpsPlace place = c.getGpsPlace();
                    place.setDesc(c.getName());
                    results.add(place);
                }
                return results;
            }
        }
        return new ArrayList<GpsPlace>();
    }

    public void loadCitiesTableFromFile(String outputFolder, String archiveName, String fileName) {
        try {
            IOUtil.unZipFile(archiveName, outputFolder);
            if (new File(fileName).exists()) {
                log.info("Loading cities from file " + fileName);
                this.insertCities(CitiesUtil.loadCitiesTableFromFile(fileName), true);
                IOUtil.deleteFile(fileName);
                log.info("Done.");
            }
        }
        catch (IOException e) {
            log.error(e, e);
        }
    }

    public void insertCities(Set<City> cities, boolean truncateTable) {
        if (truncateTable) {
            this.truncateCitiesTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (City c : cities) {
            this.cityService.insertCity(c, session);
        }
        session.clear();
        session.flush();
    }

    public boolean deleteCityById(int id) {
        return this.cityService.deleteCityById(id);
    }
}

