/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import main.java.guru.vfrflight.core.fsx.BglImportBean;
import main.java.guru.vfrflight.core.fsx.BglImportDeleteAirport;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.AirportStart;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.ApronVertex;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.sql.type.AirportFreqType;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.core.sql.type.RunwayDesignator;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.core.sql.type.WaypointType;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.ImportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.sql.service.AirportService;
import main.java.guru.vfrflight.sql.service.AirspaceService;
import main.java.guru.vfrflight.sql.service.IfrRouteService;
import main.java.guru.vfrflight.sql.service.NavaidService;
import main.java.guru.vfrflight.util.BglImportUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BglImportFacade
extends ImportFacade {
    private static final Logger log = Logger.getLogger(BglImportFacade.class);
    private static final long THRESHOLD_SIZE = 65536L;
    private static String FS_NODE_VOR = "Vor";
    private static String FS_NODE_NDB = "Ndb";
    private static String FS_NODE_COM = "Com";
    private static String FS_NODE_DME = "Dme";
    private static String FS_NODE_GS = "GlideSlope";
    private static String FS_NODE_ILS = "Ils";
    private static String FS_NODE_ROUTE = "Route";
    private static String FS_NODE_PREVIOUS = "Previous";
    private static String FS_NODE_NEXT = "Next";
    private static String FS_NODE_RUNWAY = "Runway";
    private static String FS_NODE_TAXIWAY_POINT = "TaxiwayPoint";
    private static String FS_NODE_TAXIWAY_PATH = "TaxiwayPath";
    private static String FS_NODE_TAXI_NAME = "TaxiName";
    private static String FS_NODE_AIRPORT = "Airport";
    private static String FS_NODE_DELETE_RUNWAY = "DeleteRunway";
    private static String FS_NODE_DELETE_FREQUENCY = "DeleteFrequency";
    private static String FS_NODE_DELETE_AIRPORT = "DeleteAirport";
    private static String FS_NODE_START = "Start";
    private static String FS_NODE_WAYPOINT = "Waypoint";
    private static String FS_NODE_BOUNDARY = "Boundary";
    private static String FS_NODE_GEOPOL = "Geopol";
    private static String FS_NODE_APRON = "Apron";
    private static String FS_NODE_APRONS = "Aprons";
    private static String FS_NODE_VERTEX = "Vertex";
    private static String FS_NODE_BOUNDARY_START = "BoundaryStart";
    private static String FS_NODE_LINE = "Line";
    private static String FS_NODE_ORIGIN = "Origin";
    private static String FS_NODE_ARC = "Arc";
    private static String FS_NODE_CIRCLE = "Circle";
    private static String FS_NODE_MAP_MAXIMUM_ALT_TYPE = "maximumAltitudeType";
    private static String FS_NODE_MAP_MINIMUM_ALT_TYPE = "minimumAltitudeType";
    private static String FS_NODE_MAP_ALT_MAXIMUM = "altitudeMaximum";
    private static String FS_NODE_MAP_ALT_MINIMUM = "altitudeMinimum";
    private static String FS_NODE_TAXIWAY_PARKING = "TaxiwayParking";
    private static String FS_NODE_MAP_IDENT = "ident";
    private static String FS_NODE_MAP_WAYPOINT_IDENT = "waypointIdent";
    private static String FS_NODE_MAP_WAYPOINT_REGION = "waypointRegion";
    private static String FS_NODE_MAP_END = "end";
    private static String FS_NODE_MAP_START = "start";
    private static String FS_NODE_MAP_INDEX = "index";
    private static String FS_NODE_MAP_LAT = "lat";
    private static String FS_NODE_MAP_LON = "lon";
    private static String FS_NODE_MAP_RADIUS = "radius";
    private static String FS_NODE_MAP_NAME = "name";
    private static String FS_NODE_MAP_ALT = "alt";
    private static String FS_NODE_MAP_HEADING = "heading";
    private static String FS_NODE_MAP_SURFACE = "surface";
    private static String FS_NODE_MAP_MAGVAR = "magvar";
    private static String FS_NODE_MAP_FREQUENCY = "frequency";
    private static String FS_NODE_MAP_REGION = "region";
    private static String FS_NODE_MAP_DME_ONLY = "dmeOnly";
    private static String FS_NODE_MAP_TRUE = "TRUE";
    private static String FS_NODE_MAP_NONE = "NONE";
    private static String FS_NODE_MAP_HELIPAD = "HELIPAD";
    private static String FS_NODE_MAP_WATER = "WATER";
    private static String FS_NODE_MAP_NAV = "nav";
    private static String FS_NODE_MAP_DME = "dme";
    private static String FS_NODE_MAP_LENGTH = "length";
    private static String FS_NODE_MAP_WIDTH = "width";
    private static String FS_NODE_MAP_PITCH = "pitch";
    private static String FS_NODE_MAP_NUMBER = "number";
    private static String FS_NODE_MAP_DESIGNATOR = "designator";
    private static String FS_NODE_MAP_PRIMARY_DESIGNATOR = "primaryDesignator";
    private static String fS_NODE_MAP_SECONDARY_DESIGNATOR = "secondaryDesignator";
    private static String FS_NODE_MAP_TYPE = "type";
    private static String FS_NODE_MAP_SPARSE = "SPARSE";
    private static String FS_NODE_MAP_VERY_SPARSE = "VERY_SPARSE";
    private static String FS_NODE_DELETE_ALL_FREQUENCIES = "deleteAllFrequencies";
    private static String FS_NODE_DELETE_ALL_HELIPADS = "deleteAllFrequencies";
    private static String FS_NODE_DELETE_ALL_RUNWAYS = "deleteAllRunways";
    private static String FS_NODE_DELETE_ALL_STARTS = "deleteAllStarts";
    private static String FS_NODE_DELETE_ALL_APRONS = "deleteAllAprons";
    private static String FS_NODE_DELETE_ALL_TAXIWAYS = "deleteAllTaxiways";
    private static String FS_NODE_MAP_HELIPAD_NAME = " (helipad)";
    private static String FS_NODE_MAP_WATER_NAME = " (water)";
    private static String FS_NODE_MAP_CLOCKWISE = "CLOCKWISE";
    private static final int BGL_SECTION_TYPE_AIRPORT = 3;
    private static final int BGL_SECTION_TYPE_NAVAID = 19;
    private static final int BGL_SECTION_TYPE_NDB = 23;
    private static final int BGL_SECTION_TYPE_BOUNDARY = 32;
    private static final int BGL_SECTION_TYPE_WAYPOINT = 34;
    private static final int BGL_SECTION_TYPE_GEOPOL = 35;
    private static final Map<String, AltitudeType> ALTITUDE_TYPE_MAPPINGS;
    private static final Map<String, Integer> RUNWAY_NUMBER_MAPPINGS;
    private static final Map<String, RunwayDesignator> RUNWAY_DESIGNATOR_MAPPINGS;
    private final AirspaceService airspaceService;
    private final AirportService airportService;
    private final NavaidService navaidService;
    private final IfrRouteService ifrRouteService;

    public BglImportFacade(DataSource dataSource) {
        super(dataSource);
        this.airspaceService = new AirspaceService(dataSource);
        this.airportService = new AirportService(dataSource);
        this.navaidService = new NavaidService(dataSource);
        this.ifrRouteService = new IfrRouteService(dataSource);
    }

    public boolean importFromBglFile(BglImportBean importBean, File bglFile, String workingDir) {
        String bglPath = bglFile.getAbsolutePath();
        log.debug("Checking file: " + bglPath + "; freemem: " + VfrUtil.getFreeHeapSpace());
        if (this.bglFileHasData(bglPath, importBean)) {
            String inputPath = workingDir + IOUtil.getNameFromPath(bglPath);
            String xmlFile = inputPath.substring(0, inputPath.length() - 4) + ".xml";
            HibernateUtil.checkAvailableMemory();
            log.debug("Recompiling Bgl: " + bglPath + " to " + xmlFile + "; freemem: " + VfrUtil.getFreeHeapSpace());
            String bgl2xmlOut = BglImportUtil.recompileBgl(bglPath, xmlFile, workingDir);
            if (bgl2xmlOut != null && new File(xmlFile).exists()) {
                if (this.importFromBgl(xmlFile, bglPath, importBean, bglFile.length() > 65536L)) {
                    IOUtil.deleteFile(xmlFile);
                    IOUtil.deleteFile(xmlFile + ".tmp");
                    return true;
                }
                log.error("ERROR importing BGL in file " + xmlFile);
            } else if (bgl2xmlOut == null || bgl2xmlOut.indexOf("not a valid FS2004 or FSX facility data BGL") == -1) {
                log.error("==================");
                log.error("ERROR decompiling " + inputPath);
                if (bgl2xmlOut != null) {
                    log.error(bgl2xmlOut.replace("BglXml version 2.1 / WIN32 - (C)2003-2007 Alessandro G.Antonini", "").trim());
                }
                log.error("==================");
            }
        }
        return false;
    }

    public boolean importFromBgl(String xmlFile, String bglFile, BglImportBean importBean, boolean rewriteFile) {
        boolean result = true;
        try {
            log.debug("Importing data from " + xmlFile + "; " + bglFile + "; rewrite file: " + rewriteFile);
            if (rewriteFile) {
                BglImportUtil.rewriteXmlFile(xmlFile, xmlFile + ".tmp");
                this.importObjects(BglImportUtil.getFsDataChildren(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(xmlFile + ".tmp"))), importBean);
            } else {
                this.importObjects(BglImportUtil.getFsDataChildren(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(BglImportUtil.getXmlFile(xmlFile))))), importBean);
            }
            return result;
        }
        catch (ParserConfigurationException e) {
            log.error("Bgl file: " + bglFile, e);
        }
        catch (SAXException e) {
            log.error("Bgl file: " + bglFile, e);
        }
        catch (IOException e) {
            log.error("Bgl file: " + bglFile, e);
        }
        return false;
    }

    private void importObjects(NodeList fsDataNodes, BglImportBean importBean) {
        Node node = null;
        for (int i = 0; i < fsDataNodes.getLength(); ++i) {
            node = fsDataNodes.item(i);
            if (importBean.isImportNavaids() && FS_NODE_VOR.equalsIgnoreCase(node.getNodeName())) {
                this.importVorDme(node, importBean);
                continue;
            }
            if (importBean.isImportNavaids() && FS_NODE_NDB.equalsIgnoreCase(node.getNodeName())) {
                this.importNdb(node.getAttributes(), importBean);
                continue;
            }
            if (importBean.isImportAirports() && FS_NODE_AIRPORT.equalsIgnoreCase(node.getNodeName())) {
                this.importAirports(node, importBean);
                continue;
            }
            if (importBean.isImportWaypoints() && FS_NODE_WAYPOINT.equalsIgnoreCase(node.getNodeName())) {
                this.importWaypoint(node, importBean);
                continue;
            }
            if (importBean.isImportBoundaries() && FS_NODE_BOUNDARY.equalsIgnoreCase(node.getNodeName())) {
                this.importBoundary(node, importBean);
                continue;
            }
            if (!importBean.isImportGeopol() || !FS_NODE_GEOPOL.equalsIgnoreCase(node.getNodeName())) continue;
            this.importGeopol(node, importBean);
        }
    }

    private void importVorDme(Node node, BglImportBean importBean) {
        NamedNodeMap map = node.getAttributes();
        String ident = map.getNamedItem(FS_NODE_MAP_IDENT).getNodeValue().toUpperCase();
        Character key = this.getNavaidsKey(ident);
        try {
            double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
            double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
            if (importBean.getVors().get(key) != null) {
                GpsPlace newVor = new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
                Iterator<Navaid> iterator = importBean.getVors().get(key).iterator();
                while (iterator.hasNext()) {
                    double dist;
                    Navaid n = iterator.next();
                    if (!ident.equals(n.getIdent()) || !((dist = GpsUtil.getDistance(newVor, n.getGpsPlace())) <= 5.0)) continue;
                    iterator.remove();
                    break;
                }
            }
            Navaid vor = new Navaid();
            vor.setIdent(ident);
            vor.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
            vor.setLat(lat);
            vor.setLon(lon);
            vor.setAlt((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
            double freq = Double.valueOf(map.getNamedItem(FS_NODE_MAP_FREQUENCY).getNodeValue());
            vor.setFreq((int)Math.round(freq * 1000.0));
            vor.setCountry(map.getNamedItem(FS_NODE_MAP_REGION).getNodeValue());
            if (map.getNamedItem(FS_NODE_MAP_MAGVAR) != null && map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue() != null) {
                vor.setMagvar(-Double.valueOf(map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue()).doubleValue());
            }
            boolean dmeOnly = false;
            dmeOnly = map.getNamedItem(FS_NODE_MAP_DME_ONLY) != null ? FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_MAP_DME_ONLY).getNodeValue()) : FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_MAP_NAV).getNodeValue());
            boolean dme = FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_MAP_DME).getNodeValue());
            if (dmeOnly) {
                vor.setType("DME");
            } else if (!dme) {
                vor.setType("VOR");
            } else {
                vor.setType("VOR-DME");
                NodeList childNodes = node.getChildNodes();
                Node el = null;
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    el = childNodes.item(j);
                    if (el == null || !FS_NODE_DME.equalsIgnoreCase(el.getNodeName())) continue;
                    NamedNodeMap elMap = el.getAttributes();
                    lat = Double.valueOf(elMap.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                    lon = Double.valueOf(elMap.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                    int alt = (int)UnitUtil.recalculateAltitude(Double.valueOf(elMap.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true);
                    if (lat == vor.getLat() && lon == vor.getLon() && alt == vor.getAlt()) continue;
                    vor.setType("VOR");
                    Navaid n = vor.clone();
                    n.setType("DME");
                    List<Navaid> vors = importBean.getVors().get(key);
                    if (vors == null) {
                        vors = new LinkedList<Navaid>();
                    }
                    vors.add(n);
                    importBean.getVors().put(key, vors);
                }
            }
            List<Navaid> vors = importBean.getVors().get(key);
            if (vors == null) {
                vors = new LinkedList<Navaid>();
            }
            vors.add(vor);
            importBean.getVors().put(key, vors);
        }
        catch (NumberFormatException e) {
            log.error(e, e);
        }
    }

    private void importPreviousNext(Node routeNode, Route route) {
        NodeList children = routeNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            NamedNodeMap map;
            node = children.item(j);
            if (FS_NODE_PREVIOUS.equalsIgnoreCase(node.getNodeName())) {
                map = node.getAttributes();
                if (route.getPreviousIdent() != null || route.getPreviousRegion() != null) {
                    log.error("Route " + route.getName() + " has multiple previous tags!");
                }
                route.setPreviousRegion(map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION).getNodeValue());
                route.setPreviousIdent(map.getNamedItem(FS_NODE_MAP_WAYPOINT_IDENT).getNodeValue());
                continue;
            }
            if (!FS_NODE_NEXT.equalsIgnoreCase(node.getNodeName())) continue;
            map = node.getAttributes();
            if (route.getNextIdent() != null || route.getNextRegion() != null) {
                log.error("Route " + route.getName() + " has multiple next tags!");
            }
            route.setNextRegion(map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION).getNodeValue());
            route.setNextIdent(map.getNamedItem(FS_NODE_MAP_WAYPOINT_IDENT).getNodeValue());
        }
    }

    private void importRoutes(Node runwayNode, Waypoint waypoint) {
        NodeList children = runwayNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_ROUTE.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            Route r = new Route();
            if (map.getNamedItem(FS_NODE_MAP_NAME) != null) {
                r.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
            }
            this.importPreviousNext(node, r);
            waypoint.getRoutes().add(r);
        }
    }

    private void importWaypoint(Node node, BglImportBean importBean) {
        NamedNodeMap map = node.getAttributes();
        if (map.getNamedItem(FS_NODE_MAP_WAYPOINT_IDENT) != null) {
            List<Waypoint> waypoints;
            String ident = map.getNamedItem(FS_NODE_MAP_WAYPOINT_IDENT).getNodeValue().toUpperCase();
            double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
            double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
            GpsPlace newWaypoint = new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
            Waypoint wp = null;
            String region = null;
            if (map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION) != null) {
                region = map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION).getNodeValue().toUpperCase();
            }
            if (importBean.getWaypoints().get(region) != null) {
                Iterator<Waypoint> iterator = importBean.getWaypoints().get(region).iterator();
                while (iterator.hasNext()) {
                    double dist;
                    wp = iterator.next();
                    if (!ident.equals(wp.getIdent()) || !((dist = GpsUtil.getDistance(newWaypoint, wp.getGpsPlace())) <= 1.0)) continue;
                    iterator.remove();
                    break;
                }
            }
            wp = new Waypoint();
            wp.setIdent(ident);
            wp.setType(WaypointType.ROUTE);
            wp.setLat(lat);
            wp.setLon(lon);
            wp.setRegion(region);
            if (importBean.isImportRoutes()) {
                this.importRoutes(node, wp);
            }
            if ((waypoints = importBean.getWaypoints().get(region)) == null) {
                waypoints = new LinkedList<Waypoint>();
            }
            waypoints.add(wp);
            importBean.getWaypoints().put(region, waypoints);
        }
    }

    private void importNdb(NamedNodeMap map, BglImportBean importBean) {
        String ident = map.getNamedItem(FS_NODE_MAP_IDENT).getNodeValue().toUpperCase();
        try {
            List<Navaid> ndbs;
            double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
            double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
            String region = null;
            if (map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION) != null) {
                region = map.getNamedItem(FS_NODE_MAP_WAYPOINT_REGION).getNodeValue().toUpperCase();
            }
            if (importBean.getNdbs().get(region) != null) {
                GpsPlace newNdb = new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
                Navaid ndb = null;
                Iterator<Navaid> iterator = importBean.getNdbs().get(region).iterator();
                while (iterator.hasNext()) {
                    ndb = iterator.next();
                    double dist = GpsUtil.getDistance(newNdb, ndb.getGpsPlace());
                    if (!(dist <= 1.0)) continue;
                    iterator.remove();
                    break;
                }
            }
            Navaid ndb = new Navaid();
            ndb.setIdent(ident);
            ndb.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
            ndb.setLat(lat);
            ndb.setLon(lon);
            ndb.setAlt((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
            double freq = Double.valueOf(map.getNamedItem(FS_NODE_MAP_FREQUENCY).getNodeValue());
            ndb.setFreq((int)Math.round(freq * 10.0));
            ndb.setCountry(map.getNamedItem(FS_NODE_MAP_REGION).getNodeValue());
            ndb.setType("NDB");
            ndb.setRegion(region);
            if (map.getNamedItem(FS_NODE_MAP_MAGVAR) != null && map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue() != null) {
                ndb.setMagvar(-Double.valueOf(map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue()).doubleValue());
            }
            if ((ndbs = importBean.getNdbs().get(region)) == null) {
                ndbs = new LinkedList<Navaid>();
            }
            ndbs.add(ndb);
            importBean.getNdbs().put(region, ndbs);
        }
        catch (NumberFormatException e) {
            log.error(e, e);
        }
    }

    private void importAirports(Node node, BglImportBean importBean) {
        NamedNodeMap map = node.getAttributes();
        String ident = map.getNamedItem(FS_NODE_MAP_IDENT).getNodeValue().toUpperCase();
        String key = VfrUtil.getAirportsKey(ident);
        try {
            List<Airport> airports;
            double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
            double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
            Airport airportToReplace = null;
            if (importBean.getAirports().get(key) != null) {
                GpsPlace newAirport = new GpsPlace(new GpsCoord(lat), new GpsCoord(lon));
                Airport a = null;
                Iterator<Airport> iterator = importBean.getAirports().get(key).iterator();
                while (iterator.hasNext()) {
                    double dist;
                    a = iterator.next();
                    if (!ident.equalsIgnoreCase(a.getIdent()) || !((dist = GpsUtil.getDistance(newAirport, a.getGpsPlace())) <= 10.0)) continue;
                    airportToReplace = a;
                    iterator.remove();
                    break;
                }
            }
            Airport airport = new Airport();
            if (airportToReplace != null) {
                Iterator<Runway> deleteAirport = this.getDeleteAirportTag(node);
                airport.getTaxiNames().clear();
                if (!((BglImportDeleteAirport)((Object)deleteAirport)).isAllTrue()) {
                    log.debug("DeleteAirport: Not all flags are set to TRUE: " + deleteAirport);
                    airport = airportToReplace;
                    if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllFrequencies()) {
                        airport.getFrequencies().clear();
                    }
                    if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllRunways()) {
                        airport.getRunways().clear();
                    }
                    if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllAprons()) {
                        airport.getAprons().clear();
                    }
                    if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllTaxiways()) {
                        airport.getTaxiways().clear();
                    }
                    if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllStarts()) {
                        airport.getStarts().clear();
                        airport.setHeli(null);
                    } else if (((BglImportDeleteAirport)((Object)deleteAirport)).isDeleteAllHelipads()) {
                        Iterator<AirportStart> iterator = airport.getStarts().iterator();
                        while (iterator.hasNext()) {
                            AirportStart start = iterator.next();
                            if (start.getName() == null || start.getName().indexOf("(helipad)") < 0) continue;
                            iterator.remove();
                        }
                    }
                }
            }
            airport.setIdent(ident);
            if (map.getNamedItem(FS_NODE_MAP_NAME) != null) {
                airport.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
            }
            airport.setLat(lat);
            airport.setLon(lon);
            airport.setElev((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
            if (map.getNamedItem(FS_NODE_MAP_MAGVAR) != null) {
                airport.setMagvar(-Double.valueOf(map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue()).doubleValue());
            } else {
                log.error("Missing magvar for " + airport.getIdent());
            }
            airport.setId(this.airportService.getNextAirportsIdValue());
            if (importBean.isImportStarts()) {
                this.importStarts(node, airport);
            }
            if (importBean.isImportFrequencies()) {
                this.importFreq(node, airport);
            }
            if (importBean.isImportRunways()) {
                this.importRunways(node, airport, importBean);
            }
            if (importBean.isImportTaxiways()) {
                this.importTaxiways(node, airport);
                this.importAprons(node, airport);
            }
            if (importBean.isImportIls()) {
                if (airportToReplace != null && airport.getAllIls().size() == 0 && airportToReplace.getAllIls().size() > 0) {
                    for (Runway runway : airportToReplace.getRunways()) {
                        block5: for (Ils ils : runway.getIls()) {
                            int rwyNum = GpsUtil.getPrimaryRwyNumberFromHeading(ils.getMagHeading());
                            int secRwyNum = GpsUtil.getPrimaryRwyNumberFromHeading(ils.getMagHeading());
                            for (Runway rwy : airport.getRunways()) {
                                if (rwyNum != rwy.getNumber() && secRwyNum != rwy.getNumber()) continue;
                                rwy.getIls().add(ils);
                                continue block5;
                            }
                        }
                    }
                }
                for (Runway r : airport.getRunways()) {
                    if (!r.hasIls()) continue;
                    airport.setIls(Boolean.TRUE);
                    break;
                }
            }
            if ((airports = importBean.getAirports().get(key)) == null) {
                airports = new LinkedList<Airport>();
            }
            airports.add(airport);
            importBean.getAirports().put(key, airports);
        }
        catch (NumberFormatException e) {
            log.error(e, e);
        }
    }

    public Character getNavaidsKey(String ident) {
        if (ident == null) {
            return null;
        }
        return Character.valueOf(ident.charAt(0));
    }

    private void importRunways(Node airportNode, Airport airport, BglImportBean importBean) {
        double maxLength = 0.0;
        double heading = 0.0;
        double lat = 0.0;
        double lon = 0.0;
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            NamedNodeMap map;
            node = children.item(j);
            if (FS_NODE_RUNWAY.equalsIgnoreCase(node.getNodeName())) {
                map = node.getAttributes();
                try {
                    RunwayDesignator rd;
                    Runway runway = new Runway();
                    runway.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                    runway.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                    runway.setElev((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
                    runway.setHeading(Double.valueOf(map.getNamedItem(FS_NODE_MAP_HEADING).getNodeValue()));
                    if (airport.getMagvar() != null) {
                        runway.setHeading(GpsUtil.normalizeCourse(runway.getHeading() - airport.getMagvar()));
                    }
                    try {
                        runway.setSurface(Surface.valueOf(map.getNamedItem(FS_NODE_MAP_SURFACE).getNodeValue()));
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Unknown AirportRunwaysSurface: " + map.getNamedItem(FS_NODE_MAP_SURFACE).getNodeValue());
                    }
                    runway.setLength(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LENGTH).getNodeValue()));
                    runway.setWidth(Double.valueOf(map.getNamedItem(FS_NODE_MAP_WIDTH).getNodeValue()));
                    try {
                        runway.setNumber(Integer.valueOf(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue()));
                    }
                    catch (NumberFormatException e) {
                        runway.setNumber(RUNWAY_NUMBER_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue()));
                    }
                    if (map.getNamedItem(FS_NODE_MAP_DESIGNATOR) != null && !FS_NODE_MAP_NONE.equals(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue())) {
                        rd = RUNWAY_DESIGNATOR_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue());
                        if (rd != null) {
                            runway.setDesignator(rd);
                            if (RunwayDesignator.L.equals((Object)rd)) {
                                runway.setSecondaryDesignator(RunwayDesignator.R);
                            } else if (RunwayDesignator.R.equals((Object)rd)) {
                                runway.setSecondaryDesignator(RunwayDesignator.L);
                            } else {
                                runway.setSecondaryDesignator(rd);
                            }
                        } else {
                            log.debug("Unknown RunwayDesignator: " + map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue());
                        }
                    }
                    if (map.getNamedItem(FS_NODE_MAP_PRIMARY_DESIGNATOR) != null && !FS_NODE_MAP_NONE.equals(map.getNamedItem(FS_NODE_MAP_PRIMARY_DESIGNATOR).getNodeValue())) {
                        rd = RUNWAY_DESIGNATOR_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_PRIMARY_DESIGNATOR).getNodeValue());
                        if (rd != null) {
                            runway.setDesignator(rd);
                        } else {
                            log.debug("Unknown (primary) RunwayDesignator: " + map.getNamedItem(FS_NODE_MAP_PRIMARY_DESIGNATOR).getNodeValue());
                        }
                    }
                    if (map.getNamedItem(fS_NODE_MAP_SECONDARY_DESIGNATOR) != null && !FS_NODE_MAP_NONE.equals(map.getNamedItem(fS_NODE_MAP_SECONDARY_DESIGNATOR).getNodeValue())) {
                        rd = RUNWAY_DESIGNATOR_MAPPINGS.get(map.getNamedItem(fS_NODE_MAP_SECONDARY_DESIGNATOR).getNodeValue());
                        if (rd != null) {
                            runway.setSecondaryDesignator(rd);
                        } else {
                            log.debug("Unknown (secondary) RunwayDesignator: " + map.getNamedItem(fS_NODE_MAP_SECONDARY_DESIGNATOR).getNodeValue());
                        }
                    }
                    runway.setId(this.airportService.getNextAirportRunwaysIdValue());
                    if (importBean.isImportIls()) {
                        this.importIls(node, runway, airport.getIdent(), importBean);
                    }
                    if (airport.getMagvar() == null) {
                        runway.setMagvar(0.0);
                        log.error("Missing magvar for airport/runway");
                    } else {
                        runway.setMagvar(airport.getMagvar());
                    }
                    airport.getRunways().add(runway);
                    if (!(runway.getLength() >= maxLength)) continue;
                    maxLength = runway.getLength();
                    heading = runway.getHeading();
                    lat = runway.getLat();
                    lon = runway.getLon();
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (!FS_NODE_DELETE_RUNWAY.equalsIgnoreCase(node.getNodeName())) continue;
            map = node.getAttributes();
            try {
                RunwayDesignator designator = null;
                if (map.getNamedItem(FS_NODE_MAP_DESIGNATOR) != null && !FS_NODE_MAP_NONE.equals(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue())) {
                    designator = RUNWAY_DESIGNATOR_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue());
                }
                Integer number = null;
                try {
                    number = Integer.valueOf(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue());
                }
                catch (NumberFormatException e) {
                    number = RUNWAY_NUMBER_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue());
                }
                Surface surface = null;
                try {
                    surface = Surface.valueOf(map.getNamedItem(FS_NODE_MAP_SURFACE).getNodeValue());
                }
                catch (IllegalArgumentException e) {
                    log.debug("Unknown AirportRunwaysSurface: " + map.getNamedItem(FS_NODE_MAP_SURFACE).getNodeValue());
                }
                Iterator<Runway> iterator = airport.getRunways().iterator();
                while (iterator.hasNext()) {
                    Runway rwy = iterator.next();
                    if ((rwy.getDesignator() != null || designator != null) && (rwy.getDesignator() == null || designator == null || !rwy.getDesignator().equals((Object)designator)) || (rwy.getNumber() != null || number != null) && (rwy.getNumber() == null || number == null || !rwy.getNumber().equals(number)) || (rwy.getSurface() != null || surface != null) && (rwy.getSurface() == null || surface == null || !rwy.getSurface().equals((Object)surface))) continue;
                    log.debug("DeleteRunway: " + (Object)((Object)designator) + "; " + number + "; " + (Object)((Object)surface));
                    iterator.remove();
                }
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        if (heading > 0.0) {
            if (airport.getMagvar() != null) {
                airport.setMainRwy((int)Math.round(GpsUtil.normalizeCourse(heading + airport.getMagvar())));
            } else {
                airport.setMainRwy((int)Math.round(heading));
            }
            airport.setMainLength((int)Math.round(maxLength));
            airport.setLat(lat);
            airport.setLon(lon);
        }
    }

    private void importIls(Node runwayNode, Runway runway, String airportCode, BglImportBean importBean) {
        NodeList children = runwayNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_ILS.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            try {
                Ils ils = new Ils();
                ils.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                ils.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                ils.setAlt((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
                ils.setHeading(Double.valueOf(map.getNamedItem(FS_NODE_MAP_HEADING).getNodeValue()));
                ils.setFrequency(Double.valueOf(map.getNamedItem(FS_NODE_MAP_FREQUENCY).getNodeValue()));
                ils.setMagvar(-Double.valueOf(map.getNamedItem(FS_NODE_MAP_MAGVAR).getNodeValue()).doubleValue());
                if (map.getNamedItem(FS_NODE_MAP_WIDTH) != null) {
                    ils.setWidth(Double.valueOf(map.getNamedItem(FS_NODE_MAP_WIDTH).getNodeValue()));
                }
                if (map.getNamedItem(FS_NODE_MAP_NAME) != null) {
                    ils.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
                }
                ils.setIdent(map.getNamedItem(FS_NODE_MAP_IDENT).getNodeValue());
                this.importIlsGlideSlopeDme(node, ils, importBean);
                Iterator<Ils> iterator = runway.getIls().iterator();
                while (iterator.hasNext()) {
                    Ils i = iterator.next();
                    if (!(Math.abs(ils.getHeading() - i.getHeading()) < 30.0)) continue;
                    iterator.remove();
                }
                runway.getIls().add(ils);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    private void importIlsGlideSlopeDme(Node ilsNode, Ils ils, BglImportBean importBean) {
        NodeList children = ilsNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            NamedNodeMap map;
            node = children.item(j);
            if (FS_NODE_GS.equalsIgnoreCase(node.getNodeName())) {
                ils.setGs(true);
                map = node.getAttributes();
                try {
                    if (map.getNamedItem(FS_NODE_MAP_PITCH) == null) continue;
                    ils.setPitch(Double.valueOf(map.getNamedItem(FS_NODE_MAP_PITCH).getNodeValue()));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (!FS_NODE_DME.equalsIgnoreCase(node.getNodeName())) continue;
            ils.setDme(true);
            map = node.getAttributes();
            try {
                double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                Navaid dme = new Navaid();
                dme.setIdent(ils.getIdent());
                dme.setRemark("ILS");
                dme.setLat(lat);
                dme.setLon(lon);
                dme.setType("DME");
                dme.setAlt(ils.getAlt());
                dme.setFreq((int)Math.round(ils.getFrequency() * 1000.0));
                Character key = this.getNavaidsKey(dme.getIdent());
                boolean exists = false;
                GpsPlace newDme = dme.getGpsPlace();
                if (importBean.getVors().get(key) != null) {
                    for (Navaid n : importBean.getVors().get(key)) {
                        double dist;
                        if (!n.isDme() || !((dist = GpsUtil.getDistance(newDme, n.getGpsPlace())) <= 1.0) || !dme.getIdent().equals(n.getIdent())) continue;
                        exists = true;
                        break;
                    }
                }
                if (exists) continue;
                List<Navaid> vors = importBean.getVors().get(key);
                if (vors == null) {
                    vors = new LinkedList<Navaid>();
                }
                vors.add(dme);
                importBean.getVors().put(key, vors);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    private Map<String, GpsPlace> getTaxiwayPoints(Node airportNode) {
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        HashMap<String, GpsPlace> points = new HashMap<String, GpsPlace>();
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_TAXIWAY_POINT.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            try {
                GpsPlace place = new GpsPlace(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()), Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                String index = map.getNamedItem(FS_NODE_MAP_INDEX).getNodeValue();
                points.put(index, place);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        return points;
    }

    private Map<String, String> getTaxiwayNames(Node airportNode) {
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        HashMap<String, String> names = new HashMap<String, String>();
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_TAXI_NAME.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            String index = map.getNamedItem(FS_NODE_MAP_INDEX).getNodeValue();
            String name = map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue();
            names.put(index, name);
        }
        return names;
    }

    private void importTaxiways(Node airportNode, Airport airport) {
        Map<String, GpsPlace> points = this.getTaxiwayPoints(airportNode);
        Map<String, String> names = this.getTaxiwayNames(airportNode);
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            NamedNodeMap map;
            node = children.item(j);
            if (!FS_NODE_TAXIWAY_PATH.equalsIgnoreCase(node.getNodeName()) || (map = node.getAttributes()).getNamedItem(FS_NODE_MAP_TYPE) == null || !"TAXI".equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue())) continue;
            try {
                Taxiway taxiway = new Taxiway();
                GpsPlace from = points.get(map.getNamedItem(FS_NODE_MAP_START).getNodeValue());
                GpsPlace to = points.get(map.getNamedItem(FS_NODE_MAP_END).getNodeValue());
                if (from != null && to != null) {
                    taxiway.setFromLat(from.getLat().getValue());
                    taxiway.setFromLon(from.getLon().getValue());
                    taxiway.setToLat(to.getLat().getValue());
                    taxiway.setToLon(to.getLon().getValue());
                    taxiway.setWidth(Double.valueOf(map.getNamedItem(FS_NODE_MAP_WIDTH).getNodeValue()));
                    String index = map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue();
                    taxiway.setName(names.get(index));
                    airport.getTaxiways().add(taxiway);
                    if (StringUtil.isEmpty(taxiway.getName())) continue;
                    airport.getTaxiNames().add(new TaxiName(taxiway));
                    continue;
                }
                log.debug("Invalid taxiway path for airport (from or to is null!)" + airport.getIdent());
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        VfrUtil.optimizeTaxiNames(airport);
    }

    private void importAprons(Node airportNode, Airport airport) {
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int k = 0; k < children.getLength(); ++k) {
            node = children.item(k);
            if (!FS_NODE_APRONS.equalsIgnoreCase(node.getNodeName())) continue;
            NodeList apronsChildren = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                node = apronsChildren.item(j);
                if (node == null || node.getNodeName() == null || !FS_NODE_APRON.equalsIgnoreCase(node.getNodeName())) continue;
                try {
                    Apron a = new Apron();
                    a.setId(this.airportService.getNextApronsIdValue());
                    this.importApronVertices(node, a);
                    airport.getAprons().add(a);
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
        }
    }

    private void importApronVertices(Node apronNode, Apron apron) {
        NodeList children = apronNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_VERTEX.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            try {
                ApronVertex v = new ApronVertex();
                v.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                v.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                apron.getVertices().add(v);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    private void importFreq(Node airportNode, Airport airport) {
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            NamedNodeMap map;
            node = children.item(j);
            if (FS_NODE_COM.equalsIgnoreCase(node.getNodeName())) {
                map = node.getAttributes();
                try {
                    AirportFreq freq = new AirportFreq();
                    freq.setFrequency(Double.valueOf(map.getNamedItem(FS_NODE_MAP_FREQUENCY).getNodeValue()));
                    freq.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
                    try {
                        String type = map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue();
                        if (!FS_NODE_MAP_SPARSE.equals(type) && !FS_NODE_MAP_VERY_SPARSE.equals(type)) {
                            freq.setType(AirportFreqType.valueOf(type));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Unknown AirportFreqType: " + map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue());
                    }
                    airport.getFrequencies().add(freq);
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (!FS_NODE_DELETE_FREQUENCY.equalsIgnoreCase(node.getNodeName())) continue;
            map = node.getAttributes();
            try {
                double freq = Double.valueOf(map.getNamedItem(FS_NODE_MAP_FREQUENCY).getNodeValue());
                AirportFreqType type = null;
                try {
                    String t = map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue();
                    if (!FS_NODE_MAP_SPARSE.equals(t) && !FS_NODE_MAP_VERY_SPARSE.equals(t)) {
                        type = AirportFreqType.valueOf(t);
                    }
                }
                catch (IllegalArgumentException e) {
                    log.debug("Unknown AirportFreqType: " + map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue());
                }
                Iterator<AirportFreq> iterator = airport.getFrequencies().iterator();
                while (iterator.hasNext()) {
                    AirportFreq f = iterator.next();
                    if (f.getFrequency() == null || f.getFrequency() != freq || (f.getType() != null || type != null) && (f.getType() == null || type == null || !f.getType().equals((Object)type))) continue;
                    log.debug("DeleteFrequency: " + freq + "; " + (Object)((Object)type));
                    iterator.remove();
                }
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    private BglImportDeleteAirport getDeleteAirportTag(Node airportNode) {
        BglImportDeleteAirport result = new BglImportDeleteAirport();
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            node = children.item(j);
            if (!FS_NODE_DELETE_AIRPORT.equalsIgnoreCase(node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            if (map.getNamedItem(FS_NODE_DELETE_ALL_FREQUENCIES) != null) {
                result.setDeleteAllFrequencies(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_FREQUENCIES).getNodeValue()));
            }
            if (map.getNamedItem(FS_NODE_DELETE_ALL_HELIPADS) != null) {
                result.setDeleteAllHelipads(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_HELIPADS).getNodeValue()));
            }
            if (map.getNamedItem(FS_NODE_DELETE_ALL_RUNWAYS) != null) {
                result.setDeleteAllRunways(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_RUNWAYS).getNodeValue()));
            }
            if (map.getNamedItem(FS_NODE_DELETE_ALL_STARTS) != null) {
                result.setDeleteAllStarts(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_STARTS).getNodeValue()));
            }
            if (map.getNamedItem(FS_NODE_DELETE_ALL_APRONS) != null) {
                result.setDeleteAllAprons(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_APRONS).getNodeValue()));
            }
            if (map.getNamedItem(FS_NODE_DELETE_ALL_TAXIWAYS) == null) continue;
            result.setDeleteAllTaxiways(FS_NODE_MAP_TRUE.equalsIgnoreCase(map.getNamedItem(FS_NODE_DELETE_ALL_TAXIWAYS).getNodeValue()));
        }
        return result;
    }

    private void importStarts(Node airportNode, Airport airport) {
        NodeList children = airportNode.getChildNodes();
        Node node = null;
        for (int j = 0; j < children.getLength(); ++j) {
            boolean helipad;
            boolean water;
            AirportStart start;
            NamedNodeMap map;
            node = children.item(j);
            if (FS_NODE_START.equalsIgnoreCase(node.getNodeName())) {
                map = node.getAttributes();
                try {
                    start = new AirportStart();
                    start.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                    start.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                    start.setElev((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
                    start.setHeading(Double.valueOf(map.getNamedItem(FS_NODE_MAP_HEADING).getNodeValue()));
                    if (map.getNamedItem(FS_NODE_MAP_DESIGNATOR) != null && !FS_NODE_MAP_NONE.equals(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue())) {
                        RunwayDesignator rd = RUNWAY_DESIGNATOR_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue());
                        if (rd != null) {
                            start.setDesignator(rd);
                        } else {
                            log.debug("Unknown RunwayDesignator: " + map.getNamedItem(FS_NODE_MAP_DESIGNATOR).getNodeValue());
                        }
                    }
                    water = map.getNamedItem(FS_NODE_MAP_TYPE) != null && map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue() != null && FS_NODE_MAP_WATER.equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue().toString());
                    boolean bl = helipad = map.getNamedItem(FS_NODE_MAP_TYPE) != null && map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue() != null && FS_NODE_MAP_HELIPAD.equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue().toString());
                    if (map.getNamedItem(FS_NODE_MAP_NUMBER) != null) {
                        try {
                            start.setNumber(Integer.valueOf(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue()));
                            start.setName(start.getNumber().toString());
                            if (start.getDesignator() != null) {
                                start.setName(start.getName() + (Object)((Object)start.getDesignator()));
                            }
                        }
                        catch (NumberFormatException e) {
                            start.setNumber(RUNWAY_NUMBER_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue()));
                        }
                    }
                    if (helipad) {
                        start.setName(start.getName() + FS_NODE_MAP_HELIPAD_NAME);
                        airport.setHeli(Boolean.TRUE);
                    }
                    if (water) {
                        start.setName(start.getName() + FS_NODE_MAP_WATER_NAME);
                    }
                    airport.getStarts().add(start);
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (FS_NODE_MAP_HELIPAD.equalsIgnoreCase(node.getNodeName())) {
                map = node.getAttributes();
                try {
                    start = new AirportStart();
                    start.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                    start.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                    start.setElev((int)UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT).getNodeValue()), "m", "ft", true));
                    start.setHeading(Double.valueOf(map.getNamedItem(FS_NODE_MAP_HEADING).getNodeValue()));
                    start.setName(FS_NODE_MAP_HELIPAD_NAME.trim());
                    airport.setHeli(Boolean.TRUE);
                    airport.getStarts().add(start);
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (!FS_NODE_TAXIWAY_PARKING.equalsIgnoreCase(node.getNodeName())) continue;
            map = node.getAttributes();
            try {
                start = new AirportStart();
                start.setLat(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue()));
                start.setLon(Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue()));
                start.setElev(airport.getElev());
                water = map.getNamedItem(FS_NODE_MAP_TYPE) != null && map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue() != null && FS_NODE_MAP_WATER.equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue().toString());
                helipad = map.getNamedItem(FS_NODE_MAP_TYPE) != null && map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue() != null && FS_NODE_MAP_HELIPAD.equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue().toString());
                start.setHeading(Double.valueOf(map.getNamedItem(FS_NODE_MAP_HEADING).getNodeValue()));
                String number = map.getNamedItem(FS_NODE_MAP_NUMBER).getNodeValue();
                String name = map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue().replace("_", " ");
                String type = map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue().replace("_", " ");
                start.setName(name + " " + number + " -- " + type);
                if (helipad) {
                    start.setName(start.getName() + FS_NODE_MAP_HELIPAD_NAME);
                    airport.setHeli(Boolean.TRUE);
                }
                if (water) {
                    start.setName(start.getName() + FS_NODE_MAP_WATER_NAME);
                }
                airport.getStarts().add(start);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    private void importGeopol(Node node, BglImportBean importBean) {
        NamedNodeMap map = node.getAttributes();
        if (map.getNamedItem(FS_NODE_MAP_TYPE) != null && "BOUNDARY".equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue())) {
            AirspaceArea area = new AirspaceArea(AirspaceType.GEOPOL);
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node vertexNode = node.getChildNodes().item(i);
                if (!FS_NODE_VERTEX.equalsIgnoreCase(vertexNode.getNodeName())) continue;
                map = vertexNode.getAttributes();
                try {
                    double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                    double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                    area.getVertices().add(new AirspaceAreaVertex(lat, (Double)lon));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            importBean.getAirspaces().add(area);
        }
    }

    private void importBoundary(Node node, BglImportBean importBean) {
        NamedNodeMap map = node.getAttributes();
        AirspaceType at = null;
        if (map.getNamedItem(FS_NODE_MAP_TYPE) != null && (at = AirspaceType.valueOf(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue())) == null) {
            log.error("Unknown AirspaceType: " + map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue());
        }
        if (at != null) {
            AirspaceArea area = new AirspaceArea(at);
            if (map.getNamedItem(FS_NODE_MAP_NAME) != null) {
                area.setName(map.getNamedItem(FS_NODE_MAP_NAME).getNodeValue());
            }
            boolean boundaryStartFound = false;
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                double lon;
                Node boundaryNode = node.getChildNodes().item(i);
                if (FS_NODE_BOUNDARY_START.equalsIgnoreCase(boundaryNode.getNodeName())) {
                    map = boundaryNode.getAttributes();
                    try {
                        double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                        lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                        area.getVertices().add(new AirspaceAreaVertex(lat, (Double)lon));
                        if (map.getNamedItem(FS_NODE_MAP_MINIMUM_ALT_TYPE) != null) {
                            area.setBottomAltitudeType(ALTITUDE_TYPE_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_MINIMUM_ALT_TYPE).getNodeValue()));
                        }
                        if (map.getNamedItem(FS_NODE_MAP_MAXIMUM_ALT_TYPE) != null) {
                            area.setTopAltitudeType(ALTITUDE_TYPE_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_MAXIMUM_ALT_TYPE).getNodeValue()));
                        }
                        if (AltitudeType.UNLIMITED != area.getBottomAltitudeType()) {
                            area.setBottomAltitude((int)Math.round(UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT_MINIMUM).getNodeValue()), "m", "ft", false)));
                        }
                        if (AltitudeType.UNLIMITED != area.getTopAltitudeType()) {
                            area.setTopAltitude((int)Math.round(UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT_MAXIMUM).getNodeValue()), "m", "ft", false)));
                        }
                        boundaryStartFound = true;
                    }
                    catch (NumberFormatException e) {
                        log.error(e, e);
                    }
                    continue;
                }
                if (!FS_NODE_ORIGIN.equalsIgnoreCase(boundaryNode.getNodeName())) continue;
                map = boundaryNode.getAttributes();
                try {
                    double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                    lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                    area.getOrigins().add(new GeoPosition(lat, lon));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (boundaryStartFound) {
                this.importBoundaryData(node, area);
                importBean.getAirspaces().add(area);
            } else {
                boolean circleFound = false;
                for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                    Node boundaryNode = node.getChildNodes().item(i);
                    if (!FS_NODE_CIRCLE.equalsIgnoreCase(boundaryNode.getNodeName())) continue;
                    map = boundaryNode.getAttributes();
                    try {
                        int index = Integer.valueOf(map.getNamedItem(FS_NODE_MAP_INDEX).getNodeValue());
                        if (index < area.getOrigins().size()) {
                            area.setCircleCenterLat(area.getOrigins().get(index).getLatitude());
                            area.setCircleCenterLon(area.getOrigins().get(index).getLongitude());
                            area.setRadius(UnitUtil.recalculateDistance(Double.valueOf(map.getNamedItem(FS_NODE_MAP_RADIUS).getNodeValue()) / 1000.0, "km", "nm", false));
                            if (map.getNamedItem(FS_NODE_MAP_MINIMUM_ALT_TYPE) != null) {
                                area.setBottomAltitudeType(ALTITUDE_TYPE_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_MINIMUM_ALT_TYPE).getNodeValue()));
                            }
                            if (map.getNamedItem(FS_NODE_MAP_MAXIMUM_ALT_TYPE) != null) {
                                area.setTopAltitudeType(ALTITUDE_TYPE_MAPPINGS.get(map.getNamedItem(FS_NODE_MAP_MAXIMUM_ALT_TYPE).getNodeValue()));
                            }
                            if (AltitudeType.UNLIMITED != area.getBottomAltitudeType()) {
                                area.setBottomAltitude((int)Math.round(UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT_MINIMUM).getNodeValue()), "m", "ft", false)));
                            }
                            if (AltitudeType.UNLIMITED != area.getTopAltitudeType()) {
                                area.setTopAltitude((int)Math.round(UnitUtil.recalculateAltitude(Double.valueOf(map.getNamedItem(FS_NODE_MAP_ALT_MAXIMUM).getNodeValue()), "m", "ft", false)));
                            }
                            circleFound = true;
                            continue;
                        }
                        log.error("CIRCLE: Origin index out of range: " + index);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        log.error(e, e);
                    }
                }
                if (circleFound) {
                    importBean.getAirspaces().add(area);
                } else {
                    log.error("Couldn't find boundary start nor circle element for " + area.getName());
                }
            }
        }
    }

    private void importBoundaryData(Node node, AirspaceArea area) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            NamedNodeMap map;
            Node boundaryNode = node.getChildNodes().item(i);
            if (FS_NODE_LINE.equalsIgnoreCase(boundaryNode.getNodeName())) {
                map = boundaryNode.getAttributes();
                try {
                    double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                    double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                    area.getVertices().add(new AirspaceAreaVertex(lat, (Double)lon));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
                continue;
            }
            if (!FS_NODE_ARC.equalsIgnoreCase(boundaryNode.getNodeName())) continue;
            map = boundaryNode.getAttributes();
            try {
                int index = Integer.valueOf(map.getNamedItem(FS_NODE_MAP_INDEX).getNodeValue());
                if (index < area.getOrigins().size()) {
                    double lat = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LAT).getNodeValue());
                    double lon = Double.valueOf(map.getNamedItem(FS_NODE_MAP_LON).getNodeValue());
                    AirspaceAreaVertex vertex = new AirspaceAreaVertex(area.getOrigins().get(index).getLatitude(), (Double)area.getOrigins().get(index).getLongitude());
                    if (map.getNamedItem(FS_NODE_MAP_TYPE) != null) {
                        vertex.setClockwise(FS_NODE_MAP_CLOCKWISE.equals(map.getNamedItem(FS_NODE_MAP_TYPE).getNodeValue()));
                    }
                    vertex.setRadius(GpsUtil.getDistance(vertex.getGpsPlace(), new GpsPlace(new GpsCoord(lat), new GpsCoord(lon))));
                    area.getVertices().add(vertex);
                    area.getVertices().add(new AirspaceAreaVertex(lat, (Double)lon));
                    continue;
                }
                log.error("ARC: Origin index out of range: " + index);
                continue;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean bglFileHasData(String filename, BglImportBean importBean) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int insertAirports(BglImportBean importBean, int from, int to) {
        MapFacade mapFacade = new MapFacade(this.dataSource);
        List<Airport> airports = importBean.getAirportsAsList();
        List<Elevation> elevations = mapFacade.findElevations(0);
        this.setMountanousAirports(airports, elevations);
        this.setHardenedAirports(airports);
        if (importBean.isImportNavaids()) {
            this.setNdbVorAirports(airports, importBean.getVorsAsList(), importBean.getNdbsAsList());
        }
        PleaseWaitDialog.getInstance().setProgress(from + 1);
        int totalNum = 0;
        for (Map.Entry<String, List<Airport>> pairs : importBean.getAirports().entrySet()) {
            totalNum += pairs.getValue().size();
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Map.Entry<String, List<Airport>> pairs : importBean.getAirports().entrySet()) {
            for (Airport a : pairs.getValue()) {
                this.airportService.insertAirport(a, session);
                PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
                if (i % 100 == 0) {
                    HibernateUtil.checkAvailableMemory();
                }
                ++i;
            }
        }
        session.flush();
        session.close();
        return i;
    }

    public int insertVors(BglImportBean importBean, int from, int to) {
        int totalNum = 0;
        for (Map.Entry<Character, List<Navaid>> pairs : importBean.getVors().entrySet()) {
            totalNum += pairs.getValue().size();
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Map.Entry<Character, List<Navaid>> pairs : importBean.getVors().entrySet()) {
            for (Navaid n : pairs.getValue()) {
                this.navaidService.insertNavaid(n, session);
                PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
                if (i % 100 == 0) {
                    HibernateUtil.checkAvailableMemory();
                }
                ++i;
            }
        }
        session.flush();
        session.close();
        return i;
    }

    public int insertNdbs(BglImportBean importBean, int from, int to) {
        int totalNum = 0;
        for (Map.Entry<Character, List<Navaid>> pairs : importBean.getVors().entrySet()) {
            totalNum += pairs.getValue().size();
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Map.Entry<String, List<Navaid>> pairs : importBean.getNdbs().entrySet()) {
            for (Navaid n : pairs.getValue()) {
                this.navaidService.insertNavaid(n, session);
                PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
                if (i % 100 == 0) {
                    HibernateUtil.checkAvailableMemory();
                }
                ++i;
            }
        }
        session.flush();
        session.close();
        return i;
    }

    public int insertWaypoints(BglImportBean importBean, int from, int to) {
        int totalNum = 0;
        for (Map.Entry<String, List<Waypoint>> pairs : importBean.getWaypoints().entrySet()) {
            totalNum += pairs.getValue().size();
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Map.Entry<String, List<Waypoint>> pairs : importBean.getWaypoints().entrySet()) {
            for (Waypoint w : pairs.getValue()) {
                this.ifrRouteService.insertWaypoint(w, session);
                PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
                if (i % 100 == 0) {
                    HibernateUtil.checkAvailableMemory();
                }
                ++i;
            }
        }
        session.flush();
        session.close();
        return i;
    }

    public int insertRoutes(BglImportBean importBean, int from, int to) {
        int totalNum = 0;
        for (Map.Entry<String, List<Waypoint>> pairs : importBean.getWaypoints().entrySet()) {
            totalNum += pairs.getValue().size();
        }
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (Map.Entry<String, List<Waypoint>> pairs : importBean.getWaypoints().entrySet()) {
            for (Waypoint w : pairs.getValue()) {
                PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
                for (Route r : w.getRoutes()) {
                    Waypoint prev = BglImportUtil.findWaypointId(r.getPreviousIdent(), r.getPreviousRegion(), importBean);
                    Waypoint next = BglImportUtil.findWaypointId(r.getNextIdent(), r.getNextRegion(), importBean);
                    if (prev != null) {
                        Route r1 = new Route();
                        r1.setName(r.getName());
                        r1.setFromLat(prev.getLat());
                        r1.setFromLon(prev.getLon());
                        r1.setToLat(w.getLat());
                        r1.setToLon(w.getLon());
                        this.ifrRouteService.insertRoute(r1, session);
                    }
                    if (next != null) {
                        Route r2 = new Route();
                        r2.setName(r.getName());
                        r2.setFromLat(w.getLat());
                        r2.setFromLon(w.getLon());
                        r2.setToLat(next.getLat());
                        r2.setToLon(next.getLon());
                        this.ifrRouteService.insertRoute(r2, session);
                    }
                    if (i % 100 == 0) {
                        HibernateUtil.checkAvailableMemory();
                    }
                    ++i;
                }
            }
        }
        session.flush();
        session.close();
        return i;
    }

    public int insertBoundaries(BglImportBean importBean, int from, int to) {
        int totalNum = importBean.getAirspaces().size();
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (AirspaceArea a : importBean.getAirspaces()) {
            PleaseWaitDialog.getInstance().setProgress(from + (int)Math.round((double)i * (double)(to - from - 1) / (double)totalNum));
            this.airspaceService.insertAirspace(a, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        return i;
    }

    static {
        HashMap<String, Enum> mp = new HashMap<String, Enum>();
        mp.put("UNKNOWN", AltitudeType.UNKNOWN);
        mp.put("AGL", AltitudeType.AGL);
        mp.put("ABOVE_GROUND_LEVEL", AltitudeType.AGL);
        mp.put("MSL", AltitudeType.MSL);
        mp.put("MEAN_SEA_LEVEL", AltitudeType.MSL);
        mp.put("UNLIMITED", AltitudeType.UNLIMITED);
        ALTITUDE_TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("EAST", 9);
        map.put("NORTH", 36);
        map.put("NORTHEAST", 5);
        map.put("NORTHWEST", 32);
        map.put("SOUTH", 18);
        map.put("SOUTHEAST", 14);
        map.put("SOUTHWEST", 23);
        map.put("WEST", 27);
        RUNWAY_NUMBER_MAPPINGS = Collections.unmodifiableMap(map);
        mp = new HashMap();
        mp.put("C", RunwayDesignator.C);
        mp.put("CENTER", RunwayDesignator.C);
        mp.put("L", RunwayDesignator.L);
        mp.put("LEFT", RunwayDesignator.L);
        mp.put("R", RunwayDesignator.R);
        mp.put("RIGHT", RunwayDesignator.R);
        mp.put("W", RunwayDesignator.W);
        mp.put("WATER", RunwayDesignator.W);
        mp.put("A", RunwayDesignator.A);
        mp.put("B", RunwayDesignator.B);
        RUNWAY_DESIGNATOR_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

