/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.filter.AirspaceFilter;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.AirspaceService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.MapUtil;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class AirspaceFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(AirspaceFacade.class);
    private final SqlService sqlService;
    private final AirspaceService airspaceService;

    public AirspaceFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.airspaceService = new AirspaceService(dataSource);
    }

    public long getAirspacesNumber() {
        return this.sqlService.countRecordsInTable(AirspaceArea.class.getName());
    }

    public boolean truncateAirspaceAreaVerticesTable() {
        return this.sqlService.truncateTable("airspace_area_vertex");
    }

    public boolean truncateAirspacesTable() {
        return this.truncateAirspaceAreaVerticesTable() && this.sqlService.truncateTable("airspace_area");
    }

    public void insertAirspace(AirspaceArea a, Session session) {
        this.airspaceService.insertAirspace(a, session);
    }

    public void importAirspacesFromXml(String file) {
        log.info("Importing airspaces from " + file);
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        airspaceFacade.truncateAirspacesTable();
        List<AirspaceArea> airspaces = AirspacesUtil.loadAirspaces(file);
        Session session = this.dataSource.getHibernateSession();
        int i = 0;
        for (AirspaceArea a : airspaces) {
            airspaceFacade.insertAirspace(a, session);
            if (i % 100 == 0) {
                HibernateUtil.checkAvailableMemory();
            }
            ++i;
        }
        session.flush();
        session.close();
        log.info("Finished importing " + airspaces.size() + " airspaces.");
    }

    public AirspaceArea findAirspaceAreaById(Integer id) {
        return this.airspaceService.findAirspaceAreaById(id);
    }

    public void changeAirspaceAreaParent(Integer id, Integer parentId) {
        this.airspaceService.changeAirspaceAreaParent(id, parentId);
    }

    public void updateAirspaceArea(AirspaceArea dbArea, Session session) {
        this.airspaceService.updateAirspaceArea(dbArea, session);
    }

    public void deleteAirspaceById(int airspaceAreaId) {
        this.airspaceService.deleteAirspaceAreaById(airspaceAreaId);
    }

    public void deleteAirspacesByType(AirspaceType type) {
        this.airspaceService.deleteAirspacesByType(type);
    }

    public AirspaceArea findAirspaceById(int id) {
        return this.airspaceService.findAirspaceById(id);
    }

    public int getAirspaceRecentId() {
        return this.airspaceService.getAirspaceRecentId();
    }

    public void updateAirspace(AirspaceArea airspace, Session session) {
        this.airspaceService.updateAirspace(airspace, session);
    }

    public List<AirspaceArea> findAirspaces(AirspaceFilter filter) {
        return this.airspaceService.findAirspaces(filter);
    }

    public void insertAirspaces(List<AirspaceArea> airspaces, boolean truncateTable) {
        if (truncateTable) {
            this.truncateAirspacesTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (AirspaceArea a : airspaces) {
            this.airspaceService.insertAirspace(a, session);
        }
        session.clear();
        session.flush();
    }

    public void deleteAirspaceAreas(VfrMapViewer map, String name, AirspaceType type, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        List<AirspaceArea> areas = this.airspaceService.findAirspaces(new AirspaceFilter(name, type, true));
        if (minLat == null) {
            minLat = -200.0;
        }
        if (maxLat == null) {
            maxLat = 200.0;
        }
        if (minLon == null) {
            minLon = -200.0;
        }
        if (maxLon == null) {
            maxLon = 200.0;
        }
        GpsArea area = new GpsArea(maxLat, minLon, minLat, maxLon);
        for (AirspaceArea a : areas) {
            if (!MapUtil.isAirspaceInsideArea(map, a, area)) continue;
            log.debug("Deleting " + a);
            this.airspaceService.deleteAirspaceAreaById(a.getId());
        }
    }
}

