/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql.facade;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.comparator.AirportDistanceComparator;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.dto.RunwayDTO;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.entity.VfrPoint;
import main.java.guru.vfrflight.core.sql.filter.AirportFilter;
import main.java.guru.vfrflight.sql.DataSource;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.sql.facade.BaseFacade;
import main.java.guru.vfrflight.sql.service.AirportService;
import main.java.guru.vfrflight.sql.service.SqlService;
import main.java.guru.vfrflight.sql.service.VfrPointService;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.HibernateUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.geo.GeomagneticField;
import main.java.guru.vfrflight.util.geo.WmmCoeff2005;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class AirportFacade
extends BaseFacade {
    private static final Logger log = Logger.getLogger(AirportFacade.class);
    private final SqlService sqlService;
    private final AirportService airportService;
    private final VfrPointService vfrPointService;

    public AirportFacade(DataSource dataSource) {
        super(dataSource);
        this.sqlService = new SqlService(dataSource);
        this.airportService = new AirportService(dataSource);
        this.vfrPointService = new VfrPointService(dataSource);
    }

    public void insertAirports(List<Airport> airports, boolean truncateTable) {
        if (truncateTable) {
            this.truncateAirportsTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (Airport a : airports) {
            this.airportService.insertAirport(a, session);
        }
        session.clear();
        session.flush();
    }

    public SqlService getSqlService() {
        return this.sqlService;
    }

    public AirportService getAirportService() {
        return this.airportService;
    }

    public boolean truncateAirportsTable() {
        return this.airportService.resetAirportsIdSequence() && this.truncateAirportFreqTable() && this.truncateAirportStartsTable() && this.truncateAirportRunwaysTable() && this.truncateApronsTable() && this.truncateTaxiwaysTable() && this.truncateTaxiNames() && this.sqlService.truncateTable("airports");
    }

    public boolean truncateVfrPointsTable() {
        return this.sqlService.truncateTable("vfr_points");
    }

    public boolean truncateAirportFreqTable() {
        return this.sqlService.truncateTable("airport_freq");
    }

    public boolean truncateAirportStartsTable() {
        return this.sqlService.truncateTable("airport_start");
    }

    public boolean truncateTaxiwaysTable() {
        return this.sqlService.truncateTable("taxiways");
    }

    public boolean truncateTaxiNames() {
        return this.sqlService.truncateTable("taxi_names");
    }

    public boolean truncateAirportRunwaysTable() {
        return this.airportService.resetAirportRunwaysIdSequence() && this.truncateIlsTable() && this.sqlService.truncateTable("runways");
    }

    public boolean truncateApronsTable() {
        return this.airportService.resetApronsIdSequence() && this.truncateApronVerticesTable() && this.sqlService.truncateTable("aprons");
    }

    public boolean truncateApronVerticesTable() {
        return this.sqlService.truncateTable("apron_vertices");
    }

    public boolean truncateIlsTable() {
        return this.sqlService.truncateTable("ils");
    }

    public List<GpsPlace> findAirportsByIdent(String icaoId) {
        AirportFilter criteria = new AirportFilter();
        criteria.setIdent(icaoId);
        List<Airport> airports = this.getAirportService().findAirportsByCriteria(criteria);
        if (airports != null) {
            ArrayList<GpsPlace> results = new ArrayList<GpsPlace>(airports.size());
            for (Airport a : airports) {
                GpsPlace place = new GpsPlace(new GpsCoord(a.getLat()), new GpsCoord(a.getLon()), a.getIdent(), a.getElev() != null ? Double.valueOf(a.getElev().intValue()) : null);
                place.setDesc(a.getName() + " (" + a.getIdent() + ")");
                results.add(place);
            }
            return results;
        }
        log.error("Unexpected error -> SqlUtil.findAirportsById(" + icaoId + ")");
        return new ArrayList<GpsPlace>();
    }

    public List<GpsPlace> getAirportsInArea(GpsArea area) {
        List<Airport> airports = this.getAirportService().findAirportsInArea(area);
        if (airports != null) {
            ArrayList<GpsPlace> results = new ArrayList<GpsPlace>(airports.size());
            for (Airport a : airports) {
                results.add(a.getGpsPlace());
            }
            return results;
        }
        log.error("Unexpected error -> SqlUtil.findAirportsInArea(" + area + ")");
        return new ArrayList<GpsPlace>();
    }

    public List<Airport> findAirportsInArea(GpsArea area) {
        return this.airportService.findAirportsInArea(area);
    }

    public List<GpsPlace> findAirports(String query, boolean sort) {
        if (query != null) {
            query = query.trim();
        }
        if (query == null || query.length() > 0) {
            List<Airport> airports = this.getAirportService().findAirports(query, sort);
            if (airports == null) {
                log.error("Unexpected error -> SqlUtil.findAirports(" + query + ")");
            } else {
                ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
                for (Airport a : airports) {
                    GpsPlace place = a.getGpsPlace();
                    place.setDesc(a.getName() + " (" + a.getIdent() + ")");
                    results.add(place);
                }
                return results;
            }
        }
        return new ArrayList<GpsPlace>();
    }

    public long getVfrPointsNumber() {
        return this.sqlService.countRecordsInTable(VfrPoint.class.getName());
    }

    public long getAirportsNumber() {
        return this.sqlService.countRecordsInTable(Airport.class.getName());
    }

    public long getTaxiwaysNumber() {
        return this.sqlService.countRecordsInTable(Taxiway.class.getName());
    }

    public long getRunwaysNumber() {
        return this.sqlService.countRecordsInTable(Runway.class.getName());
    }

    public long getRunwaysWithNotNulPosNumber() {
        return this.airportService.countRunwaysWithNotNullPos();
    }

    public long getIlsNumber() {
        return this.sqlService.countRecordsInTable(Ils.class.getName());
    }

    public Double getMagneticDeclinationFromAirports(GpsPlace place) {
        double d = 0.5;
        GpsArea poi = null;
        AirportDistanceComparator comparator = new AirportDistanceComparator(place);
        Double res = null;
        do {
            ArrayList<Airport> airports;
            if ((airports = new ArrayList<Airport>(this.airportService.findAirportsInArea(poi = new GpsArea(place.getLat().getValue() + d, place.getLon().getValue() - d, place.getLat().getValue() - d, place.getLon().getValue() + d)))).size() >= 2) {
                Collections.sort(airports, comparator);
                ArrayList<Airport> result = new ArrayList<Airport>();
                for (Airport airport : airports) {
                    if (airport.getMagvar() == null || airport.getMagvar() == 0.0) continue;
                    result.add(airport);
                    if (result.size() <= 1) continue;
                    break;
                }
                if (result.size() > 1) {
                    double dist1 = GpsUtil.getDistance(place, ((Airport)result.get(0)).getGpsPlace());
                    double dist2 = GpsUtil.getDistance(place, ((Airport)result.get(1)).getGpsPlace());
                    double sum = dist1 + dist2;
                    res = (double)Math.round(((1.0 - dist1 / sum) * ((Airport)result.get(0)).getMagvar() + (1.0 - dist2 / sum) * ((Airport)result.get(1)).getMagvar()) * 1000.0) / 1000.0;
                    d = -1.0;
                }
            }
            if (!(d > 0.0)) continue;
            d += 0.5;
        } while (d > 0.0 & d <= 5.0);
        return res;
    }

    public void deleteAirportById(int id) {
        this.airportService.deleteAirportById(id);
    }

    public Airport findAirportById(int id) {
        return this.findAirportById(id, null);
    }

    public Airport findAirportById(int id, Session session) {
        return this.airportService.findAirportById(id, session);
    }

    public List<Airport> findAirportsByCriteria(AirportFilter criteria, boolean withChildren) {
        return this.airportService.findAirportsByCriteria(criteria, withChildren);
    }

    public List<IlsDTO> getIlsByAirportId(int id) {
        ArrayList<IlsDTO> result = new ArrayList<IlsDTO>();
        Airport airport = this.airportService.findAirportById(id);
        for (Ils ils : airport.getAllIls()) {
            result.add(new IlsDTO(ils, null));
        }
        return result;
    }

    public List<RunwayDTO> getRunwaysByAirportId(int id, boolean withChildren) {
        ArrayList<RunwayDTO> result = new ArrayList<RunwayDTO>();
        Airport airport = this.airportService.findAirportById(id);
        for (Runway r : airport.getRunways()) {
            result.add(new RunwayDTO(r, withChildren));
        }
        return result;
    }

    public List<Ils> findIlsInArea(GpsArea area) {
        return this.airportService.findIlsInArea(area);
    }

    public void calculateMagneticDeclinationError(GpsArea region) {
        List<Airport> airports = null;
        airports = region == null ? this.airportService.findAirports(null, false) : this.airportService.findAirportsInArea(region);
        for (int year = 1990; year <= 2005; ++year) {
            for (int month = 1; month <= 12; ++month) {
                GeomagneticField geoField = new GeomagneticField(new WmmCoeff2005());
                double diff = 0.0;
                for (Airport a : airports) {
                    if (a.getMagvar() == null) continue;
                    geoField.calculate(a.getLat().floatValue(), a.getLon().floatValue(), (float)UnitUtil.recalculateAltitude(a.getElev().intValue(), "ft", "m", false), new GregorianCalendar(year, month, 1).getTimeInMillis());
                    diff += Math.pow(a.getMagvar() - (double)geoField.getDeclination(), 2.0);
                }
                log.info("[" + year + "/" + month + "] Med / Avg:   " + diff);
            }
        }
    }

    public List<VfrPointDTO> findVfrPointsInArea(GpsArea area) {
        ArrayList<VfrPointDTO> results = new ArrayList<VfrPointDTO>();
        List<VfrPoint> points = this.vfrPointService.findVfrPointsInArea(area);
        for (VfrPoint v : points) {
            results.add(new VfrPointDTO(v));
        }
        return results;
    }

    public List<GpsPlace> findVfrPoints(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        List<VfrPoint> points = this.vfrPointService.findVfrPoints(query);
        for (VfrPoint v : points) {
            GpsPlace p = v.getGpsPlace();
            p.setDesc(p.getName());
            results.add(p);
        }
        return results;
    }

    public void insertVfrPoints(List<VfrPoint> points, boolean truncateTable) {
        if (truncateTable) {
            this.truncateVfrPointsTable();
        }
        Session session = this.dataSource.getHibernateSession();
        for (VfrPoint v : points) {
            this.vfrPointService.insertVfrPoint(v, session);
        }
        session.clear();
        session.flush();
    }

    public void deleteVfrPoints(String name, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        this.vfrPointService.deleteVfrPoints(name, minLat, minLon, maxLat, maxLon);
    }

    public void deleteAirports(String ident, Double minLat, Double minLon, Double maxLat, Double maxLon) {
        this.airportService.deleteAirports(ident, minLat, minLon, maxLat, maxLon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importAirports() {
        if (SqlConnector.getInstance().isServerRunning()) {
            log.info("Importing airports ...");
            Session session = this.dataSource.getHibernateSession();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader("tmp/airports.csv"));
                this.truncateAirportsTable();
                int total = 0;
                int lineNo = 0;
                String line = null;
                br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] split = StringUtil.splitCsvLine(',', line.replace("\"\"", ""));
                    log.trace("importAirports: line " + lineNo++);
                    if (split.length <= 6 || "closed".equals(split[2])) continue;
                    try {
                        Airport airport = new Airport();
                        if (split[6].trim().length() > 0) {
                            airport.setElev(Integer.valueOf(split[6]));
                        }
                        airport.setIdent(split[1].toUpperCase());
                        airport.setName(split[3]);
                        airport.setLat(Double.valueOf(split[4]));
                        airport.setLon(Double.valueOf(split[5]));
                        this.airportService.insertAirport(airport, session);
                        if (airport.getId() == null || ++total % 100 != 0) continue;
                        HibernateUtil.checkAvailableMemory();
                    }
                    catch (NumberFormatException e) {
                        log.error("Couldn't convert values to numbers: " + line, e);
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception: " + line, e);
                    }
                }
                SettingsBean.getInstance().setAirportsTableSource("DATAFILES");
                log.info("Finished importing " + total + " airports");
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException e) {
                log.error("Couldn't load airports data file tmp/airports.csv", e);
            }
            catch (IOException e) {
                log.error("Couldn't load airports data file tmp/airports.csv", e);
            }
            finally {
                session.flush();
                session.close();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            log.error("Couldn't import airports data: HSQL server is not running");
        }
        return false;
    }

    public Set<String> findAllAirportsIdents() {
        return this.airportService.findAllAirportsIdents();
    }

    public void deleteVfrPointById(Integer id) {
        this.vfrPointService.deleteVfrPointById(id);
    }
}

