/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hsqldb.HsqlException;
import org.hsqldb.Server;

public class SqlConnector {
    private static final Logger log = Logger.getLogger(SqlConnector.class);
    private static final String DB_HOST_URL = "jdbc:hsqldb:file:db/xdb;shutdown=true;hsqldb.write_delay=false;";
    private static final String DB_USER = "sa";
    private static final String DB_PASSWORD = "";
    private static final String DB_NAME = "xdb";
    private static volatile SqlConnector instance = null;
    private Server hsqlServer = null;
    private boolean serverRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlConnector getInstance() {
        if (instance != null) return instance;
        Class<SqlConnector> clazz = SqlConnector.class;
        synchronized (SqlConnector.class) {
            if (instance != null) return instance;
            instance = new SqlConnector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SqlConnector() {
        this.startServer();
    }

    public void startServer() {
        log.info("Starting HSQL server ...");
        this.hsqlServer = new Server();
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.setSilent(true);
        this.hsqlServer.setDatabaseName(0, DB_NAME);
        this.hsqlServer.setDatabasePath(0, "file:db/xdb");
        this.hsqlServer.start();
        this.serverRunning = true;
    }

    public void stopServer() {
        if (this.hsqlServer != null) {
            log.info("Stopping HSQL server ...");
            this.hsqlServer.shutdown();
            this.hsqlServer.stop();
        }
        this.serverRunning = false;
    }

    public void shutdownServer(Connection connection) {
        if (this.hsqlServer != null) {
            log.info("Shutting down HSQL server ...");
            try {
                SqlConnector.executeUpdate(connection, "SHUTDOWN");
                try {
                    while (true) {
                        this.hsqlServer.checkRunning(true);
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (HsqlException hsqlException) {
                }
            }
            catch (SQLException e) {
                log.error(e, e);
            }
            log.info("Shutdown complete");
        }
        this.serverRunning = false;
    }

    public static boolean setupDatabase(Connection connection) {
        try {
            SqlConnector.execute(connection, "SET FILES LOG FALSE");
            SqlConnector.execute(connection, "SET FILES BACKUP INCREMENT FALSE");
            SqlConnector.execute(connection, "SET DATABASE EVENT LOG LEVEL 0");
            SqlConnector.execute(connection, "SET DATABASE EVENT LOG SQL LEVEL 0");
            return true;
        }
        catch (SQLException e) {
            log.error("Couldn't turn off HSQL logging", e);
            return false;
        }
    }

    public static boolean execute(Connection connection, String query) throws SQLException {
        if (connection != null) {
            connection.prepareStatement(query).execute();
            return true;
        }
        return false;
    }

    public static boolean executeUpdate(Connection connection, String query) throws SQLException {
        if (connection != null) {
            return connection.prepareStatement(query).executeUpdate() > 0;
        }
        return false;
    }

    public static ResultSet executeQuery(Connection connection, String query) throws SQLException {
        if (connection != null) {
            return connection.prepareStatement(query).executeQuery();
        }
        return null;
    }

    public static void commit(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                log.error("Couldn't commit transaction", e);
            }
        }
    }

    public static Connection getConnection() {
        return SqlConnector.getConnection(DB_HOST_URL);
    }

    public static Connection getConnection(String hostUrl) {
        Connection connection = null;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            connection = DriverManager.getConnection(hostUrl, DB_USER, DB_PASSWORD);
            connection.setAutoCommit(true);
            SqlConnector.setupDatabase(connection);
        }
        catch (ClassNotFoundException e) {
            log.error("Couldn't start HSQL server", e);
        }
        catch (SQLException e) {
            log.error("Couldn't start HSQL server", e);
        }
        return connection;
    }

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean isServerRunning() {
        return this.serverRunning;
    }

    public void setServerRunning(boolean serverRunning) {
        this.serverRunning = serverRunning;
    }
}

