/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.Area;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.table.NavaidsRow;
import main.java.guru.vfrflight.core.table.RunwayRow;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSectionFactory;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.StaticMapUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;
import main.java.guru.vfrflight.weather.core.Station;
import org.apache.log4j.Logger;

public class PdfUtil {
    private static final Logger log = Logger.getLogger(PdfUtil.class);
    private static float MARGIN_SIZE = 20.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFlightPlanPdf(String filename, Route route, PdfConfigBean configBean, List<Station> stations) {
        boolean result = false;
        try (Document document = null;){
            if (!configBean.isHalfSize()) {
                document = new Document(PageSize.A4);
                document.setMargins(MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE);
            } else {
                document = new Document(PageSize.A4.rotate());
                document.setMargins(MARGIN_SIZE, (float)Math.round(PageSize.A4.getHeight() / 2.0f) + MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE);
            }
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            PdfContextBean ctx = new PdfContextBean(configBean, route, stations);
            HeaderFooter footer = new HeaderFooter(new Phrase(Messages.getInstance().get("pdf_footer"), ctx.getFooterFont()), false);
            footer.setAlignment(1);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            for (PdfSectionType type : configBean.getLayout()) {
                PdfSectionFactory.createSection(type).create(document, configBean, ctx);
            }
            result = true;
        }
        return result;
    }

    public static BufferedImage getMapRegionImage(VfrMapViewer map, RotatedGpsArea mapRegion, int zoom, boolean withCompassRose, Double magvar, Integer compassRoseLocation, boolean mapWithRouteOnly) {
        BufferedImage finalImg;
        BufferedImage img = StaticMapUtil.getStaticMap(map, mapRegion.getRectangleOver(), zoom, 0, false, mapWithRouteOnly);
        int maxSize = Math.round(Math.max(img.getWidth(), img.getHeight()));
        Dimension size = mapRegion.getSize(map, zoom);
        if (size.getHeight() > (double)maxSize) {
            maxSize = (int)Math.round(size.getHeight());
        }
        if (size.getWidth() > (double)maxSize) {
            maxSize = (int)Math.round(size.getWidth());
        }
        BufferedImage rotatedImage = new BufferedImage(maxSize, maxSize, img.getType());
        AffineTransform at = new AffineTransform();
        at.translate((double)maxSize / 2.0, (double)maxSize / 2.0);
        at.rotate(Math.toRadians(-mapRegion.getAngle()));
        at.translate((double)(-img.getWidth()) / 2.0, (double)(-img.getHeight()) / 2.0);
        Graphics2D g = rotatedImage.createGraphics();
        GraphicsUtil.setRenderingHints(g, 3);
        g.drawImage(img, at, null);
        int x = (int)Math.round(((double)rotatedImage.getWidth() - size.getWidth()) / 2.0);
        int y = (int)Math.round(((double)rotatedImage.getHeight() - size.getHeight()) / 2.0);
        if (x >= 0 && y >= 0) {
            int h;
            int w = (int)Math.round(size.getWidth());
            if (w > rotatedImage.getWidth()) {
                w = rotatedImage.getWidth();
            }
            if ((h = (int)Math.round(size.getHeight())) > rotatedImage.getHeight()) {
                h = rotatedImage.getHeight();
            }
            finalImg = rotatedImage.getSubimage(x, y, w, h);
        } else {
            finalImg = rotatedImage;
        }
        double sizeModificator = MapUtil.calculateZoomRatio(new Dimension(finalImg.getWidth(), finalImg.getHeight()));
        if (withCompassRose) {
            GraphicsUtil.paintCompassRose(finalImg, -mapRegion.getAngle(), magvar, sizeModificator, compassRoseLocation);
        }
        return finalImg;
    }

    public static void generatePageWithMapRegion(Document document, RotatedGpsArea mapRegion, int zoom, float scale, boolean withCompassRose, Double magvar, Integer compassRoseLocation, boolean mapWithRouteOnly, boolean newPage) throws IOException, DocumentException {
        String pngName = "tmp/vfrflight_map" + new Date().getTime() + ".png";
        if (UrlUtil.saveImage(PdfUtil.getMapRegionImage(MapFrame.getInstance().getMapViewer(), mapRegion, zoom, withCompassRose, magvar, compassRoseLocation, mapWithRouteOnly), pngName)) {
            Image image;
            if (newPage) {
                document.newPage();
            }
            if ((image = Image.getInstance((String)pngName)).getWidth() > image.getHeight()) {
                image.setRotationDegrees(270.0f);
            }
            image.scaleToFit(document.getPageSize().getWidth() * scale, document.getPageSize().getHeight() * scale);
            image.setAlignment(1);
            document.add((Element)image);
            File pngFile = new File(pngName);
            pngFile.delete();
        }
    }

    public static void generatePageWithMap(Document document, float scale) throws IOException, DocumentException {
        String pngName = "tmp/vfrflight_map.png";
        MapFrame.getInstance().setPaintZoomBar(false);
        if (MapFrame.getInstance().savePng(pngName)) {
            document.newPage();
            Image image = Image.getInstance((String)pngName);
            if (image.getWidth() > image.getHeight()) {
                image.setRotationDegrees(270.0f);
            }
            image.scaleToFit(document.getPageSize().getWidth() * scale, document.getPageSize().getHeight() * scale);
            image.setAlignment(1);
            document.add((Element)image);
            File pngFile = new File(pngName);
            pngFile.delete();
        }
        MapFrame.getInstance().setPaintZoomBar(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generatePageWithText(String filename, List<String> txt) {
        boolean result = false;
        try (Document document = null;){
            document = new Document(PageSize.A4);
            document.setMargins(MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            BaseFont libSansBold = BaseFont.createFont((String)"font/LiberationSans-Bold.ttf", (String)"Identity-H", (boolean)true);
            HeaderFooter footer = new HeaderFooter(new Phrase(Messages.getInstance().get("pdf_footer"), new Font(libSansBold, 8.0f)), false);
            footer.setAlignment(1);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            PdfUtil.generateText(document, txt);
            result = true;
        }
        return result;
    }

    public static void generateText(Document document, List<String> txt) throws IOException, DocumentException {
        document.newPage();
        BaseFont libSansRegular = BaseFont.createFont((String)"font/LiberationSans-Regular.ttf", (String)"Identity-H", (boolean)true);
        for (String p : txt) {
            Paragraph titleParagraph = new Paragraph(p, new Font(libSansRegular, 10.0f));
            titleParagraph.setAlignment(0);
            titleParagraph.setSpacingAfter(10.0f);
            document.add((Element)titleParagraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createMapInPdf(String filename, RotatedGpsArea area, int zoom, boolean withCompassRose, Double magvar, Integer compassRoseLocation) {
        boolean result = false;
        try (Document document = null;){
            document = new Document();
            document.setMargins(20.0f, 20.0f, 20.0f, 20.0f);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            BaseFont libSansBold = BaseFont.createFont((String)"font/LiberationSans-Bold.ttf", (String)"Identity-H", (boolean)true);
            HeaderFooter footer = new HeaderFooter(new Phrase(Messages.getInstance().get("pdf_footer"), new Font(libSansBold, 8.0f)), false);
            footer.setAlignment(1);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            PdfUtil.generatePageWithMapRegion(document, area, zoom, 0.9f, withCompassRose, magvar, compassRoseLocation, false, true);
            result = true;
        }
        return result;
    }

    public static boolean createMapInPng(String pngName, RotatedGpsArea area, int zoom, boolean withCompassRose, Double magvar, int compassRoseLocation) {
        MapFrame.getInstance().setPaintZoomBar(false);
        boolean result = UrlUtil.saveImage(PdfUtil.getMapRegionImage(MapFrame.getInstance().getMapViewer(), area, zoom, withCompassRose, magvar, compassRoseLocation, false), pngName);
        MapFrame.getInstance().setPaintZoomBar(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createAirportInfoPdf(String filename, Airport airport, Double magvar, List<RunwayRow> runwayRows, List<NavaidsRow> navaidsRows, boolean includeRunways, boolean includeNavaids, boolean includeFrequencies) {
        boolean result = false;
        try (Document document = null;){
            document = new Document(PageSize.A4);
            document.setMargins(MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE, MARGIN_SIZE);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            BaseFont libSansRegular = BaseFont.createFont((String)"font/LiberationSans-Regular.ttf", (String)"Identity-H", (boolean)true);
            BaseFont libSansBold = BaseFont.createFont((String)"font/LiberationSans-Bold.ttf", (String)"Identity-H", (boolean)true);
            HeaderFooter footer = new HeaderFooter(new Phrase(Messages.getInstance().get("pdf_footer"), new Font(libSansBold, 8.0f)), false);
            footer.setAlignment(1);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            Paragraph titleParagraph = new Paragraph(airport.getName() + " [" + airport.getIdent() + "]", new Font(libSansBold, 22.0f));
            titleParagraph.setAlignment(1);
            titleParagraph.setSpacingAfter(10.0f);
            document.add((Element)titleParagraph);
            int elev = airport.getElev();
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                elev = (int)Math.round(UnitUtil.recalculateAltitude(elev, "ft", "m", false));
            }
            String txt = Messages.getInstance().get("airport_info_dialog_elevation") + " " + elev + UnitUtil.getAltitudeUnit() + "\n";
            txt = txt + Messages.getInstance().get("airport_info_dialog_magvar") + " " + (magvar != null ? magvar + "\u00b0" : Messages.getInstance().get("not_available"));
            Paragraph airportInfoParagraph = new Paragraph(txt, new Font(libSansRegular, 14.0f));
            airportInfoParagraph.setAlignment(1);
            airportInfoParagraph.setSpacingAfter(10.0f);
            document.add((Element)airportInfoParagraph);
            Font cellTitleFont = new Font(libSansRegular, 10.0f);
            Font cellValueT2Font = new Font(libSansRegular, 12.0f);
            float cellHeight = 30.0f;
            float spacingAfter = 15.0f;
            if (includeRunways && runwayRows != null && runwayRows.size() > 0) {
                PdfPTable table = new PdfPTable(8);
                table.setWidthPercentage(99.0f);
                table.setWidths(new int[]{30, 30, 30, 30, 80, 40, 20, 20});
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_runway"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_heading"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_length"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_width"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_type"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_ils"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_ils_gs"), cellTitleFont, cellHeight));
                table.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_ils_dme"), cellTitleFont, cellHeight));
                for (RunwayRow runwayRow : runwayRows) {
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.getName()), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.getHeading()), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.getLength()), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.getWidth()), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(runwayRow.getType(), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(runwayRow.getIls(), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.isGs() ? "X" : ""), cellValueT2Font, cellHeight));
                    table.addCell(PdfUtil.getCenteredCell(String.valueOf(runwayRow.isDme() ? "X" : ""), cellValueT2Font, cellHeight));
                }
                table.setSpacingAfter(spacingAfter);
                document.add((Element)table);
            }
            if (includeNavaids && navaidsRows != null && navaidsRows.size() > 0) {
                PdfPTable table2 = new PdfPTable(4);
                table2.setWidthPercentage(70.0f);
                table2.setWidths(new int[]{50, 90, 90, 50});
                table2.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_ident"), cellTitleFont, cellHeight));
                table2.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_type"), cellTitleFont, cellHeight));
                table2.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_rad_dist"), cellTitleFont, cellHeight));
                table2.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_frequency"), cellTitleFont, cellHeight));
                for (NavaidsRow navaidsRow : navaidsRows) {
                    table2.addCell(PdfUtil.getCenteredCell(String.valueOf(navaidsRow.getIdent()), cellValueT2Font, cellHeight));
                    table2.addCell(PdfUtil.getCenteredCell(String.valueOf(navaidsRow.getType()), cellValueT2Font, cellHeight));
                    table2.addCell(PdfUtil.getCenteredCell(String.valueOf(navaidsRow.getRadDist()), cellValueT2Font, cellHeight));
                    table2.addCell(PdfUtil.getCenteredCell(String.valueOf(navaidsRow.getFreq()), cellValueT2Font, cellHeight));
                }
                table2.setSpacingAfter(spacingAfter);
                document.add((Element)table2);
            }
            if (includeFrequencies && airport.getFrequencies().size() > 0) {
                PdfPTable table3 = new PdfPTable(3);
                table3.setWidthPercentage(70.0f);
                table3.setWidths(new int[]{110, 110, 50});
                table3.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_name"), cellTitleFont, cellHeight));
                table3.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_type"), cellTitleFont, cellHeight));
                table3.addCell(PdfUtil.getCenteredCell(Messages.getInstance().get("table_frequency"), cellTitleFont, cellHeight));
                for (AirportFreq airportFreq : airport.getFrequencies()) {
                    table3.addCell(PdfUtil.getCenteredCell(String.valueOf(airportFreq.getName()), cellValueT2Font, cellHeight));
                    table3.addCell(PdfUtil.getCenteredCell(String.valueOf((Object)airportFreq.getType()), cellValueT2Font, cellHeight));
                    table3.addCell(PdfUtil.getCenteredCell(String.valueOf(airportFreq.getFrequency()), cellValueT2Font, cellHeight));
                }
                document.add((Element)table3);
            }
            result = true;
        }
        return result;
    }

    private static PdfPCell getCenteredCell(String txt, Font font, float height) {
        PdfPCell cell = new PdfPCell(new Phrase(txt, font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(height);
        return cell;
    }

    public static int calculateZoomForA4Page(Area area, int dpi, double scale, int minZoom, int maxZoom) {
        int zoom = minZoom;
        int calcDpi = 0;
        do {
            calcDpi = PdfUtil.calculateDpiForA4Page(area, zoom, scale);
        } while (++zoom <= maxZoom && calcDpi > dpi);
        return --zoom;
    }

    public static int calculateDpiForA4Page(Area area, int zoom, double scale) {
        Dimension size = area.getSize(MapFrame.getInstance().getMapViewer(), zoom);
        double max = Math.max(size.getWidth(), size.getHeight());
        return (int)Math.round(max / 11.7 * scale);
    }
}

