/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.pdf.sections.AlternateAirportsSection;
import main.java.guru.vfrflight.pdf.sections.CalculationResultSection;
import main.java.guru.vfrflight.pdf.sections.FlightPlanRouteSection;
import main.java.guru.vfrflight.pdf.sections.HeaderSection;
import main.java.guru.vfrflight.pdf.sections.MapPerLegSection;
import main.java.guru.vfrflight.pdf.sections.MapPerWpSection;
import main.java.guru.vfrflight.pdf.sections.MapRadialsSection;
import main.java.guru.vfrflight.pdf.sections.MapRadialsToWpSection;
import main.java.guru.vfrflight.pdf.sections.MapRadialsTwoColumnsSection;
import main.java.guru.vfrflight.pdf.sections.MapSection;
import main.java.guru.vfrflight.pdf.sections.MetarTafSection;
import main.java.guru.vfrflight.pdf.sections.PageBreakSection;
import main.java.guru.vfrflight.pdf.sections.SimplifiedCalculationResultSection;
import main.java.guru.vfrflight.pdf.sections.SimplifiedHeaderSection;
import main.java.guru.vfrflight.pdf.sections.SummarySection;
import main.java.guru.vfrflight.pdf.sections.TitleSection;
import main.java.guru.vfrflight.pdf.sections.VectorsForAlternatesSection;
import main.java.guru.vfrflight.pdf.sections.VorFrequenciesSection;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;
import main.java.guru.vfrflight.pdf.util.PdfSection;

public class PdfSectionFactory {
    private static final Map<PdfSectionType, PdfSection> TYPE_MAPPINGS;

    public static PdfSection createSection(PdfSectionType type) {
        if (TYPE_MAPPINGS.get((Object)type) != null) {
            return TYPE_MAPPINGS.get((Object)type);
        }
        return null;
    }

    public static StringComboBoxItem[] createComboBoxValues() {
        ArrayList<StringComboBoxItem> result = new ArrayList<StringComboBoxItem>();
        for (Map.Entry<PdfSectionType, PdfSection> pair : TYPE_MAPPINGS.entrySet()) {
            String key = "pdf_section_type_" + pair.getKey().toString().toLowerCase();
            String label = null;
            label = Messages.getInstance().exists(key) ? Messages.getInstance().get(key) : pair.getKey().toString().toUpperCase();
            result.add(new StringComboBoxItem(label, pair.getKey().toString()));
        }
        return result.toArray(new StringComboBoxItem[result.size()]);
    }

    static {
        LinkedHashMap<PdfSectionType, PdfSection> mp = new LinkedHashMap<PdfSectionType, PdfSection>();
        mp.put(PdfSectionType.PAGE_BREAK, new PageBreakSection());
        mp.put(PdfSectionType.ALTERNATE_AIRPORTS, new AlternateAirportsSection());
        mp.put(PdfSectionType.TITLE, new TitleSection());
        mp.put(PdfSectionType.HEADER, new HeaderSection());
        mp.put(PdfSectionType.SIMPLIFIED_HEADER, new SimplifiedHeaderSection());
        mp.put(PdfSectionType.CALCULATION_RESULT, new CalculationResultSection());
        mp.put(PdfSectionType.SIMPLIFIED_CALCULATION_RESULT, new SimplifiedCalculationResultSection());
        mp.put(PdfSectionType.SUMMARY, new SummarySection());
        mp.put(PdfSectionType.VECTORS_FOR_ALTERNATES, new VectorsForAlternatesSection());
        mp.put(PdfSectionType.MAP_RADIALS_TO_WPS, new MapRadialsToWpSection());
        mp.put(PdfSectionType.MAP_RADIALS, new MapRadialsSection());
        mp.put(PdfSectionType.MAP_RADIALS_TWO_COLUMNS, new MapRadialsTwoColumnsSection());
        mp.put(PdfSectionType.VOR_FREQUENCIES, new VorFrequenciesSection());
        mp.put(PdfSectionType.MAP, new MapSection());
        mp.put(PdfSectionType.MAP_PER_LEG, new MapPerLegSection());
        mp.put(PdfSectionType.MAP_PER_WP, new MapPerWpSection());
        mp.put(PdfSectionType.METAR_TAF, new MetarTafSection());
        mp.put(PdfSectionType.FLIGHT_PLAN_ROUTE, new FlightPlanRouteSection());
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

