/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import main.java.guru.vfrflight.pdf.cell.CustomBorder;
import main.java.guru.vfrflight.pdf.cell.EditableCellEvent;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public abstract class PdfSection {
    public abstract void create(Document var1, PdfConfigBean var2, PdfContextBean var3) throws DocumentException;

    public PdfPCell getEmptyCell(float height) {
        PdfPCell cell = new PdfPCell(new Phrase());
        cell.setFixedHeight(height);
        return cell;
    }

    public PdfPCell getLeftCell(String txt, Font font, float height) {
        PdfPCell cell = new PdfPCell(new Phrase(txt, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(height);
        cell.setPaddingLeft(5.0f);
        return cell;
    }

    public PdfPCell getCenteredCell(String txt, Font font, float height) {
        PdfPCell cell = new PdfPCell(new Phrase(txt, font));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(height);
        return cell;
    }

    public PdfPCell getEmptyEditableCell(float height) {
        PdfPCell cell = new PdfPCell(new Phrase(""));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(height);
        cell.setCellEvent((PdfPCellEvent)new EditableCellEvent(VfrUtil.createRandomUuid()));
        return cell;
    }

    public PdfPCell getCenteredCellWithCustomBorder(String txt, Font font, float height, CustomBorder border) {
        PdfPCell cell = new PdfPCell(new Phrase(txt, font));
        cell.setCellEvent((PdfPCellEvent)border);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(height);
        return cell;
    }
}

