/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.util;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.util.List;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;
import main.java.guru.vfrflight.weather.core.Station;

public class PdfContextBean {
    private final float cellHeight;
    private final float spacingAfter;
    private final Font cellTitleFont;
    private final Font cellValueFont;
    private final Font cellTitleT2Font;
    private final Font cellValueT2Font;
    private final Font cellValueBIT2Font;
    private final Font cellValueSmallFont;
    private final Font cellFisInfoFont;
    private final Font cellMapRadialsFont;
    private final Font footerFont;
    private final Font headerFont;
    private final List<Station> stations;
    private final Route route;

    public PdfContextBean(PdfConfigBean configBean, Route route, List<Station> stations) throws DocumentException, IOException {
        BaseFont libSansRegular = BaseFont.createFont((String)"font/LiberationSans-Regular.ttf", (String)"Identity-H", (boolean)true);
        BaseFont libSansBold = BaseFont.createFont((String)"font/LiberationSans-Bold.ttf", (String)"Identity-H", (boolean)true);
        BaseFont libSansBoldItalic = BaseFont.createFont((String)"font/LiberationSans-BoldItalic.ttf", (String)"Identity-H", (boolean)true);
        int fontSizeReduction = configBean.isHalfSize() ? 4 : 0;
        this.headerFont = new Font(libSansBold, 22.0f);
        this.footerFont = new Font(libSansBold, (float)(8 - (int)Math.floor(fontSizeReduction / 2)));
        this.cellHeight = configBean.isHalfSize() ? 20.0f : 30.0f;
        this.spacingAfter = configBean.isHalfSize() ? 7.0f : 15.0f;
        this.cellTitleFont = new Font(libSansRegular, (float)(10 - (int)Math.floor(fontSizeReduction / 2)));
        this.cellValueFont = new Font(libSansBold, (float)(13 - (int)Math.floor(fontSizeReduction / 2)));
        this.cellTitleT2Font = new Font(libSansBold, (float)(9 - fontSizeReduction));
        this.cellValueT2Font = new Font(libSansRegular, (float)(11 - fontSizeReduction));
        this.cellValueBIT2Font = new Font(libSansBoldItalic, (float)(11 - fontSizeReduction));
        this.cellValueSmallFont = new Font(libSansRegular, (float)(8 - fontSizeReduction));
        this.cellFisInfoFont = new Font(libSansRegular, (float)(13 - fontSizeReduction));
        this.cellMapRadialsFont = new Font(libSansRegular, (float)(11 - fontSizeReduction));
        this.stations = stations;
        this.route = route;
    }

    public Font getCellValueSmallFont() {
        return this.cellValueSmallFont;
    }

    public float getCellHeight() {
        return this.cellHeight;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public Font getCellTitleFont() {
        return this.cellTitleFont;
    }

    public Font getCellValueFont() {
        return this.cellValueFont;
    }

    public Font getCellTitleT2Font() {
        return this.cellTitleT2Font;
    }

    public Font getCellValueT2Font() {
        return this.cellValueT2Font;
    }

    public Font getCellValueBIT2Font() {
        return this.cellValueBIT2Font;
    }

    public Font getCellFisInfoFont() {
        return this.cellFisInfoFont;
    }

    public Font getCellMapRadialsFont() {
        return this.cellMapRadialsFont;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Font getFooterFont() {
        return this.footerFont;
    }

    public Route getRoute() {
        return this.route;
    }

    public List<Station> getStations() {
        return this.stations;
    }
}

