/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class VorFrequenciesSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        if (ctx.getRoute().getVors().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (GpsPlace gpsPlace : ctx.getRoute().getVors()) {
                Integer freq = gpsPlace.getDataInt("freq");
                if (freq == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if ("NDB".equals(gpsPlace.getType())) {
                    sb.append("NDB ");
                }
                sb.append(gpsPlace.getName());
                sb.append(" ");
                sb.append("NDB".equals(gpsPlace.getType()) ? FormatUtil.formatNdbFrequency(freq) : FormatUtil.formatVorFrequency(freq));
            }
            Paragraph vors = new Paragraph(sb.toString(), ctx.getCellFisInfoFont());
            vors.setAlignment(1);
            vors.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)vors);
        }
    }
}

