/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.DesiredVector;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class VectorsForAlternatesSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        if (ctx.getRoute().getAlternateAirports().size() > 0) {
            int i;
            double windDirection = ctx.getRoute().getWindDirection();
            double windSpeedKt = ctx.getRoute().getWindSpeed();
            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                windSpeedKt = UnitUtil.recalculateWindSpeed(windSpeedKt, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
            }
            double cruiseSpeedKt = ctx.getRoute().getCruiseSpeed();
            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                cruiseSpeedKt = UnitUtil.recalculateSpeed(cruiseSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
            }
            PdfPTable table = new PdfPTable(ctx.getRoute().getAlternateAirports().size() + 1);
            int[] widths = new int[ctx.getRoute().getAlternateAirports().size() + 1];
            widths[0] = 55;
            int colWidth = Math.round((255 - widths[0]) / ctx.getRoute().getAlternateAirports().size());
            for (i = 1; i < ctx.getRoute().getAlternateAirports().size() + 1; ++i) {
                widths[i] = colWidth;
            }
            table.setWidths(widths);
            table.setWidthPercentage(90.0f);
            table.addCell(this.getCenteredCell(Messages.getInstance().get("table_point"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            for (i = 1; i < ctx.getRoute().getAlternateAirports().size() + 1; ++i) {
                table.addCell(this.getCenteredCell(StringUtil.nullToEmpty(ctx.getRoute().getAlternateAirports().get(i - 1).getIdent()), ctx.getCellTitleFont(), ctx.getCellHeight()));
            }
            for (int q = 0; q < ctx.getRoute().getPoints().size(); ++q) {
                GpsPlace point = ctx.getRoute().getPoints().get(q);
                table.addCell(this.getLeftCell(StringUtil.nullToEmpty(point.getName()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                for (int i2 = 0; i2 < ctx.getRoute().getAlternateAirports().size(); ++i2) {
                    GpsPlace airport = ctx.getRoute().getAlternateAirports().get(i2).getGpsPlace();
                    DesiredVector v = VfrUtil.getDesiredVector(point, airport, cruiseSpeedKt, windSpeedKt, windDirection);
                    String row = v != null ? v.getInfo() : "--";
                    table.addCell(this.getCenteredCell(row, ctx.getCellValueT2Font(), ctx.getCellHeight()));
                }
            }
            table.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)table);
        }
    }
}

