/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class SummarySection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        PdfPTable table3 = new PdfPTable(7);
        table3.setWidthPercentage(90.0f);
        table3.setWidths(new int[]{80, 40, 25, 25, 25, 25, 25});
        table3.addCell(this.getLeftCell(Messages.getInstance().get("pdf_plan_flight_duration"), ctx.getCellTitleFont(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(FormatUtil.formatTime(ctx.getRoute().getTotalTime()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_qmax") + UnitUtil.getFuelUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_qm") + UnitUtil.getFuelUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_qnaw") + UnitUtil.getFuelUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_qnl") + UnitUtil.getFuelUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table3.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_qpoz") + UnitUtil.getFuelUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        Double magvar = ctx.getRoute().getMagvarFromCenter();
        table3.addCell(this.getLeftCell(Messages.getInstance().get("pdf_plan_magnetic_declination"), ctx.getCellTitleFont(), ctx.getCellHeight()));
        String magvarTxt = "";
        if (magvar != null) {
            String ch = "";
            if (magvar > 0.0) {
                ch = "+";
            }
            magvarTxt = ch + String.valueOf(NumberUtil.roundDouble(magvar, 1)) + "\u00b0";
        }
        table3.addCell(this.getCenteredCell(magvarTxt, ctx.getCellValueT2Font(), ctx.getCellHeight()));
        if (ctx.getRoute().isFuelInfo()) {
            table3.addCell(this.getCenteredCell(String.valueOf((double)Math.round(ctx.getRoute().getQmax() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            table3.addCell(this.getCenteredCell(String.valueOf((double)Math.round(ctx.getRoute().getQm() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            table3.addCell(this.getCenteredCell(String.valueOf((double)Math.round(ctx.getRoute().getQnav() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            table3.addCell(this.getCenteredCell(String.valueOf((double)Math.round(ctx.getRoute().getQfl() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            table3.addCell(this.getCenteredCell(String.valueOf((double)Math.round(ctx.getRoute().getQlft() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        } else {
            table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
        }
        table3.addCell(this.getLeftCell(Messages.getInstance().get("pdf_plan_safe_altitude"), ctx.getCellTitleFont(), ctx.getCellHeight()));
        table3.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
        PdfPCell cell = this.getLeftCell(Messages.getInstance().get("pdf_plan_departure_time"), ctx.getCellTitleFont(), ctx.getCellHeight());
        cell.setColspan(3);
        table3.addCell(cell);
        cell = this.getEmptyEditableCell(ctx.getCellHeight());
        cell.setColspan(2);
        table3.addCell(cell);
        cell = this.getCenteredCell("", ctx.getCellFisInfoFont(), ctx.getCellHeight());
        cell.setColspan(2);
        table3.addCell(cell);
        cell = this.getLeftCell(Messages.getInstance().get("pdf_plan_arrival_time"), ctx.getCellTitleFont(), ctx.getCellHeight());
        cell.setColspan(3);
        table3.addCell(cell);
        cell = this.getEmptyEditableCell(ctx.getCellHeight());
        cell.setColspan(2);
        table3.addCell(cell);
        table3.setSpacingAfter(ctx.getSpacingAfter());
        document.add((Element)table3);
    }
}

