/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class SimplifiedHeaderSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        PdfPTable table1 = new PdfPTable(4);
        table1.setWidthPercentage(90.0f);
        table1.setWidths(new int[]{100, 60, 40, 40});
        table1.addCell(this.getLeftCell(Messages.getInstance().get("pdf_plan_cruise_speed_altitude"), ctx.getCellTitleFont(), ctx.getCellHeight()));
        String cruiseSpeedAlt = Math.round(ctx.getRoute().getCruiseSpeed()) + SettingsBean.getInstance().getParamUnitsSpeed();
        if (ctx.getRoute().getCruiseAlt() != null) {
            cruiseSpeedAlt = cruiseSpeedAlt + "   " + Math.round(ctx.getRoute().getCruiseAlt()) + SettingsBean.getInstance().getParamUnitsAltitude();
        }
        table1.addCell(this.getCenteredCell(cruiseSpeedAlt, ctx.getCellValueFont(), ctx.getCellHeight()));
        table1.addCell(this.getLeftCell(Messages.getInstance().get("pdf_plan_wind"), ctx.getCellTitleFont(), ctx.getCellHeight()));
        table1.addCell(this.getCenteredCell(FormatUtil.formattedWindString(ctx.getRoute()) + SettingsBean.getInstance().getParamUnitsWindSpeed(), ctx.getCellValueFont(), ctx.getCellHeight()));
        table1.setSpacingAfter(ctx.getSpacingAfter());
        document.add((Element)table1);
    }
}

