/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.pdf.cell.CustomBorder;
import main.java.guru.vfrflight.pdf.cell.SolidLine;
import main.java.guru.vfrflight.pdf.sections.column.SectionColumn;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class SimplifiedCalculationResultSection
extends PdfSection {
    private int colNum;
    private static final int PAGE_WIDTH_PIXELS = 300;

    private PdfPTable createTable(PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        ArrayList<SectionColumn> columns = new ArrayList<SectionColumn>();
        PdfPCell titleCell = this.getLeftCell(Messages.getInstance().get("pdf_plan_segment"), ctx.getCellTitleT2Font(), ctx.getCellHeight());
        titleCell.setColspan(2);
        columns.add(new SectionColumn(5, null));
        columns.add(new SectionColumn(null, titleCell));
        columns.add(new SectionColumn(10, this.getCenteredCell(Messages.getInstance().get("pdf_plan_distance") + UnitUtil.getDistanceUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        columns.add(new SectionColumn(10, this.getCenteredCell(Messages.getInstance().get("pdf_plan_km") + " [\u00b0]", ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        columns.add(new SectionColumn(10, this.getCenteredCell(Messages.getInstance().get("pdf_plan_duration"), ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        if (configBean.isIncludeVorRadialsInCalculationResults()) {
            columns.add(new SectionColumn(18, this.getCenteredCell(Messages.getInstance().get("pdf_plan_vor_radials"), ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        }
        if (configBean.isIncludeEta()) {
            columns.add(new SectionColumn(10, this.getCenteredCell(Messages.getInstance().get("pdf_plan_eta"), ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        }
        if (configBean.isIncludeEmptyAta()) {
            columns.add(new SectionColumn(10, this.getCenteredCell(Messages.getInstance().get("pdf_plan_ata"), ctx.getCellTitleT2Font(), ctx.getCellHeight())));
        }
        this.colNum = columns.size();
        PdfPTable table2 = new PdfPTable(this.colNum);
        table2.setWidthPercentage(90.0f);
        int totalDeclaredWidths = 0;
        int q = 0;
        for (SectionColumn col : columns) {
            if (col.getWidth() != null) {
                totalDeclaredWidths += col.getWidth().intValue();
                continue;
            }
            ++q;
        }
        int undeclaredWidth = (int)Math.round((double)(100 - totalDeclaredWidths) / (double)q);
        int[] widths = new int[this.colNum];
        int i = 0;
        for (SectionColumn col : columns) {
            widths[i] = col.getWidth() != null ? (int)Math.round((double)(300 * col.getWidth()) / 100.0) : (int)Math.round((double)(300 * undeclaredWidth) / 100.0);
            ++i;
        }
        table2.setWidths(widths);
        for (SectionColumn col : columns) {
            if (col.getCell() == null) continue;
            table2.addCell(col.getCell());
        }
        return table2;
    }

    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        PdfPTable table2 = this.createTable(configBean, ctx);
        SolidLine solidLine2f = new SolidLine(1.75f);
        for (int row = 0; row < ctx.getRoute().getSegments().size(); ++row) {
            RouteSegment segment = ctx.getRoute().getSegments().get(row);
            PdfPCell nameCell = this.getLeftCell(segment.getSegmentName(), ctx.getCellValueT2Font(), ctx.getCellHeight());
            nameCell.setColspan(2);
            table2.addCell(nameCell);
            if (segment.getDistance() < 100.0) {
                table2.addCell(this.getCenteredCell(String.valueOf((double)Math.round(segment.getDistance() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            } else {
                table2.addCell(this.getCenteredCell(String.valueOf((int)Math.round(segment.getDistance())), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            }
            CustomBorder border = null;
            border = row == 0 ? new CustomBorder(solidLine2f, null, solidLine2f, null) : (row == ctx.getRoute().getSegments().size() - 1 ? new CustomBorder(solidLine2f, null, null, solidLine2f) : new CustomBorder(solidLine2f, null, null, null));
            table2.addCell(this.getCenteredCellWithCustomBorder(FormatUtil.formattedCourse(segment.getKm(), false), ctx.getCellValueBIT2Font(), ctx.getCellHeight(), border));
            border = null;
            border = row == 0 ? new CustomBorder(null, solidLine2f, solidLine2f, null) : (row == ctx.getRoute().getSegments().size() - 1 ? new CustomBorder(null, solidLine2f, null, solidLine2f) : new CustomBorder(null, solidLine2f, null, null));
            table2.addCell(this.getCenteredCellWithCustomBorder(FormatUtil.formatTimeLandmark(segment.getT()), ctx.getCellValueT2Font(), ctx.getCellHeight(), border));
            if (configBean.isIncludeVorRadialsInCalculationResults()) {
                table2.addCell(this.getCenteredCell(ctx.getRoute().getFormattedTwoClosestVors(segment.getTo(), Constants.EOL), ctx.getCellValueSmallFont(), ctx.getCellHeight()));
            }
            if (configBean.isIncludeEta() && !configBean.isIncludeFilledEta()) {
                table2.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            } else if (configBean.isIncludeFilledEta()) {
                table2.addCell(this.getCenteredCell(FormatUtil.formatTime(segment.getEta()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            }
            if (configBean.isIncludeEmptyAta()) {
                table2.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            }
            if (!configBean.isIncludeLandmarksInCalculationResults()) continue;
            List<SegmentLandmark> landmarks = ctx.getRoute().getLandmarksForSegment(row);
            for (int i = 0; i < landmarks.size(); ++i) {
                SegmentLandmark landmark = landmarks.get(i);
                if (!landmark.hasDescription()) continue;
                PdfPCell emptyCell = this.getEmptyCell(ctx.getCellHeight());
                emptyCell.setBorder(0);
                table2.addCell(emptyCell);
                int colspan = this.colNum - 2;
                if (configBean.isIncludeVorRadialsInCalculationResults()) {
                    --colspan;
                }
                if (configBean.isIncludeEmptyAta()) {
                    --colspan;
                }
                if (configBean.isIncludeEta()) {
                    --colspan;
                }
                PdfPCell cell = this.getLeftCell(landmark.getDescription(), ctx.getCellTitleFont(), ctx.getCellHeight());
                cell.setColspan(colspan);
                table2.addCell(cell);
                long t = Math.round((double)segment.getT() * landmark.getPosition());
                border = new CustomBorder(null, solidLine2f, null, null);
                table2.addCell(this.getCenteredCellWithCustomBorder(FormatUtil.formatTimeLandmark(t), ctx.getCellValueT2Font(), ctx.getCellHeight(), border));
                if (configBean.isIncludeVorRadialsInCalculationResults()) {
                    GpsPlace place = ctx.getRoute().getLandmarkPlaceForSegment(MapFrame.getInstance().getMapViewer(), row, i);
                    table2.addCell(this.getCenteredCell(ctx.getRoute().getFormattedTwoClosestVors(place, Constants.EOL), ctx.getCellValueSmallFont(), ctx.getCellHeight()));
                }
                if (configBean.isIncludeEta() && !configBean.isIncludeFilledEta()) {
                    table2.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
                } else if (configBean.isIncludeFilledEta()) {
                    long eta = Math.round((double)segment.getT() * landmark.getPosition());
                    if (row > 0) {
                        eta += ctx.getRoute().getSegments().get(row - 1).getEta();
                    }
                    table2.addCell(this.getCenteredCell(FormatUtil.formatTime(eta), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                }
                if (!configBean.isIncludeEmptyAta()) continue;
                table2.addCell(this.getEmptyEditableCell(ctx.getCellHeight()));
            }
        }
        table2.setSpacingAfter(ctx.getSpacingAfter());
        document.add((Element)table2);
    }
}

