/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class MapRadialsTwoColumnsSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        if (ctx.getRoute().getMapRadials().size() > 0) {
            PdfPTable table5 = new PdfPTable(4);
            table5.setWidths(new int[]{100, 80, 100, 80});
            table5.setWidthPercentage(90.0f);
            for (MapRadials r : ctx.getRoute().getMapRadials()) {
                table5.addCell(this.getLeftCell(r.getName() != null ? r.getName() : "", ctx.getCellMapRadialsFont(), ctx.getCellHeight()));
                StringBuilder sb = new StringBuilder();
                for (Integer idx : r.getVorIdxs()) {
                    GpsPlace vor = ctx.getRoute().getVors().get(idx);
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(vor.getName());
                    sb.append(" ");
                    sb.append(FormatUtil.formatRadial(GpsUtil.getVorRadial(vor, r.getPos()), r.isIncludeDistance()));
                }
                table5.addCell(this.getCenteredCell(sb.toString(), ctx.getCellMapRadialsFont(), ctx.getCellHeight() * (float)((int)Math.floor(r.getVorIdxs().size() / 2))));
            }
            table5.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)table5);
        }
    }
}

