/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import java.util.Map;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class MapRadialsToWpSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        List<GpsPlace> vorsList = ctx.getRoute().getOnlyVors();
        if (vorsList.size() > 0) {
            PdfPTable table = new PdfPTable(ctx.getRoute().getOnlyVors().size() + 1);
            int[] widths = new int[ctx.getRoute().getOnlyVors().size() + 1];
            widths[0] = 55;
            int colWidth = Math.round((255 - widths[0]) / ctx.getRoute().getOnlyVors().size());
            for (int i = 1; i < ctx.getRoute().getOnlyVors().size() + 1; ++i) {
                widths[i] = colWidth;
            }
            table.setWidths(widths);
            table.setWidthPercentage(90.0f);
            table.addCell(this.getCenteredCell(Messages.getInstance().get("table_point"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            for (int q = 0; q < vorsList.size(); ++q) {
                table.addCell(this.getCenteredCell(StringUtil.nullToEmpty(vorsList.get(q).getName()), ctx.getCellTitleFont(), ctx.getCellHeight()));
            }
            for (int q = 0; q < ctx.getRoute().getPoints().size(); ++q) {
                GpsPlace point = ctx.getRoute().getPoints().get(q);
                table.addCell(this.getLeftCell(StringUtil.nullToEmpty(point.getName()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                Object[] row = new Object[vorsList.size() + 1];
                row[0] = point.getName();
                Map<String, LineSegment> radials = ctx.getRoute().getVorRadials(point);
                for (int i = 1; i < vorsList.size() + 1; ++i) {
                    LineSegment radial = radials.get(vorsList.get(i - 1).getName());
                    table.addCell(this.getCenteredCell(FormatUtil.formatRadial(radial), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                }
            }
            table.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)table);
        }
    }
}

