/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import java.io.IOException;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class MapPerWpSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        float mapScale = configBean.isHalfSize() ? 0.7f : 0.89f;
        int minZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMinimumZoomLevel();
        int maxZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMaximumZoomLevel();
        for (int i = 0; i < ctx.getRoute().getPoints().size(); ++i) {
            try {
                document.newPage();
                Paragraph titleParagraph = new Paragraph(ctx.getRoute().getPoints().get(i).getName(), ctx.getHeaderFont());
                titleParagraph.setAlignment(1);
                titleParagraph.setSpacingAfter(10.0f);
                document.add((Element)titleParagraph);
                RotatedGpsArea area = new RotatedGpsArea(GpsUtil.getCircleArea(ctx.getRoute().getPoints().get(i), 1.5));
                PdfUtil.generatePageWithMapRegion(document, area, PdfUtil.calculateZoomForA4Page(area, 300, mapScale, minZoom, maxZoom), configBean.isHalfSize() ? 0.875f : 0.9f, false, null, null, true, false);
                document.newPage();
                continue;
            }
            catch (IOException e) {
                throw new DocumentException((Exception)e);
            }
        }
    }
}

