/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class MapPerLegSection
extends PdfSection {
    private final String pngName = "tmp/vfrflight_map_" + new Date().getTime() + ".png";
    private static final int DPI = 300;
    private static final int SCALE_WIDTH = 300;
    private static final BasicStroke VOR_1_STROKE = new BasicStroke(3.0f, 0, 0, 5.0f, new float[]{10.0f}, 0.0f);
    private static final BasicStroke VOR_2_STROKE = new BasicStroke(3.0f, 0, 0, 2.0f, new float[]{2.0f}, 2.0f);
    private static final Color VOR_1_COLOR = Color.RED;
    private static final Color VOR_2_COLOR = Color.BLUE;

    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        float mapScale = configBean.isHalfSize() ? 0.7f : 0.89f;
        try {
            boolean anyVors = ctx.getRoute().getOnlyVors().size() > 0;
            for (RouteSegment segment : ctx.getRoute().getSegments()) {
                if (!this.prepareMap(segment, configBean, mapScale, configBean.isHalfSize(), ctx.getRoute())) continue;
                document.newPage();
                PdfPTable outerTable = new PdfPTable(2);
                outerTable.setWidths(new int[]{33, 67});
                outerTable.setWidthPercentage(configBean.isHalfSize() ? 99.0f : 90.0f);
                PdfPTable innerTable = new PdfPTable(2);
                innerTable.setWidths(new int[]{100, 100});
                innerTable.setWidthPercentage(33.0f);
                this.createInfoTable(innerTable, segment, configBean, ctx);
                PdfPCell cell = new PdfPCell(innerTable);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                cell.setBorder(0);
                outerTable.addCell(cell);
                Image image = Image.getInstance((String)this.pngName);
                if (image.getWidth() > image.getHeight()) {
                    image.setRotationDegrees(270.0f);
                }
                image.scaleToFit(document.getPageSize().getWidth() * mapScale, document.getPageSize().getHeight() * mapScale);
                image.setAlignment(1);
                PdfPCell cell2 = new PdfPCell(image, false);
                cell2.setHorizontalAlignment(1);
                cell2.setVerticalAlignment(5);
                cell2.setBorder(0);
                if (anyVors && configBean.isOneMapPerLegIncludeVorRadialsTable()) {
                    cell2.setRowspan(2);
                }
                outerTable.addCell(cell2);
                if (anyVors && configBean.isOneMapPerLegIncludeVorRadialsTable()) {
                    PdfPTable vorTable = new PdfPTable(3);
                    vorTable.setWidths(new int[]{50, 75, 75});
                    vorTable.setWidthPercentage(33.0f);
                    this.createVorTable(vorTable, segment, configBean, ctx);
                    cell = new PdfPCell(vorTable);
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setBorder(0);
                    outerTable.addCell(cell);
                }
                File pngFile = new File(this.pngName);
                pngFile.delete();
                document.add((Element)outerTable);
            }
        }
        catch (IOException e) {
            throw new DocumentException((Exception)e);
        }
    }

    private boolean prepareMap(RouteSegment segment, PdfConfigBean configBean, float mapScale, boolean halfPage, Route route) {
        boolean anyVors = route.getOnlyVors().size() > 0;
        double marginRatio = 5.0;
        double marginNm = segment.getDistance() / 5.0;
        GpsPlace topLeft = GpsUtil.getPointPositionByDistanceAndBearing(segment.getTo(), segment.getCourse() - 45.0, marginNm);
        GpsPlace topRight = GpsUtil.getPointPositionByDistanceAndBearing(segment.getTo(), segment.getCourse() + 45.0, marginNm);
        GpsPlace bottomRight = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse() + 135.0, marginNm);
        GpsPlace bottomLeft = GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), segment.getCourse() + 225.0, marginNm);
        RotatedGpsArea area = new RotatedGpsArea(topLeft, topRight, bottomLeft, bottomRight, segment.getCourse());
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            marginNm = UnitUtil.recalculateDistance(marginNm, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        }
        int minZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMinimumZoomLevel();
        int maxZoom = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMaximumZoomLevel();
        int zoom = PdfUtil.calculateZoomForA4Page(area, 300, mapScale, minZoom, maxZoom);
        BufferedImage img = PdfUtil.getMapRegionImage(MapFrame.getInstance().getMapViewer(), area, zoom, false, null, null, true);
        if (anyVors && configBean.isOneMapPerLegDrawVorRadials()) {
            this.drawVorRadials(img, area, route);
        }
        BufferedImage extendedImg = new BufferedImage(img.getWidth() + 300, img.getHeight(), img.getType());
        Graphics2D g = extendedImg.createGraphics();
        GraphicsUtil.setRenderingHints(g, 3);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, extendedImg.getWidth(), extendedImg.getHeight());
        g.drawImage(img, null, 0, 0);
        if (anyVors && configBean.isOneMapPerLegDrawVorRadials()) {
            this.drawVorLegend(extendedImg, area, route);
        }
        double d = marginNm * Math.sqrt(2.0) / 2.0;
        int marginPt = (int)Math.round((double)img.getHeight() / (segment.getDistance() + 2.0 * d) * d);
        int x = (int)Math.round((double)img.getWidth() + 150.0);
        if (configBean.isOneMapPerLegDrawWind() && route.getWindDirection() != null && route.getWindSpeed() != null) {
            System.out.println("crs: " + segment.getCourse());
            int cy = (int)Math.round((double)marginPt / 2.0);
            int r = (int)Math.round((double)extendedImg.getWidth() * 0.075);
            this.drawWind(g, x, cy, r, area.getAngle(), route.getWindSpeed(), route.getWindDirection());
        }
        int fontHeight = (int)Math.round((double)marginPt / 30.0);
        Font labelFont = new Font("SansSerif", 1, fontHeight * 4);
        g.setColor(Color.BLUE);
        g.setFont(labelFont);
        g.drawString(segment.getTo().getName(), img.getWidth() + fontHeight, marginPt - fontHeight * 3);
        g.drawString(segment.getFrom().getName(), img.getWidth() + fontHeight, img.getHeight() - marginPt + fontHeight * 3);
        Font scaleFont = new Font("SansSerif", 1, fontHeight * 3);
        g.setColor(Color.BLACK);
        g.setFont(scaleFont);
        double distPt = (double)img.getHeight() / (segment.getDistance() + 2.0 * d) * segment.getDistance();
        double distInUnits = segment.getDistance();
        double unitPt = distPt / distInUnits;
        double step = 1.0E-4;
        int prec = 4;
        if (distInUnits < 0.01) {
            step = 0.001;
            prec = 3;
        } else if (distInUnits < 0.1) {
            step = 0.01;
            prec = 2;
        } else if (distInUnits < 1.0) {
            step = 0.1;
            prec = 1;
        } else if (distInUnits < 10.0) {
            step = 1.0;
            prec = 0;
        } else if (distInUnits < 100.0) {
            step = 10.0;
            prec = 0;
        } else if (distInUnits < 1000.0) {
            step = 100.0;
            prec = 0;
        }
        int barsNum = (int)Math.floor(distInUnits / step);
        int offset = img.getHeight() - marginPt - (int)Math.round((double)marginPt + (double)barsNum * step * unitPt);
        int barWidth = (int)Math.round(30.0);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(x, offset + marginPt, x, offset + (int)Math.round((double)marginPt + (double)barsNum * step * unitPt));
        for (int i = 0; i <= barsNum; ++i) {
            int y = offset + (int)Math.round((double)marginPt + (double)i * step * unitPt);
            g.drawLine(x, y, x + barWidth, y);
            g.drawString(this.formatDistance((double)(barsNum - i) * step, prec) + SettingsBean.getInstance().getParamUnitsDistance(), x + barWidth * 2, y);
        }
        double totalTimeInMin = (double)segment.getT() / 60.0;
        unitPt = distPt / totalTimeInMin;
        step = 1800.0;
        if (totalTimeInMin < 10.0) {
            step = 1.0;
        } else if (distInUnits < 60.0) {
            step = 5.0;
        } else if (distInUnits < 120.0) {
            step = 10.0;
        } else if (distInUnits < 300.0) {
            step = 60.0;
        } else if (distInUnits < 1800.0) {
            step = 300.0;
        } else if (distInUnits < 3600.0) {
            step = 900.0;
        }
        barsNum = (int)Math.floor(totalTimeInMin / step);
        offset = img.getHeight() - marginPt - (int)Math.round((double)marginPt + (double)barsNum * step * unitPt);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(x, offset + marginPt, x, offset + (int)Math.round((double)marginPt + (double)barsNum * step * unitPt));
        for (int i = 0; i <= barsNum; ++i) {
            int y = offset + (int)Math.round((double)marginPt + (double)i * step * unitPt);
            g.drawLine(x, y, x - barWidth, y);
            String txt = FormatUtil.formatTimeLandmark((double)(barsNum - i) * step * 60.0, false);
            g.drawString(txt, x - barWidth - 5 - (int)g.getFontMetrics().getStringBounds(txt, g).getWidth(), y);
        }
        g.dispose();
        return UrlUtil.saveImage(extendedImg, this.pngName);
    }

    private void drawVorLegend(BufferedImage img, RotatedGpsArea area, Route route) {
        List<GpsPlace> vors = route.getClosestVorPlacesByDistance(area.getCenter());
        if (vors.size() > 0) {
            Graphics2D g = (Graphics2D)img.getGraphics();
            GraphicsUtil.setRenderingHintsHighQuality(g);
            this.drawVorSymbol(g, vors.get(0), img.getWidth() - 100, img.getHeight() - 50, VOR_1_COLOR, VOR_1_STROKE);
            if (vors.size() > 1) {
                this.drawVorSymbol(g, vors.get(1), img.getWidth() - 100, img.getHeight() - 100, VOR_2_COLOR, VOR_2_STROKE);
            }
            g.dispose();
        }
    }

    private void drawWind(Graphics2D g2d, int cx, int cy, int r, double mapAngle, double windSpeed, double windDirection) {
        double navDir = GpsUtil.getNavigationalWindDir(windDirection) + mapAngle;
        System.out.println(mapAngle + " => " + navDir);
        Double rotation = Math.toRadians(navDir - 90.0 + 180.0);
        Double rotation2 = Math.toRadians(-navDir + 90.0 - 180.0);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            g2d.translate(cx, cy);
            g2d.rotate(rotation);
            g2d.translate(-cx, -cy);
            Font windSockFont = new Font("Monospaced", 1, (int)Math.round((double)r / 3.0));
            g2d.setColor(SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor());
            g2d.setStroke(new BasicStroke(5.0f));
            GraphicsUtil.drawArrow(g2d, cx, cy, r + 3);
            g2d.setColor(SettingsBean.getInstance().getColorTheme().getWindSockColor());
            g2d.setStroke(new BasicStroke(3.0f));
            GraphicsUtil.drawArrow(g2d, cx, cy, r);
            g2d.setFont(windSockFont);
            FontMetrics fm = g2d.getFontMetrics();
            StringBuilder txt = new StringBuilder();
            txt.append(FormatUtil.formattedCourse(windDirection, false));
            txt.append("/");
            txt.append(Math.round(windSpeed));
            String str = txt.toString();
            Rectangle2D rect = fm.getStringBounds(str, g2d);
            if (navDir >= 180.0 && navDir < 360.0) {
                GraphicsUtil.drawOutlinedString(g2d, cx - (int)Math.round(rect.getWidth() / 1.5), cy - 5, str, windSockFont, SettingsBean.getInstance().getColorTheme().getWindSockColor(), SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor(), 3.0f);
            } else {
                g2d.translate(cx, cy);
                g2d.rotate(Math.toRadians(180.0));
                g2d.translate(-cx, -cy);
                GraphicsUtil.drawOutlinedString(g2d, cx - (int)Math.round(rect.getWidth() / 3.0), cy - 5, str, windSockFont, SettingsBean.getInstance().getColorTheme().getWindSockColor(), SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor(), 3.0f);
                g2d.translate(cx, cy);
                g2d.rotate(Math.toRadians(-180.0));
                g2d.translate(-cx, -cy);
            }
            g2d.translate(cx, cy);
            g2d.rotate(rotation2);
            g2d.translate(-cx, -cy);
        }
    }

    private void drawVorSymbol(Graphics2D g, GpsPlace vor, int x, int y, Color color, BasicStroke stroke) {
        boolean nav = "VOR".equals(vor.getType()) || "VOR-DME".equals(vor.getType());
        boolean dme = "DME".equals(vor.getType()) || "VOR-DME".equals(vor.getType());
        g.setStroke(stroke);
        g.setColor(color);
        g.drawLine(x - 70, y, x - 20, y);
        GraphicsUtil.drawVorDme(g, x, y, 21, nav, dme, color, null);
        g.setFont(new Font("SansSerif", 1, 30));
        g.drawString(vor.getName(), x + 20, y + 10);
    }

    private void drawVorRadials(BufferedImage img, RotatedGpsArea area, Route route) {
        List<GpsPlace> vors = route.getClosestVorPlacesByDistance(area.getCenter());
        if (vors.size() > 0) {
            Graphics2D g = (Graphics2D)img.getGraphics();
            GraphicsUtil.setRenderingHintsHighQuality(g);
            VfrMapViewer map = MapFrame.getInstance().getMapViewer();
            LineSegment top = new LineSegment(area.getTopLeft(), area.getTopRight());
            LineSegment left = new LineSegment(area.getTopLeft(), area.getBottomLeft());
            LineSegment bottom = new LineSegment(area.getBottomLeft(), area.getBottomRight());
            LineSegment right = new LineSegment(area.getTopRight(), area.getBottomRight());
            int w = img.getWidth();
            int h = img.getHeight();
            int vorNum = 0;
            for (GpsPlace vor : vors) {
                g.setStroke(vorNum == 0 ? VOR_1_STROKE : VOR_2_STROKE);
                Color color = vorNum == 0 ? VOR_1_COLOR : VOR_2_COLOR;
                Font font = new Font("SansSerif", 1, 15);
                g.setFont(font);
                double magvar = vor.getMagvar() != null ? vor.getMagvar() : 0.0;
                LineSegment rad1 = GpsUtil.getVorRadial(vor, top.getCenter());
                LineSegment rad2 = GpsUtil.getVorRadial(vor, bottom.getCenter());
                double radNum = Math.abs(rad1.getMagneticCourse() - rad2.getMagneticCourse());
                int step = (int)Math.ceil(radNum / 5.0);
                if (step <= 0) {
                    step = 360;
                }
                double dist1 = Math.max(GpsUtil.getDistance(vor, area.getTopLeft()), GpsUtil.getDistance(vor, area.getTopRight()));
                double dist2 = Math.max(GpsUtil.getDistance(vor, area.getBottomLeft()), GpsUtil.getDistance(vor, area.getBottomRight()));
                double dist = Math.max(dist1, dist2) + 1.0;
                for (int radial = 0; radial < 360; radial += step) {
                    Integer pxRight;
                    Integer pxLeft;
                    Integer pxBottom;
                    LineSegment radialSeg = new LineSegment(vor, GpsUtil.getPointPositionByDistanceAndBearing(vor, (double)radial + magvar, dist));
                    ArrayList<GpsPoint> points = new ArrayList<GpsPoint>();
                    Integer pxTop = this.getPixelIntersection(map, w, radialSeg, top);
                    if (pxTop != null) {
                        points.add(new GpsPoint(pxTop.intValue(), 0.0));
                    }
                    if ((pxBottom = this.getPixelIntersection(map, w, radialSeg, bottom)) != null) {
                        points.add(new GpsPoint(pxBottom.intValue(), h));
                    }
                    if ((pxLeft = this.getPixelIntersection(map, h, radialSeg, left)) != null) {
                        points.add(new GpsPoint(0.0, pxLeft.intValue()));
                    }
                    if ((pxRight = this.getPixelIntersection(map, h, radialSeg, right)) != null) {
                        points.add(new GpsPoint(w, pxRight.intValue()));
                    }
                    if (points.size() != 2) continue;
                    int x1 = (int)((Point2D)points.get(0)).getX();
                    int y1 = (int)((Point2D)points.get(0)).getY();
                    int x2 = (int)((Point2D)points.get(1)).getX();
                    int y2 = (int)((Point2D)points.get(1)).getY();
                    g.setColor(color);
                    g.drawLine(x1, y1, x2, y2);
                    int x = (int)Math.round((double)(x1 + x2) / 2.0);
                    int y = (int)Math.round((double)(y1 + y2) / 2.0);
                    GraphicsUtil.drawBoxedString(g, x, y, "R" + FormatUtil.formattedCourse(Double.valueOf(radial), false), font, Color.BLACK, color, 2);
                }
                if (++vorNum < 2) continue;
                break;
            }
            g.dispose();
        }
    }

    private Integer getPixelIntersection(VfrMapViewer map, int length, LineSegment vorRadial, LineSegment side) {
        GpsPlace intersection = MapUtil.getLineSegmentsIntersection(map, vorRadial, side);
        if (intersection != null) {
            double d1 = GpsUtil.getDistance(side.getFrom(), side.getTo());
            double d2 = GpsUtil.getDistance(side.getFrom(), intersection);
            return (int)Math.round(d2 / d1 * (double)length);
        }
        return null;
    }

    private String formatDistance(double dist, int prec) {
        if (prec >= 0) {
            return String.valueOf((int)Math.round(dist));
        }
        return String.valueOf(NumberUtil.roundDouble(dist, prec));
    }

    private void createInfoTable(PdfPTable table, RouteSegment segment, PdfConfigBean configBean, PdfContextBean ctx) {
        PdfPCell cell = this.getCenteredCell(segment.getSegmentName(), ctx.getCellValueT2Font(), ctx.getCellHeight());
        cell.setColspan(2);
        table.addCell(cell);
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_nkdg") + " [\u00b0]", ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(FormatUtil.formattedCourse(segment.getCourse(), false), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_nkdm") + " [\u00b0]", ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(FormatUtil.formattedCourse(segment.getMagneticCourse(), false), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_kz") + " [\u00b0]", ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(String.valueOf(Math.round(segment.getKz())), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_km") + " [\u00b0]", ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(FormatUtil.formattedCourse(segment.getKm(), false), ctx.getCellValueBIT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_distance") + UnitUtil.getDistanceUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        if (segment.getDistance() < 100.0) {
            table.addCell(this.getCenteredCell(String.valueOf((double)Math.round(segment.getDistance() * 10.0) / 10.0), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        } else {
            table.addCell(this.getCenteredCell(String.valueOf((int)Math.round(segment.getDistance())), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        }
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_speed") + UnitUtil.getSpeedUnit(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(String.valueOf(Math.round(segment.getW())), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_duration"), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
        table.addCell(this.getCenteredCell(FormatUtil.formatTimeLandmark(segment.getT()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
        if (configBean.isIncludeEta()) {
            table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_eta"), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
            if (!configBean.isIncludeFilledEta()) {
                table.addCell(this.getCenteredCell(FormatUtil.formatTime(segment.getEta()), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            } else {
                table.addCell(this.getCenteredCell("", ctx.getCellValueT2Font(), ctx.getCellHeight()));
            }
        }
        if (configBean.isIncludeEmptyAta()) {
            table.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_ata"), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
            table.addCell(this.getCenteredCell("", ctx.getCellValueT2Font(), ctx.getCellHeight()));
        }
    }

    private void createVorTable(PdfPTable table, RouteSegment segment, PdfConfigBean configBean, PdfContextBean ctx) {
        List<GpsPlace> vors = ctx.getRoute().getClosestVorPlacesByDistance(segment.getCenter());
        if (vors.size() > 0) {
            table.addCell(this.getEmptyCell(ctx.getCellHeight()));
            table.addCell(this.getCenteredCell(segment.getFrom().getName(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
            table.addCell(this.getCenteredCell(segment.getTo().getName(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
            for (GpsPlace vor : vors) {
                table.addCell(this.getCenteredCell(vor.getName(), ctx.getCellTitleT2Font(), ctx.getCellHeight()));
                table.addCell(this.getCenteredCell(FormatUtil.formatRadial(GpsUtil.getVorRadial(vor, segment.getFrom()), true, true), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                table.addCell(this.getCenteredCell(FormatUtil.formatRadial(GpsUtil.getVorRadial(vor, segment.getTo()), true, true), ctx.getCellValueT2Font(), ctx.getCellHeight()));
            }
        }
    }
}

