/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class FlightPlanRouteSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        if (ctx.getRoute().getPoints().size() > 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < ctx.getRoute().getPoints().size() - 1; ++i) {
                RoutePlace place = ctx.getRoute().getPoints().get(i);
                sb.append(place.getName());
                sb.append(" (");
                sb.append(FormatUtil.formatGpsPlaceFlightPlan(place));
                sb.append(") ");
            }
            Paragraph vors = new Paragraph(sb.toString().trim(), ctx.getCellFisInfoFont());
            vors.setAlignment(1);
            vors.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)vors);
        }
    }
}

