/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.pdf.sections;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.pdf.util.PdfContextBean;
import main.java.guru.vfrflight.pdf.util.PdfSection;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class AlternateAirportsSection
extends PdfSection {
    @Override
    public void create(Document document, PdfConfigBean configBean, PdfContextBean ctx) throws DocumentException {
        if (ctx.getRoute().getAlternateAirports().size() > 0) {
            PdfPTable table4 = new PdfPTable(4);
            table4.setWidths(new int[]{75, 50, 50, 80});
            table4.setWidthPercentage(90.0f);
            table4.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_alternate_airports"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            table4.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_arp_elevation"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            table4.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_frequency"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            table4.addCell(this.getCenteredCell(Messages.getInstance().get("pdf_plan_radio_navaids"), ctx.getCellTitleFont(), ctx.getCellHeight()));
            for (AlternateAirport a : ctx.getRoute().getAlternateAirports()) {
                String[] rows = new String[4];
                rows[0] = a.getIdent();
                if (a.getElev() != null) {
                    rows[1] = a.getElev().toString() + SettingsBean.getInstance().getParamUnitsAltitude();
                }
                if (a.getFrequency() != null) {
                    rows[2] = String.valueOf(NumberUtil.roundDouble(a.getFrequency(), 3));
                }
                if (ctx.getRoute().getOnlyVors().size() > 0) {
                    rows[3] = ctx.getRoute().getFormattedTwoClosestVors(a.getGpsPlace(), Constants.EOL);
                }
                for (int i = 0; i < 4; ++i) {
                    table4.addCell(i == 0 ? this.getLeftCell(StringUtil.nullToEmpty(rows[i]), ctx.getCellValueT2Font(), ctx.getCellHeight()) : this.getCenteredCell(StringUtil.nullToEmpty(rows[i]), ctx.getCellValueT2Font(), ctx.getCellHeight()));
                }
            }
            table4.setSpacingAfter(ctx.getSpacingAfter());
            document.add((Element)table4);
        }
    }
}

