/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.nmea.message.GpMessage;
import main.java.guru.vfrflight.nmea.message.GpggaMessage;
import main.java.guru.vfrflight.nmea.message.GpgsaMessage;
import main.java.guru.vfrflight.nmea.message.GprmcMessage;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class NmeaUtil {
    private static final Logger log = Logger.getLogger(NmeaUtil.class);
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("ddMMyy HHmmss z");

    public static GpggaMessage parseGpgga(String msg) {
        if (StringUtil.isEmpty(msg) || !msg.startsWith("$GPGGA")) {
            log.error("Not a GPGAA message: " + msg);
            return null;
        }
        String[] tokens = msg.split(",");
        if (tokens.length >= 12) {
            try {
                GpggaMessage result = new GpggaMessage();
                result.setTimeUtc(tokens[1]);
                if (!StringUtil.isEmpty(tokens[2]) && !StringUtil.isEmpty(tokens[3])) {
                    result.setLat(NmeaUtil.parseNmeaCoord(tokens[3] + tokens[2]));
                }
                if (!StringUtil.isEmpty(tokens[4]) && !StringUtil.isEmpty(tokens[5])) {
                    result.setLon(NmeaUtil.parseNmeaCoord(tokens[5] + tokens[4]));
                }
                result.setFixQuality(Integer.valueOf(tokens[6]));
                result.setNumberOfSatellites(Integer.valueOf(tokens[7]));
                result.setHorizontalDillution(Float.valueOf(tokens[8]));
                if ("M".equals(tokens[10])) {
                    result.setAltitudeAmslInMeters(Float.valueOf(tokens[9]));
                }
                if ("M".equals(tokens[12])) {
                    result.setHeightOfGeoidAboveWgs84Ellipsoid(Float.valueOf(tokens[11]));
                }
                return result;
            }
            catch (NumberFormatException e) {
                log.error("Invalid GPGAA message: " + msg, e);
            }
        }
        return null;
    }

    public static GprmcMessage parseGprmc(String msg) {
        if (StringUtil.isEmpty(msg) || !msg.startsWith("$GPRMC")) {
            log.error("Not a GPRMC message: " + msg);
            return null;
        }
        String[] tokens = msg.split(",");
        if (tokens.length >= 12) {
            try {
                GprmcMessage result = new GprmcMessage();
                result.setTimeUtc(tokens[1]);
                result.setStatus(tokens[2]);
                if (!StringUtil.isEmpty(tokens[3]) && !StringUtil.isEmpty(tokens[4])) {
                    result.setLat(NmeaUtil.parseNmeaCoord(tokens[4] + tokens[3]));
                }
                if (!StringUtil.isEmpty(tokens[5]) && !StringUtil.isEmpty(tokens[6])) {
                    result.setLon(NmeaUtil.parseNmeaCoord(tokens[6] + tokens[5]));
                }
                if (!StringUtil.isEmpty(tokens[7])) {
                    result.setGroundSpeedInKt(Float.valueOf(tokens[7]));
                }
                if (!StringUtil.isEmpty(tokens[8])) {
                    result.setTrueTrackAngle(Float.valueOf(tokens[8]));
                }
                result.setDate(tokens[9]);
                if (!StringUtil.isEmpty(tokens[10])) {
                    float magvar = Float.valueOf(tokens[10]).floatValue();
                    if ("W".equals(tokens[11])) {
                        magvar = -magvar;
                    }
                    result.setMagneticVariation(Float.valueOf(magvar));
                }
                return result;
            }
            catch (NumberFormatException e) {
                log.error("Invalid GPRMC message: " + msg, e);
            }
        }
        return null;
    }

    public static GpgsaMessage parseGpgsa(String msg) {
        if (StringUtil.isEmpty(msg) || !msg.startsWith("$GPGSA")) {
            log.error("Not a GPGSA message: " + msg);
            return null;
        }
        String[] tokens = msg.split(",");
        if (tokens.length >= 17) {
            try {
                GpgsaMessage result = new GpgsaMessage();
                result.setAutoSelectionFix(tokens[1]);
                result.setThreeDFix(Integer.valueOf(tokens[2]));
                HashSet<String> prns = new HashSet<String>();
                for (int i = 3; i < 15; ++i) {
                    if (StringUtil.isEmpty(tokens[i])) continue;
                    prns.add(tokens[i]);
                }
                result.setSatellitePrns(prns);
                result.setDilutionOfPrecision(Float.valueOf(tokens[15]));
                result.setHorizontalDilutionOfPrecision(Float.valueOf(tokens[16]));
                if (!StringUtil.isEmpty(tokens[17])) {
                    String[] tkns = tokens[17].split("\\*");
                    result.setVerticalDilutionOfPrecision(Float.valueOf(tkns[0]));
                }
                return result;
            }
            catch (NumberFormatException e) {
                log.error("Invalid GPGSA message: " + msg, e);
            }
        }
        return null;
    }

    public static GpsCoord parseNmeaCoord(String coord) {
        if (StringUtil.isEmpty(coord) || !coord.matches("^((N|S|E|W){1}[0-9]{4,5}(\\.)[0-9]{5})$")) {
            log.error("Invalid NMEA coord: " + coord);
            return null;
        }
        int offset = coord.startsWith("N") || coord.startsWith("S") ? 0 : 1;
        int deg = Integer.valueOf(coord.substring(1, offset + 3));
        if (coord.startsWith("S") || coord.startsWith("W")) {
            deg = -deg;
        }
        int min = Integer.valueOf(coord.substring(offset + 3, offset + 5));
        String[] tokens = coord.split("\\.");
        double sec = (double)Float.valueOf("." + tokens[1]).floatValue() * 60.0;
        return new GpsCoord(deg, min, sec);
    }

    public static GpMessage.Precision getPrecision(Float value) {
        if (value == null) {
            return GpMessage.Precision.UNKNOWN;
        }
        if (value.floatValue() < 1.0f) {
            return GpMessage.Precision.IDEAL;
        }
        if (value.floatValue() < 2.0f) {
            return GpMessage.Precision.EXCELLENT;
        }
        if (value.floatValue() < 5.0f) {
            return GpMessage.Precision.GOOD;
        }
        if (value.floatValue() < 10.0f) {
            return GpMessage.Precision.MODERATE;
        }
        if (value.floatValue() < 20.0f) {
            return GpMessage.Precision.FAIR;
        }
        return GpMessage.Precision.POOR;
    }

    public static Long parseTimestamp(String timeUtc, String date) {
        if (timeUtc == null || !timeUtc.matches("^([0-9]{6}(\\.)[0-9]{2})$") || date == null || !date.matches("^([0-9]{6})$")) {
            return null;
        }
        String[] timeSplit = timeUtc.split("\\.");
        long miliseconds = Long.valueOf(timeSplit[1]) * 10L;
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(DATE_TIME_FORMAT.parse(date + " " + timeSplit[0] + " UTC"));
            return cal.getTimeInMillis() + miliseconds;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static void parseNmea(String currLine, GpMessage message) {
        log.debug("MSG = [" + currLine + "]");
        if (currLine.startsWith("$GPGGA") || currLine.startsWith("$GPRMC") || currLine.startsWith("$GPGSA")) {
            message.setLastMessageTimestamp(System.currentTimeMillis());
            if (currLine.startsWith("$GPGGA")) {
                message.setGpggaMessage(NmeaUtil.parseGpgga(currLine));
            } else if (currLine.startsWith("$GPRMC")) {
                message.setGprmcMessage(NmeaUtil.parseGprmc(currLine));
            } else {
                message.setGpgsaMessage(NmeaUtil.parseGpgsa(currLine));
            }
        }
    }
}

