/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea.util;

import main.java.guru.vfrflight.nmea.GPSReader;
import main.java.guru.vfrflight.nmea.NmeaLogReader;
import main.java.guru.vfrflight.nmea.NmeaReader;
import org.apache.log4j.Logger;

public class NmeaReaderFactory {
    private static final Logger log = Logger.getLogger(NmeaReaderFactory.class);

    public static NmeaReader initGpsConnection(long timeoutInMs, String outputFile) {
        log.info("Creating connection for NMEA GPS");
        GPSReader gpsReader = new GPSReader();
        gpsReader.setOutputFilename(outputFile);
        new Thread(gpsReader).start();
        boolean timeout = false;
        long millis = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = timeout = System.currentTimeMillis() - millis >= timeoutInMs;
        } while (gpsReader.isRunning() && !gpsReader.isValidData() && !timeout);
        if (timeout) {
            gpsReader.setRunning(false);
            return null;
        }
        return gpsReader;
    }

    public static NmeaReader initNmeaLogConnection(String inputFile) {
        log.info("Creating connection for NMEA LOG FILE " + inputFile);
        NmeaLogReader reader = new NmeaLogReader(inputFile);
        new Thread(reader).start();
        return reader;
    }
}

