/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea.message;

import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.nmea.message.GpggaMessage;
import main.java.guru.vfrflight.nmea.message.GpgsaMessage;
import main.java.guru.vfrflight.nmea.message.GprmcMessage;
import main.java.guru.vfrflight.nmea.util.NmeaUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class GpMessage
implements ExtConnectBean {
    private GpsCoord lat;
    private GpsCoord lon;
    private Float amslInFt;
    private Integer numberOfSatellites;
    private boolean valid = false;
    private String timeUtc;
    private String date;
    private Float groundSpeedInKt;
    private Float trueTrackAngle;
    private Float magneticVariation;
    private Precision precision;
    private Precision horizontalPrecision;
    private Precision verticalPrecision;
    private Long lastMessageTimestamp;

    @Override
    public GpMessage clone() {
        GpMessage msg = new GpMessage();
        msg.setAmslInFt(this.amslInFt);
        msg.setDate(this.date);
        msg.setGroundSpeedInKt(this.groundSpeedInKt);
        msg.setHorizontalPrecision(this.horizontalPrecision);
        msg.setLat(this.lat);
        msg.setLon(this.lon);
        msg.setMagneticVariation(this.magneticVariation);
        msg.setNumberOfSatellites(this.numberOfSatellites);
        msg.setPrecision(this.horizontalPrecision);
        msg.setTimeUtc(this.timeUtc);
        msg.setTrueTrackAngle(this.trueTrackAngle);
        msg.setValid(this.valid);
        msg.setVerticalPrecision(this.verticalPrecision);
        return msg;
    }

    public void setGpggaMessage(GpggaMessage msg) {
        if (msg.getLat() != null) {
            this.lat = msg.getLat();
        }
        if (msg.getLon() != null) {
            this.lon = msg.getLon();
        }
        this.numberOfSatellites = msg.getNumberOfSatellites();
        this.amslInFt = msg.getAltitudeAmslInMeters();
        if (this.amslInFt != null) {
            this.amslInFt = Float.valueOf((float)UnitUtil.recalculateAltitude(this.amslInFt.floatValue(), "m", "ft", false));
        }
        this.timeUtc = msg.getTimeUtc();
    }

    public void setGpgsaMessage(GpgsaMessage msg) {
        this.precision = NmeaUtil.getPrecision(msg.getDilutionOfPrecision());
        this.horizontalPrecision = NmeaUtil.getPrecision(msg.getHorizontalDilutionOfPrecision());
        this.verticalPrecision = NmeaUtil.getPrecision(msg.getVerticalDilutionOfPrecision());
    }

    public void setGprmcMessage(GprmcMessage msg) {
        this.timeUtc = msg.getTimeUtc();
        if (msg.getLat() != null) {
            this.lat = msg.getLat();
        }
        if (msg.getLon() != null) {
            this.lon = msg.getLon();
        }
        this.groundSpeedInKt = msg.getGroundSpeedInKt();
        this.trueTrackAngle = msg.getTrueTrackAngle();
        this.date = msg.getDate();
        this.magneticVariation = msg.getMagneticVariation();
        this.valid = msg.isValid();
    }

    public GpsCoord getLat() {
        return this.lat;
    }

    public void setLat(GpsCoord lat) {
        this.lat = lat;
    }

    public GpsCoord getLon() {
        return this.lon;
    }

    public void setLon(GpsCoord lon) {
        this.lon = lon;
    }

    public Float getAmslInFt() {
        return this.amslInFt;
    }

    public void setAmslInFt(Float amslInFt) {
        this.amslInFt = amslInFt;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public Float getGroundSpeedInKt() {
        return this.groundSpeedInKt;
    }

    public void setGroundSpeedInKt(Float groundSpeedInKt) {
        this.groundSpeedInKt = groundSpeedInKt;
    }

    public Float getTrueTrackAngle() {
        return this.trueTrackAngle;
    }

    public void setTrueTrackAngle(Float trueTrackAngle) {
        this.trueTrackAngle = trueTrackAngle;
    }

    public Float getMagneticVariation() {
        return this.magneticVariation;
    }

    public void setMagneticVariation(Float magneticVariation) {
        this.magneticVariation = magneticVariation;
    }

    public Integer getNumberOfSatellites() {
        return this.numberOfSatellites;
    }

    public void setNumberOfSatellites(Integer numberOfSatellites) {
        this.numberOfSatellites = numberOfSatellites;
    }

    public String getTimeUtc() {
        return this.timeUtc;
    }

    public void setTimeUtc(String timeUtc) {
        this.timeUtc = timeUtc;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    public Precision getHorizontalPrecision() {
        return this.horizontalPrecision;
    }

    public void setHorizontalPrecision(Precision horizontalPrecision) {
        this.horizontalPrecision = horizontalPrecision;
    }

    public Precision getVerticalPrecision() {
        return this.verticalPrecision;
    }

    public void setVerticalPrecision(Precision verticalPrecision) {
        this.verticalPrecision = verticalPrecision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GpMessage [lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", amslInFt=");
        builder.append(this.amslInFt);
        builder.append(", numberOfSatellites=");
        builder.append(this.numberOfSatellites);
        builder.append(", valid=");
        builder.append(this.valid);
        builder.append(", timeUtc=");
        builder.append(this.timeUtc);
        builder.append(", date=");
        builder.append(this.date);
        builder.append(", groundSpeedInKt=");
        builder.append(this.groundSpeedInKt);
        builder.append(", trueTrackAngle=");
        builder.append(this.trueTrackAngle);
        builder.append(", magneticVariation=");
        builder.append(this.magneticVariation);
        builder.append(", precision=");
        builder.append((Object)this.precision);
        builder.append(", horizontalPrecision=");
        builder.append((Object)this.horizontalPrecision);
        builder.append(", verticalPrecision=");
        builder.append((Object)this.verticalPrecision);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean positionEquals(ExtConnectBean bean) {
        if (bean == null || !(bean instanceof GpMessage)) {
            return false;
        }
        GpMessage other = (GpMessage)bean;
        return NumberUtil.doubleEqualsDouble(this.getLat().getValue(), other.getLat().getValue(), 5) && NumberUtil.doubleEqualsDouble(this.getLon().getValue(), other.getLon().getValue(), 5);
    }

    @Override
    public Float getUserLat() {
        if (this.getLat() == null) {
            return null;
        }
        return Float.valueOf((float)this.getLat().getValue());
    }

    @Override
    public Float getUserLon() {
        if (this.getLon() == null) {
            return null;
        }
        return Float.valueOf((float)this.getLon().getValue());
    }

    @Override
    public Float getUserAlt() {
        return this.getAmslInFt();
    }

    @Override
    public Float getUserIndicatedAlt() {
        return null;
    }

    @Override
    public Float getUserGs() {
        return this.getGroundSpeedInKt();
    }

    @Override
    public Float getUserTrueHeading() {
        return this.getTrueTrackAngle();
    }

    @Override
    public Float getUserMagHeading() {
        if (this.getTrueTrackAngle() == null || this.getMagneticVariation() == null) {
            return null;
        }
        return Float.valueOf(this.getTrueTrackAngle().floatValue() - this.getMagneticVariation().floatValue());
    }

    @Override
    public Float getMagVariation() {
        return this.getMagneticVariation();
    }

    @Override
    public Float getUserAltAboveTerrain() {
        return null;
    }

    @Override
    public Float getUserVerticalSpeed() {
        return null;
    }

    @Override
    public Float getUserIndicatedSpeed() {
        return null;
    }

    @Override
    public Float getUserPitch() {
        return null;
    }

    @Override
    public Float getUserBank() {
        return null;
    }

    @Override
    public Float getgForce() {
        return null;
    }

    @Override
    public Float getWindVelocity() {
        return null;
    }

    @Override
    public Float getWindDirection() {
        return null;
    }

    @Override
    public Short getFlapsHandle() {
        return null;
    }

    @Override
    public Float getYokeXPosition() {
        return null;
    }

    @Override
    public Float getYokeYPosition() {
        return null;
    }

    @Override
    public Float getRudderPeddalsPosition() {
        return null;
    }

    @Override
    public boolean isOnGround() {
        return false;
    }

    @Override
    public Long getTimestamp() {
        return NmeaUtil.parseTimestamp(this.getTimeUtc(), this.getDate());
    }

    @Override
    public float getGroundLevel() {
        return 0.0f;
    }

    @Override
    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.getLat(), this.getLon());
    }

    @Override
    public boolean hasData() {
        return this.getLat() != null && this.getLon() != null;
    }

    @Override
    public boolean isInside(GpsArea area) {
        return this.lat.getValue() <= area.getMaxLat() && this.lat.getValue() >= area.getMinLat() && this.lon.getValue() >= area.getMinLon() && this.lon.getValue() <= area.getMaxLon();
    }

    @Override
    public Float getUserTas() {
        return null;
    }

    @Override
    public Float getFps() {
        return null;
    }

    public Long getLastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    public void setLastMessageTimestamp(Long lastMessageTimestamp) {
        this.lastMessageTimestamp = lastMessageTimestamp;
    }

    public static enum Precision {
        IDEAL,
        EXCELLENT,
        GOOD,
        MODERATE,
        FAIR,
        POOR,
        UNKNOWN;

    }
}

