/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.locks.LockSupport;
import main.java.guru.vfrflight.nmea.NmeaReader;
import main.java.guru.vfrflight.nmea.message.GpMessage;
import main.java.guru.vfrflight.nmea.util.NmeaUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class NmeaLogReader
implements Runnable,
NmeaReader {
    private static final Logger log = Logger.getLogger(NmeaLogReader.class);
    private static final double SPEED_CHANGE_FACTOR = 1.0;
    private boolean running = true;
    private final String inputFile;
    private final GpMessage message = new GpMessage();

    public NmeaLogReader(String inputFile) {
        this.inputFile = inputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        log.info("NmeaLogReader START");
        File file = new File(this.inputFile);
        if (file.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = br.readLine();
                long startMillisFromFile = Long.valueOf(line.split(";")[0]);
                long startMillis = System.currentTimeMillis();
                while (this.running && line != null) {
                    String[] tokens = line.split(";");
                    long millisThresholdToWait = Math.round((Double.valueOf(tokens[0]) - (double)startMillisFromFile) / 1.0) + startMillis;
                    String currLine = tokens[1];
                    NmeaUtil.parseNmea(currLine, this.message);
                    line = br.readLine();
                    while (this.running && System.currentTimeMillis() < millisThresholdToWait) {
                        LockSupport.parkNanos(200L);
                    }
                }
            }
            catch (Exception e) {
                try {
                    log.error(e, e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
                IOUtil.closeQuietly(br);
            }
            IOUtil.closeQuietly(br);
        }
        log.info("NmeaLogReader STOP");
        this.running = false;
    }

    @Override
    public void setRunning(boolean run) {
        this.running = run;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public GpMessage getData() {
        if (this.message.isValid()) {
            return this.message.clone();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.running;
    }
}

