/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import main.java.guru.vfrflight.nmea.GPSDataEventListener;
import main.java.guru.vfrflight.nmea.NmeaReader;
import main.java.guru.vfrflight.nmea.message.GpMessage;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class GPSReader
implements Runnable,
SerialPortEventListener,
NmeaReader {
    private static final Logger log = Logger.getLogger(GPSReader.class);
    private long portScanTime = 2000L;
    private long updateTime = 500L;
    private boolean connected = false;
    private InputStream inputStream;
    private GPSDataEventListener dataListener;
    private SerialPort gpsPort = null;
    private boolean running = true;
    private String outputFilename = null;
    private BufferedWriter outputWriter = null;
    private static final String regExp = "((\\$GPGGA)|(\\$GPRMC)|(\\$GPGSA)|(\\$GPGLL)|(\\$GPGSV)|(\\$GPVTG)).*";

    private boolean findPort() {
        Enumeration enumer = CommPortIdentifier.getPortIdentifiers();
        while (enumer.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)enumer.nextElement();
            if (port.getPortType() != 1 || port.isCurrentlyOwned()) continue;
            SerialPort serialPort = null;
            try {
                serialPort = (SerialPort)port.open("MY_PORT_NAME", 2000);
                log.info("Trying port: " + port.getName());
                this.inputStream = null;
                this.inputStream = serialPort.getInputStream();
                if (this.inputStream == null) {
                    return false;
                }
                serialPort.addEventListener((SerialPortEventListener)this);
                serialPort.notifyOnDataAvailable(true);
                serialPort.setSerialPortParams(4800, 8, 1, 0);
                Thread.sleep(this.portScanTime);
            }
            catch (PortInUseException e) {
                log.error((Object)e, e);
            }
            catch (IOException e) {
                log.error(e, e);
            }
            catch (TooManyListenersException e) {
                log.error(e, e);
            }
            catch (UnsupportedCommOperationException e) {
                log.error((Object)e, e);
            }
            catch (InterruptedException e) {
                log.error(e, e);
            }
            if (this.isConnected()) {
                log.info("Found Stream on com port " + serialPort.getName());
                serialPort.removeEventListener();
                if (this.outputFilename != null) {
                    try {
                        this.outputWriter = new BufferedWriter(new FileWriter(new File(this.outputFilename).getAbsoluteFile()));
                    }
                    catch (IOException e) {
                        log.error(e, e);
                    }
                }
                this.setDataListener(new GPSDataEventListener(this.inputStream, this.outputWriter));
                this.gpsPort = serialPort;
                try {
                    serialPort.addEventListener((SerialPortEventListener)this.getDataListener());
                    serialPort.notifyOnDataAvailable(true);
                }
                catch (TooManyListenersException e) {
                    log.error(e, e);
                }
                return true;
            }
            IOUtil.closeQuietly(this.inputStream);
            if (serialPort == null) continue;
            serialPort.close();
        }
        log.info("No Stream found!");
        return false;
    }

    @Override
    public void run() {
        try {
            this.running = true;
            while (this.running) {
                if (this.isConnected() && this.getDataListener() != null && this.getDataListener().isConnection()) {
                    if (!this.isValidData()) {
                        log.debug("Connected to device, but data is not valid");
                    }
                } else {
                    if (this.getDataListener() != null) {
                        this.closeConnection();
                    }
                    this.findPort();
                }
                Thread.sleep(this.updateTime);
            }
        }
        catch (InterruptedException e) {
            log.error(e, e);
        }
        catch (Exception e) {
            log.error(e, e);
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        log.info("Closing GPS connection ...");
        this.setDataListener(null);
        if (this.gpsPort != null) {
            this.gpsPort.close();
            this.gpsPort.removeEventListener();
            this.gpsPort = null;
        }
        if (this.outputWriter != null) {
            IOUtil.closeQuietly(this.outputWriter);
        }
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() == 1 && !this.connected) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = null;
            try {
                if (reader.ready() && (line = reader.readLine()) != null && line.matches(regExp)) {
                    this.connected = true;
                }
            }
            catch (IOException e) {
                log.error(e, e);
                try {
                    reader.close();
                    this.closeConnection();
                }
                catch (IOException ex) {
                    log.error(ex, ex);
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error(e, e);
                }
            }
        }
    }

    private void setDataListener(GPSDataEventListener dataListener) {
        this.dataListener = dataListener;
    }

    private GPSDataEventListener getDataListener() {
        return this.dataListener;
    }

    @Override
    public void setRunning(boolean run) {
        this.running = run;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isValidData() {
        return this.isConnected() && this.getDataListener() != null && this.getDataListener().isValidData();
    }

    @Override
    public GpMessage getData() {
        if (this.isValidData()) {
            return this.getDataListener().getMessage().clone();
        }
        return null;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }
}

