/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.nmea;

import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.nmea.message.GpMessage;
import main.java.guru.vfrflight.nmea.util.NmeaUtil;
import org.apache.log4j.Logger;

public class GPSDataEventListener
implements SerialPortEventListener {
    private static final Logger log = Logger.getLogger(GPSDataEventListener.class);
    private InputStream inputStream;
    private BufferedWriter writer;
    private boolean connection = true;
    private final GpMessage message = new GpMessage();

    public GPSDataEventListener(InputStream inputStream, BufferedWriter writer) {
        this.inputStream = inputStream;
        this.writer = writer;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public void setWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        block16: {
            try {
                if (event.getEventType() != 1) break block16;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                try {
                    if (!reader.ready()) {
                        this.setConnection(false);
                    }
                    while (reader.ready()) {
                        String currLine = reader.readLine();
                        if (this.writer != null) {
                            this.writer.write(System.currentTimeMillis() + ";" + currLine + Constants.EOL);
                        }
                        NmeaUtil.parseNmea(currLine, this.getMessage());
                    }
                }
                catch (IOException e) {
                    this.setConnection(false);
                    log.error(e, e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error(e, e);
                    }
                }
            }
            catch (Throwable e) {
                this.setConnection(false);
                log.error(e, e);
            }
        }
    }

    public void setConnection(boolean connection) {
        this.connection = connection;
    }

    public boolean isConnection() {
        return this.connection;
    }

    public boolean isValidData() {
        return this.getMessage().isValid();
    }

    public synchronized GpMessage getMessage() {
        return this.message;
    }
}

