/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.helper;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.helper.DropboxHelper;
import org.apache.log4j.Logger;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.text.BasicTextEncryptor;

public class DropboxHelperMock
implements DropboxHelper {
    private static final Logger log = Logger.getLogger(DropboxHelperMock.class);
    private final String pass = "[re;g21dddasas1?BHE";
    private List<String> files = new ArrayList<String>();
    private String authorizationCode;
    private boolean authorized = false;

    public DropboxHelperMock() {
        this.files.add("/eppr_epgd.vfr");
        this.files.add("/xxx.vfr");
        this.files.add("/epel_eppr_epgd_sopot.vfr");
    }

    @Override
    public String getAuthorizationUrl() {
        return "http://example.com";
    }

    @Override
    public boolean authorize() {
        if (this.authorizationCode != null) {
            return this.authorize(this.decrypt(this.authorizationCode));
        }
        return false;
    }

    @Override
    public boolean authorize(String code) {
        this.authorizationCode = this.encrypt(code);
        if (this.authorizationCode != null) {
            this.authorized = true;
            log.debug("Linked account: test : " + code);
            return true;
        }
        return false;
    }

    @Override
    public boolean uploadFile(String source, String destination) {
        log.debug("Uploading file: " + source + " (as " + destination + ")");
        this.files.add(destination);
        return true;
    }

    @Override
    public boolean downloadFile(String source, String destination) {
        log.debug("Downloading file: " + source + " (as " + destination + ")");
        return true;
    }

    @Override
    public List<String> getRootFileList() {
        return this.files;
    }

    @Override
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Override
    public boolean isAuthorized() {
        return this.authorized;
    }

    @Override
    public void disconnect() {
        this.authorizationCode = null;
        this.authorized = false;
        log.debug("Disconnected form dropbox account.");
    }

    private String encrypt(String code) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword("[re;g21dddasas1?BHE");
        try {
            return textEncryptor.encrypt(code);
        }
        catch (EncryptionOperationNotPossibleException encryptionOperationNotPossibleException) {
            return null;
        }
    }

    private String decrypt(String code) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword("[re;g21dddasas1?BHE");
        try {
            return textEncryptor.decrypt(code);
        }
        catch (EncryptionOperationNotPossibleException encryptionOperationNotPossibleException) {
            return null;
        }
    }

    @Override
    public boolean deleteFile(String source) {
        this.files.remove(source);
        return true;
    }

    @Override
    public String getAccountName() {
        return "Jimi Hendrix";
    }

    @Override
    public boolean fileExists(String name) {
        if (this.files != null) {
            return this.files.contains(name);
        }
        return false;
    }
}

