/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.xplane;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.search.SearchParams;
import main.java.guru.vfrflight.core.xplane.XplaneImportBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.sql.facade.xp.XplaneImportFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.Timer;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.XplaneImportUtil;
import org.apache.log4j.Logger;

public class XplaneImportTask
implements Runnable {
    private List<SceneryConfigEntry> sceneryPaths = null;
    private XplaneImportBean importBean;
    private static final Logger log = Logger.getLogger(XplaneImportTask.class);

    public XplaneImportTask(XplaneImportBean importBean, List<SceneryConfigEntry> sceneryPaths) {
        this.sceneryPaths = sceneryPaths;
        this.importBean = importBean;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true);
        log.info("STARTED AT " + new Date());
        Timer.getInstance().start("XplaneImportTask");
        try {
            int i;
            XplaneImportFacade importFacade = new XplaneImportFacade(DBUtil.getDataSource());
            importFacade.initBeforeImport(this.importBean);
            MapFrame.getInstance().refreshAllObjects(false);
            this.doImport(importFacade, true);
            this.doImport(importFacade, false);
            log.info("Scenery paths import finished at " + new Date());
            Timer.getInstance().start("XplaneImportTask:inserts");
            if (SettingsBean.getInstance().isLogLevelTrace()) {
                log.trace("====================================================================================");
                log.trace("NAVAIDSs: " + this.importBean.getNavaids().size());
                log.trace("AIRPORTs: " + this.importBean.getAirportsAsList().size());
                log.trace("WAYPOINTs: " + this.importBean.getWaypoints().size());
                log.trace("ROUTEs: " + this.importBean.getRoutes().size());
                log.trace("====================================================================================");
            }
            if (this.importBean.isImportAirports()) {
                i = importFacade.insertAirports(this.importBean);
                log.info("TOTAL AIRPORTs: " + i);
            }
            if (this.importBean.isImportNavaids()) {
                i = importFacade.insertNavaids(this.importBean);
                log.info("TOTAL NAVAIDs: " + i);
            }
            if (this.importBean.isImportWaypoints()) {
                i = importFacade.insertWaypoints(this.importBean);
                log.info("TOTAL WAYPOINTS: " + i);
            }
            if (this.importBean.isImportRoutes()) {
                i = importFacade.insertRoutes(this.importBean);
                log.info("TOTAL ROUTES: " + i);
            }
            Timer.getInstance().stop("XplaneImportTask:inserts", false);
            SettingsBean.getInstance().setAirportsTableSource("XPLANE");
            SettingsBean.getInstance().setNavaidsTableSource("XPLANE");
            XplaneImportUtil.importOrtho4XPAirspaces(this.sceneryPaths);
            Timer.getInstance().stop("XplaneImportTask", false);
            log.info("FINISHED AT " + new Date());
        }
        catch (Exception e) {
            log.error(e, e);
        }
        MapFrame.getInstance().refreshInstance();
        MapFrame.getInstance().refreshAllObjects(false);
        MapFrame.getInstance().updateUIPanelButtonIcon();
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().syncUIWithDataInDB();
        JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("fsx_data_import_finish"), "", 1);
        MapFrame.getInstance().updateMap();
    }

    private void doImport(XplaneImportFacade importFacade, boolean withAirports) {
        if (this.sceneryPaths != null) {
            for (int i = this.sceneryPaths.size() - 1; i >= 0; --i) {
                SceneryConfigEntry sceneryPath = this.sceneryPaths.get(i);
                Timer.getInstance().start("scenery_path_import");
                if (sceneryPath.isActive()) {
                    String path = StringUtil.finishWithSlash(sceneryPath.getPath());
                    log.info("IMPORTING FROM: " + path + " " + FormatUtil.formatFileSizeToGBs(sceneryPath.getSize(), 3) + " GB / " + sceneryPath.getFileCount() + " (" + (i + 1) + "/" + this.sceneryPaths.size() + "); freemem: " + VfrUtil.getFreeHeapSpace());
                    if (new File(path).exists()) {
                        String fullPath;
                        SearchParams searchParams;
                        Set<DiskObject> files = null;
                        if (withAirports) {
                            if (this.importBean.isImportAirports()) {
                                searchParams = new SearchParams();
                                searchParams.setMaxDepth(0);
                                searchParams.setSkipDirs(true);
                                searchParams.getPatterns().add("earth_apt.dat");
                                searchParams.getPatterns().add("apt.dat");
                                files = SearchUtil.getRootList(searchParams, path);
                                if (files.size() > 0) {
                                    for (DiskObject file : files) {
                                        fullPath = path + file.getPath();
                                        log.info("Importing airports from " + fullPath);
                                        importFacade.importAirports(fullPath, this.importBean);
                                    }
                                }
                            }
                        } else {
                            if (this.importBean.isImportNavaids()) {
                                searchParams = new SearchParams();
                                searchParams.setMaxDepth(0);
                                searchParams.setSkipDirs(true);
                                searchParams.getPatterns().add("earth_nav.dat");
                                searchParams.getPatterns().add("nav.dat");
                                files = SearchUtil.getRootList(searchParams, path);
                                if (files.size() > 0) {
                                    for (DiskObject file : files) {
                                        fullPath = path + file.getPath();
                                        log.info("Importing navaids from " + fullPath);
                                        importFacade.importNavaids(fullPath, this.importBean);
                                    }
                                }
                            }
                            if (this.importBean.isImportWaypoints() || this.importBean.isImportRoutes()) {
                                searchParams = new SearchParams();
                                searchParams.setMaxDepth(0);
                                searchParams.setSkipDirs(true);
                                searchParams.getPatterns().add("earth_fix.dat");
                                searchParams.getPatterns().add("fix.dat");
                                files = SearchUtil.getRootList(searchParams, path);
                                if (files.size() > 0) {
                                    for (DiskObject file : files) {
                                        fullPath = path + file.getPath();
                                        log.info("Importing IFR points from " + fullPath);
                                        importFacade.importWaypoints(fullPath, this.importBean);
                                    }
                                }
                            }
                            if (this.importBean.isImportRoutes()) {
                                searchParams = new SearchParams();
                                searchParams.setMaxDepth(0);
                                searchParams.setSkipDirs(true);
                                searchParams.getPatterns().add("earth_awy.dat");
                                searchParams.getPatterns().add("awy.dat");
                                files = SearchUtil.getRootList(searchParams, path);
                                if (files.size() > 0) {
                                    for (DiskObject file : files) {
                                        fullPath = path + file.getPath();
                                        log.info("Importing IFR routes from " + fullPath);
                                        importFacade.importRoutes(fullPath, this.importBean);
                                    }
                                }
                            }
                        }
                    }
                }
                Timer.getInstance().stop("scenery_path_import", false);
            }
        }
    }
}

