/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.fsx;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.core.fsx.BglImportBean;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.search.SearchParams;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.RefreshMagneticDeclinationsTask;
import main.java.guru.vfrflight.sql.facade.BglImportFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.Timer;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class BglImportTask
implements Runnable {
    private List<SceneryConfigEntry> sceneryPaths = null;
    private String workingDir = "tmp";
    private BglImportBean importBean;
    private String bglFilePath;
    private static final Logger log = Logger.getLogger(BglImportTask.class);

    public BglImportTask(BglImportBean importBean, String bglFilePath) {
        this.importBean = importBean;
        this.bglFilePath = bglFilePath;
    }

    public BglImportTask(BglImportBean importBean, List<SceneryConfigEntry> sceneryPaths, String workingDir) {
        this.sceneryPaths = sceneryPaths;
        this.workingDir = workingDir;
        this.importBean = importBean;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        if (this.sceneryPaths != null) {
            PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(false);
            PleaseWaitDialog.getInstance().setProgressMaximum(this.sceneryPaths.size() + 80);
        } else {
            PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true);
        }
        log.info("STARTED AT " + new Date());
        Timer.getInstance().start("BglImportTask");
        SearchParams searchParams = new SearchParams("*.mdl");
        searchParams.setMaxDepth(0);
        searchParams.setSkipDirs(true);
        String exePath = System.getProperty("user.dir") + "/util/bglxml.exe";
        this.workingDir = StringUtil.finishWithSlash(this.workingDir);
        try {
            BglImportFacade importFacade = new BglImportFacade(DBUtil.getDataSource());
            importFacade.initBeforeImport(this.importBean);
            MapFrame.getInstance().refreshAllObjects(false);
            Files.copy(Paths.get(exePath, new String[0]), Paths.get(this.workingDir + "bglxml.exe", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            if (this.isSingleBglImport()) {
                importFacade.importFromBglFile(this.importBean, new File(this.bglFilePath), this.workingDir);
            } else {
                for (int i = 0; i < this.sceneryPaths.size(); ++i) {
                    SceneryConfigEntry sceneryPath = this.sceneryPaths.get(i);
                    Timer.getInstance().start("scenery_path_search");
                    if (sceneryPath.isActive()) {
                        String path = sceneryPath.getPath();
                        log.debug("IMPORTING FROM: " + path + " " + FormatUtil.formatFileSizeToGBs(sceneryPath.getSize(), 3) + " GB / " + sceneryPath.getFileCount() + " (" + (i + 1) + "/" + this.sceneryPaths.size() + "); freemem: " + VfrUtil.getFreeHeapSpace());
                        Timer.getInstance().start("bgl_search");
                        Set<DiskObject> results = SearchUtil.getRootList("*.bgl", path);
                        Timer.getInstance().stop("bgl_search", false);
                        Timer.getInstance().start("bgl_loop");
                        for (DiskObject d : results) {
                            importFacade.importFromBglFile(this.importBean, new File(path + d.getPath()), this.workingDir);
                        }
                        Timer.getInstance().stop("bgl_loop", false);
                        Timer.getInstance().start("mdl_loop");
                        for (DiskObject mdl : SearchUtil.getRootList(searchParams, this.workingDir)) {
                            IOUtil.deleteFile(this.workingDir + mdl.getPath());
                        }
                        Timer.getInstance().stop("mdl_loop", false);
                    }
                    Timer.getInstance().stop("scenery_path_search", false);
                    PleaseWaitDialog.getInstance().setProgress(i + 1);
                }
            }
            log.info("Scenery paths import finished at " + new Date());
            searchParams = new SearchParams();
            searchParams.setMaxDepth(0);
            searchParams.setSkipDirs(true);
            searchParams.getPatterns().add("*.mdl");
            searchParams.getPatterns().add("*.xml");
            searchParams.getPatterns().add("*.tmp");
            searchParams.getPatterns().add("*.bgl");
            searchParams.getPatterns().add("bglxml.exe");
            Set<DiskObject> files = SearchUtil.getRootList(searchParams, this.workingDir);
            for (DiskObject f : files) {
                IOUtil.deleteFile(this.workingDir + f.getPath());
            }
            Timer.getInstance().start("BglImportTask:inserts");
            if (SettingsBean.getInstance().isLogLevelTrace()) {
                log.trace("====================================================================================");
                log.trace("AIRPORTS: " + this.importBean.getAirports().size());
                log.trace("VORs: " + this.importBean.getVors().size());
                log.trace("NDBs: " + this.importBean.getNdbs().size());
                log.trace("WAYPOINTs: " + this.importBean.getWaypoints().size());
                log.trace("AIRSPACEs: " + this.importBean.getAirspaces());
                log.trace("====================================================================================");
            }
            if (this.importBean.isImportAirports()) {
                int i = importFacade.insertAirports(this.importBean, this.sceneryPaths.size(), this.sceneryPaths.size() + 20);
                log.debug("TOTAL AIRPORTS: " + i);
            }
            if (this.importBean.isImportNavaids()) {
                int i = importFacade.insertVors(this.importBean, this.sceneryPaths.size() + 20, this.sceneryPaths.size() + 30);
                log.debug("TOTAL VORs: " + i);
                i = importFacade.insertNdbs(this.importBean, this.sceneryPaths.size() + 30, this.sceneryPaths.size() + 40);
                log.debug("TOTAL NDBs: " + i);
            }
            if (this.importBean.isImportWaypoints()) {
                int i = importFacade.insertWaypoints(this.importBean, this.sceneryPaths.size() + 40, this.sceneryPaths.size() + 50);
                log.debug("TOTAL WAYPOINTS: " + i);
                if (this.importBean.isImportRoutes()) {
                    Timer.getInstance().start("BglImportTask:insertRoutes");
                    i = importFacade.insertRoutes(this.importBean, this.sceneryPaths.size() + 50, this.sceneryPaths.size() + 60);
                    log.debug("TOTAL ROUTES: " + i);
                    Timer.getInstance().stop("BglImportTask:insertRoutes", false);
                }
            }
            if (this.importBean.isImportBoundaries()) {
                int i = importFacade.insertBoundaries(this.importBean, this.sceneryPaths.size() + 60, this.sceneryPaths.size() + 80);
                log.debug("TOTAL AIRSPACESs: " + i);
            }
            PleaseWaitDialog.getInstance().setProgress(this.sceneryPaths.size() + 80);
            Timer.getInstance().stop("BglImportTask:inserts", false);
            SettingsBean.getInstance().setAirportsTableSource("FSXP3D");
            SettingsBean.getInstance().setNavaidsTableSource("FSXP3D");
            Timer.getInstance().stop("BglImportTask", false);
            log.info("FINISHED AT " + new Date());
        }
        catch (Throwable e) {
            VfrUtil.createExceptionDialog(e);
        }
        MapFrame.getInstance().refreshInstance();
        MapFrame.getInstance().refreshAllObjects(false);
        MapFrame.getInstance().updateUIPanelButtonIcon();
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().syncUIWithDataInDB();
        JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("fsx_data_import_finish"), "", 1);
        if (!SettingsBean.getInstance().isParamFsxP3dMode() && GuiUtil.showConfirmationDialog(MapFrame.getInstance(), "", Messages.getInstance().get("magvar_warning_dialog_content"))) {
            SettingsBean.getInstance().setParamFsxP3dMode(true);
            try {
                VfrUtil.executeTaskInFixedSinglePool(new RefreshMagneticDeclinationsTask(SettingsBean.getInstance().getDeclinationCalculator()));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        MapFrame.getInstance().updateMap();
    }

    private boolean isSingleBglImport() {
        return this.bglFilePath != null;
    }
}

