/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.xplane;

import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTask;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTaskSupport;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.bean.XPConnectConfigBean;
import main.java.guru.vfrflight.xpc.XPCBean;
import main.java.guru.vfrflight.xpc.XPCUtil;
import main.java.guru.vfrflight.xpc.XPlaneConnect;
import org.apache.log4j.Logger;

public class XPConnectTask
implements ExtConnectTask {
    private static final Logger log = Logger.getLogger(XPConnectTask.class);
    private boolean running = true;
    private SimConnectConfigBean configBean;
    private int failedDataCount = 0;
    private boolean receivedFirstData = true;
    private boolean forcedDisconnect = false;
    private String outputFile;
    private final XPConnectConfigBean connectConfigBean;

    public XPConnectTask(SimConnectConfigBean configBean, XPConnectConfigBean connectConfigBean) {
        this.configBean = configBean;
        this.connectConfigBean = connectConfigBean;
    }

    @Override
    public void run() {
        PleaseWaitDialog.getInstance().start();
        log.info("XPConnectTask: START");
        XPlaneConnect xpc = null;
        try {
            xpc = XPCUtil.getConnection(this.connectConfigBean.getXplaneIp(), this.connectConfigBean.getXplanePort());
        }
        catch (IOException e) {
            log.error(e, e);
        }
        PleaseWaitDialog.getInstance().stop();
        if (xpc != null) {
            SimConnectUtil.getInstance().setExtConnectBean(new XPCBean());
            if (this.configBean.isSaveUserTrack()) {
                SimConnectUtil.getInstance().clearUserTrack();
                SimConnectUtil.getInstance().setFpsEntries(new LinkedList<FpsEntry>());
            }
            SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
            if (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack()) {
                do {
                    XPCBean bean = null;
                    try {
                        bean = XPCUtil.getData(xpc);
                    }
                    catch (IOException e) {
                        log.debug(e, e);
                    }
                    if (bean != null && bean.hasData()) {
                        this.failedDataCount = 0;
                        SimConnectUtil.getInstance().setExtConnectBean(bean);
                        if (SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack() && (SimConnectUtil.getInstance().getUserTrack().size() == 0 || !SimConnectUtil.getInstance().getUserTrack().get(SimConnectUtil.getInstance().getUserTrack().size() - 1).positionEquals(bean))) {
                            SimConnectUtil.getInstance().addUserTrack(bean.clone());
                        }
                        if (SettingsBean.getInstance().isFollowUserPosition() || this.receivedFirstData && (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack())) {
                            MapFrame.getInstance().centerOnPoint(bean.getGpsPlace(), false);
                        }
                        MapFrame.getInstance().updateMap();
                        this.receivedFirstData = false;
                        continue;
                    }
                    ++this.failedDataCount;
                    if (this.failedDataCount < 100) continue;
                    log.info("DISCONNECTING [failedDataCount= " + this.failedDataCount + "]");
                    this.disconnect();
                } while (this.running);
            }
            log.info("Closing connection");
            xpc.close();
        } else {
            this.disconnect();
            this.forcedDisconnect = true;
        }
        if (this.forcedDisconnect) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("xplane_disconnect_error"), "", 0);
        }
        log.info("XPConnectTask: FINISHED");
    }

    private void disconnect() {
        log.error("Couldn't connect to Xplane");
        MapFrame.getInstance().getUIPanel().doDisconnectAction();
        this.running = false;
        this.forcedDisconnect = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectConfigBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(SimConnectConfigBean configBean) {
        this.configBean = configBean;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public ExtConnectTaskSupport getSupport() {
        return new ExtConnectTaskSupport(){

            @Override
            public boolean isSupportForMoveHere() {
                return false;
            }

            @Override
            public boolean isSupportForVector() {
                return true;
            }

            @Override
            public boolean isSupportForFollowPosition() {
                return true;
            }

            @Override
            public boolean isSupportForSetAltitude() {
                return false;
            }

            @Override
            public boolean isSupportForUpdateWind() {
                return false;
            }

            @Override
            public boolean isSupportForUpdateTas() {
                return false;
            }

            @Override
            public boolean isSupportForOptimizeForPerformance() {
                return true;
            }
        };
    }
}

