/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.SimConnect;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTask;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTaskSupport;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectFailureTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectGetFpsTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectGetTrafficDataTask;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.apache.log4j.Logger;

public class SimConnectTask
implements ExtConnectTask {
    private static final Logger log = Logger.getLogger(SimConnectTask.class);
    private boolean running = true;
    private SimConnectConfigBean configBean;
    private FsxP3DConnectConfigBean connectConfigBean;
    private int failedDataCount = 0;
    private boolean receivedFirstData = true;
    private boolean forcedDisconnect = false;

    public SimConnectTask(SimConnectConfigBean configBean, FsxP3DConnectConfigBean connectConfigBean) {
        this.configBean = configBean;
        this.connectConfigBean = connectConfigBean;
    }

    @Override
    public void run() {
        PleaseWaitDialog.getInstance().start();
        log.debug("SimConnectTask: START");
        SimConnect sc = SimConnectUtil.initConnection(this.connectConfigBean);
        PleaseWaitDialog.getInstance().stop();
        if (sc != null && !sc.isClosed()) {
            SimConnectUtil.getInstance().setExtConnectBean(new SimConnectBean());
            if (this.configBean.isSaveUserTrack()) {
                SimConnectUtil.getInstance().clearUserTrack();
                SimConnectUtil.getInstance().setFpsEntries(new LinkedList<FpsEntry>());
                if (this.configBean.isGetFps()) {
                    new Thread(new SimConnectGetFpsTask()).start();
                }
            }
            SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
            if (this.configBean.isEngineFailure()) {
                new Thread(new SimConnectFailureTask(this.configBean)).start();
            }
            if (this.configBean.isTraceTraffic()) {
                new Thread(new SimConnectGetTrafficDataTask(this.configBean, this.connectConfigBean)).start();
            }
            if (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack()) {
                int interval = 0;
                long milis = 0L;
                do {
                    try {
                        long diff;
                        SimConnectBean bean;
                        if (this.configBean.getInterval() > 0) {
                            interval = this.configBean.getInterval();
                            milis = System.currentTimeMillis();
                        }
                        if ((bean = SimConnectUtil.getUserData(sc)) != null) {
                            Float tas;
                            this.failedDataCount = 0;
                            SimConnectUtil.getInstance().setExtConnectBean(bean);
                            if (SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack() && (SimConnectUtil.getInstance().getUserTrack().size() == 0 || !SimConnectUtil.getInstance().getUserTrack().get(SimConnectUtil.getInstance().getUserTrack().size() - 1).positionEquals(bean))) {
                                SimConnectUtil.getInstance().addUserTrack(bean.clone());
                            }
                            if (SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim()) {
                                double windDir = Math.round(bean.getWindDirection().floatValue());
                                double windSpeed = bean.getWindVelocity().floatValue();
                                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                                    windSpeed = UnitUtil.recalculateWindSpeed(windSpeed, "kt", SettingsBean.getInstance().getParamUnitsWindSpeed(), false);
                                }
                                if (!NumberUtil.doubleEqualsDouble(windSpeed = NumberUtil.roundDouble(windSpeed, 1), FlightPlanBean.getInstance().getRoute().getWindSpeed(), 1) || !NumberUtil.doubleEqualsDouble(windDir, FlightPlanBean.getInstance().getRoute().getWindDirection(), 0)) {
                                    FlightPlanBean.getInstance().getRoute().setWindSpeed(windSpeed);
                                    FlightPlanBean.getInstance().getRoute().setWindDirection(windDir);
                                    MapFrame.getInstance().getUIPanel().updateWindData();
                                }
                            }
                            if (SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim() && (tas = bean.getUserTas()) != null) {
                                String txt;
                                double dTas = tas.doubleValue();
                                if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                                    dTas = UnitUtil.recalculateWindSpeed(dTas, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
                                }
                                if (!(txt = String.valueOf(Math.round(dTas))).equals(MapFrame.getInstance().getUIPanel().getPerformanceCollapsablePanel().getCruiseSpeedTextField().getText())) {
                                    MapFrame.getInstance().getUIPanel().getPerformanceCollapsablePanel().getCruiseSpeedTextField().setText(txt);
                                    MapFrame.getInstance().getUIPanel().cruiseSpeedChanged();
                                }
                            }
                            if (SettingsBean.getInstance().isFollowUserPosition() || this.receivedFirstData && (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack())) {
                                MapFrame.getInstance().centerOnPoint(bean.getUserLat().floatValue(), bean.getUserLon().floatValue(), false);
                            }
                            MapFrame.getInstance().updateMap();
                            this.receivedFirstData = false;
                            if (this.configBean.isIntervalBoostAtLowAlt() && (double)bean.getUserAltAboveTerrain().floatValue() < 500.0) {
                                interval = (int)Math.round((double)interval / 5.0);
                            }
                        } else {
                            ++this.failedDataCount;
                            if (this.failedDataCount >= 3) {
                                log.info("DISCONNECTING [failedDataCount= " + this.failedDataCount + "]");
                                this.disconnect("Connection was lost");
                            }
                            if ((sc = SimConnectUtil.initConnection()) == null) {
                                this.disconnect("Couldn't reconnect after connection lost");
                            }
                        }
                        if (this.configBean.getInterval() <= 0 || (diff = System.currentTimeMillis() - milis) >= (long)interval) continue;
                        Thread.sleep((long)interval - diff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.running && sc != null && !sc.isClosed());
            }
            SimConnectUtil.closeQuietly(sc);
            if (this.configBean.isSaveUserTrack() && this.configBean.isGetFps()) {
                log.debug("STARTING merging FPS data into user track. (" + SimConnectUtil.getInstance().getUserTrack().size() + " / " + SimConnectUtil.getInstance().getFpsEntries().size() + ")");
                SimConnectUtil.getInstance().mergeUserTrackWithFpsEntries();
                log.debug("FINISHED merging FPS data into user track");
            }
        } else {
            this.disconnect("Couldn't initialize SimConnect connetion");
        }
        if (this.forcedDisconnect) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("sim_disconnect_error"), "", 0);
        }
        log.debug("SimConnectTask: FINISHED");
    }

    private void disconnect(String reason) {
        log.error("Couldn't connect to FSX/P3D. Reason: " + reason);
        MapFrame.getInstance().getUIPanel().doDisconnectAction();
        this.running = false;
        this.forcedDisconnect = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectConfigBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(SimConnectConfigBean configBean) {
        this.configBean = configBean;
    }

    @Override
    public ExtConnectTaskSupport getSupport() {
        return new ExtConnectTaskSupport(){

            @Override
            public boolean isSupportForMoveHere() {
                return true;
            }

            @Override
            public boolean isSupportForVector() {
                return true;
            }

            @Override
            public boolean isSupportForFollowPosition() {
                return true;
            }

            @Override
            public boolean isSupportForSetAltitude() {
                return true;
            }

            @Override
            public boolean isSupportForUpdateWind() {
                return true;
            }

            @Override
            public boolean isSupportForUpdateTas() {
                return true;
            }

            @Override
            public boolean isSupportForOptimizeForPerformance() {
                return true;
            }
        };
    }
}

