/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.NotificationPriority;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.recv.AbstractDispatcher;
import flightsim.simconnect.recv.RecvPacket;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SimConnectSendEventTask
implements Runnable {
    private static final Logger log = Logger.getLogger(SimConnectSendEventTask.class);
    private boolean running = true;
    private SimConnect sc;
    private String eventId;
    private boolean success = false;

    public SimConnectSendEventTask(SimConnect sc, String eventId) {
        this.sc = sc;
        this.eventId = eventId;
    }

    @Override
    public void run() {
        int loops = 0;
        this.running = this.init(this.sc);
        while (this.running && this.sc != null && !this.sc.isClosed() && loops++ < 10) {
            try {
                this.sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                    public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                        SimConnectSendEventTask.this.success = true;
                        SimConnectSendEventTask.this.running = false;
                    }
                });
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                this.running = false;
            }
        }
    }

    private boolean init(SimConnect sc) {
        try {
            sc.mapClientEventToSimEvent(1, this.eventId);
            sc.transmitClientEvent(0, 1, 0, NotificationPriority.HIGHEST.ordinal(), 16);
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

