/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimConnectPeriod;
import flightsim.simconnect.recv.AbstractDispatcher;
import flightsim.simconnect.recv.RecvException;
import flightsim.simconnect.recv.RecvPacket;
import flightsim.simconnect.recv.RecvSimObjectData;
import java.io.IOException;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class SimConnectGetUserDataTask
implements Runnable {
    private static final Logger log = Logger.getLogger(SimConnectGetUserDataTask.class);
    private boolean running = true;
    private SimConnect sc;
    private SimConnectBean bean;

    public SimConnectGetUserDataTask(SimConnect sc) {
        this.sc = sc;
    }

    @Override
    public void run() {
        int loops = 0;
        this.running = this.initGetUserData(this.sc);
        while (this.running && this.sc != null && !this.sc.isClosed() && loops++ < 10) {
            try {
                this.sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                    public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                        SimConnectGetUserDataTask.this.onDispatchGetUserDataAction(recv);
                    }
                });
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                this.running = false;
            }
        }
    }

    private void onDispatchGetUserDataAction(RecvPacket recv) {
        if (recv instanceof RecvException) {
            RecvException exc = (RecvException)recv;
            log.warn("Error : " + exc.getException());
        } else if (recv instanceof RecvSimObjectData) {
            RecvSimObjectData data = (RecvSimObjectData)recv;
            this.bean = new SimConnectBean(System.currentTimeMillis());
            this.bean.setUserLat(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserLon(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserAlt(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserIndicatedAlt(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserGs(Float.valueOf((float)UnitUtil.recalculateSpeed(data.getDataFloat32(), "mps", "kt", true)));
            this.bean.setUserTrueHeading(Float.valueOf((float)Math.toDegrees(data.getDataFloat32())));
            this.bean.setUserMagHeading(Float.valueOf((float)Math.toDegrees(data.getDataFloat32())));
            this.bean.setUserAltAboveTerrain(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserVerticalSpeed(Float.valueOf(data.getDataFloat32() * 60.0f));
            this.bean.setUserIndicatedSpeed(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserTas(Float.valueOf(data.getDataFloat32()));
            this.bean.setUserBank(Float.valueOf((float)Math.toDegrees(data.getDataFloat32())));
            this.bean.setUserPitch(Float.valueOf((float)Math.toDegrees(data.getDataFloat32())));
            this.bean.setgForce(Float.valueOf(data.getDataFloat32()));
            this.bean.setWindVelocity(Float.valueOf(data.getDataFloat32()));
            this.bean.setWindDirection(Float.valueOf(data.getDataFloat32()));
            this.bean.setFlapsHandle((short)Math.round(data.getDataFloat32()));
            this.bean.setYokeYPosition(Float.valueOf(data.getDataFloat32()));
            this.bean.setYokeXPosition(Float.valueOf(data.getDataFloat32()));
            this.bean.setRudderPeddalsPosition(Float.valueOf(data.getDataFloat32()));
            this.bean.setOnGround(!NumberUtil.floatEqualsZero(data.getDataFloat32()));
            this.running = false;
        }
    }

    private boolean initGetUserData(SimConnect sc) {
        try {
            sc.addToDataDefinition(1, "PLANE LATITUDE", "Degrees", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE LONGITUDE", "Degrees", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE ALTITUDE", "Feet", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "INDICATED ALTITUDE", "Feet", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "GPS GROUND SPEED", "Meters per second", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE HEADING DEGREES TRUE", "Radians", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE HEADING DEGREES MAGNETIC", "Radians", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE ALT ABOVE GROUND", "Feet", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "VERTICAL SPEED", "Feet per second", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "AIRSPEED INDICATED", "Knots", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "AIRSPEED TRUE", "Knots", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE BANK DEGREES", "Radians", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "PLANE PITCH DEGREES", "Radians", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "G FORCE", "GForce", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "AMBIENT WIND VELOCITY", "Knots", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "AMBIENT WIND DIRECTION", "Degrees", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "FLAPS HANDLE PERCENT", "Percent", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "YOKE Y INDICATOR", "Position", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "YOKE X INDICATOR", "Position", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "RUDDER PEDAL INDICATOR", "Position", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(1, "SIM ON GROUND", "Bool", SimConnectDataType.FLOAT32);
            sc.requestDataOnSimObject(1, 1, 0, SimConnectPeriod.ONCE);
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectBean getBean() {
        return this.bean;
    }

    public void setBean(SimConnectBean bean) {
        this.bean = bean;
    }
}

