/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimObjectType;
import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.recv.DispatcherTask;
import flightsim.simconnect.recv.EventHandler;
import flightsim.simconnect.recv.RecvEvent;
import flightsim.simconnect.recv.RecvSimObjectDataByType;
import flightsim.simconnect.recv.SimObjectDataTypeHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.bean.SimConnectTraffic;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.apache.log4j.Logger;

public class SimConnectGetTrafficDataTask
implements Runnable,
EventHandler,
SimObjectDataTypeHandler {
    private static final Logger log = Logger.getLogger(SimConnectGetTrafficDataTask.class);
    private final int MAX_RADIUS = 2000000;
    private final int dataDefID = 10;
    private final int requestID = 11;
    private final int fourSeceventID = 12;
    private boolean running = true;
    private SimConnect sc;
    private SimConnectConfigBean configBean;
    private Thread dispatcherThread;
    private List<SimConnectTraffic> trafficList;

    public SimConnectGetTrafficDataTask(SimConnectConfigBean configBean, FsxP3DConnectConfigBean connectConfigBean) {
        this.configBean = configBean;
        this.sc = SimConnectUtil.initConnection(connectConfigBean);
    }

    public void handleEvent(SimConnect sender, RecvEvent e) {
        if (e.getEventID() == 12) {
            try {
                sender.requestDataOnSimObjectType(11, 10, this.configBean.getTrafficRadius() == null ? 2000000 : this.configBean.getTrafficRadius(), SimObjectType.AIRCRAFT);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleSimObjectType(SimConnect sender, RecvSimObjectDataByType e) {
        double radius;
        LatLonAlt position = e.getLatLonAlt();
        String name = (StringUtil.nullToEmpty(e.getDataString32()) + " " + StringUtil.nullToEmpty(e.getDataString32())).trim();
        String secondName = (StringUtil.nullToEmpty(e.getDataString32()) + " " + StringUtil.nullToEmpty(e.getDataString32())).trim();
        String fromAirport = e.getDataString32();
        String toAirport = e.getDataString32();
        String route = null;
        if (!StringUtil.isEmpty(fromAirport)) {
            route = fromAirport;
        }
        if (!StringUtil.isEmpty(toAirport)) {
            route = route + "-" + toAirport;
        }
        double gs = e.getDataFloat32();
        double trueHeading = Math.toDegrees(e.getDataFloat32());
        boolean onGround = !NumberUtil.floatEqualsZero(e.getDataFloat32());
        double vs = e.getDataFloat32();
        double d = radius = this.configBean.getTrafficRadius() == null ? 2000000.0 : (double)this.configBean.getTrafficRadius().intValue();
        if (e.getEntryNumber() == 1) {
            this.trafficList = new ArrayList<SimConnectTraffic>(e.getOutOf() - 1);
        } else {
            double distInMeters;
            SimConnectBean bean = null;
            bean = !this.configBean.isTraceUserPosition() && !this.configBean.isSaveUserTrack() ? SimConnectUtil.getUserData(this.sc) : (SimConnectBean)SimConnectUtil.getInstance().getExtConnectBean();
            if ((!this.configBean.isTrafficShowOnlyInAir() || !onGround || bean.isOnGround()) && (distInMeters = UnitUtil.recalculateDistance(GpsUtil.getDistance(bean.getGpsPlace(), new GpsPlace(position.latitude, position.longitude)), "nm", "m", false)) <= radius) {
                SimConnectTraffic traffic = new SimConnectTraffic(name, secondName, route, position.latitude, position.longitude, UnitUtil.recalculateAltitude(position.altitude, "m", "ft", false), gs, trueHeading, vs, onGround);
                if (!onGround && !bean.isOnGround()) {
                    traffic.setAltDiffFt(Math.abs((double)bean.getUserAlt().floatValue() - traffic.getAlt()));
                } else {
                    traffic.setAltDiffFt(0.0);
                }
                if (!this.configBean.isTrafficShowOnlyIn2kAltitudeRange() || traffic.getAltDiffFt() <= 2000.0) {
                    double distIn10Sec = traffic.getGs() / 3600.0 * 30.0;
                    GpsPlace nextPos = GpsUtil.getPointPositionByDistanceAndBearing(traffic.getPos().gpsPlace(), traffic.getTrueHeading(), distIn10Sec);
                    traffic.setNextPositionIn10Sec(nextPos.geoPosition());
                    this.trafficList.add(traffic);
                }
            }
            if (e.getEntryNumber() == e.getOutOf()) {
                SimConnectUtil.getInstance().setTraffic(new ArrayList<SimConnectTraffic>(this.trafficList));
                if (!this.configBean.isTraceUserPosition() && !this.configBean.isSaveUserTrack()) {
                    MapFrame.getInstance().updateMap();
                }
            }
        }
    }

    @Override
    public void run() {
        log.info("SimConnectGetTrafficDataTask: START");
        this.running = this.initGetTrafficData(this.sc);
        DispatcherTask dt = new DispatcherTask(this.sc);
        dt.addEventHandler((EventHandler)this);
        dt.addSimObjectDataTypeHandler((SimObjectDataTypeHandler)this);
        this.dispatcherThread = new Thread((Runnable)dt);
        this.dispatcherThread.start();
        if (this.sc != null && !this.sc.isClosed() && this.configBean.isTraceTraffic()) {
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.running && this.sc != null && !this.sc.isClosed() && SettingsBean.getInstance().isConnectedToSim());
            SimConnectUtil.closeQuietly(this.sc);
        }
        dt.tryStop();
        this.dispatcherThread = null;
        SimConnectUtil.getInstance().getTraffic().clear();
        MapFrame.getInstance().updateMap();
        log.info("SimConnectGetTrafficDataTask: FINISHED");
    }

    private boolean initGetTrafficData(SimConnect sc) {
        try {
            sc.addToDataDefinition(10, "STRUCT LATLONALT", null, SimConnectDataType.LATLONALT);
            sc.addToDataDefinition(10, "ATC TYPE", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "ATC MODEL", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "ATC AIRLINE", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "ATC FLIGHT NUMBER", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "AI TRAFFIC FROMAIRPORT", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "AI TRAFFIC TOAIRPORT", null, SimConnectDataType.STRING32);
            sc.addToDataDefinition(10, "GROUND VELOCITY", "Knots", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(10, "PLANE HEADING DEGREES TRUE", "Radians", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(10, "SIM ON GROUND", "Bool", SimConnectDataType.FLOAT32);
            sc.addToDataDefinition(10, "VERTICAL SPEED", "Feet per second", SimConnectDataType.FLOAT32);
            sc.subscribeToSystemEvent(12, "1sec");
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

