/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.SimConnect;
import flightsim.simconnect.recv.DispatcherTask;
import flightsim.simconnect.recv.EventFrameHandler;
import flightsim.simconnect.recv.RecvEventFrame;
import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.util.SimConnectUtil;
import org.apache.log4j.Logger;

public class SimConnectGetFpsTask
implements Runnable,
EventFrameHandler {
    private static final Logger log = Logger.getLogger(SimConnectGetFpsTask.class);
    private boolean running = true;
    private boolean init = false;
    private SimConnect sc = SimConnectUtil.initConnection();
    private SimConnectBean bean;
    private DispatcherTask dt;

    @Override
    public void run() {
        log.debug("SimConnectGetFpsTask: START");
        this.running = this.initGetFpsData(this.sc);
        while (this.running && this.sc != null && !this.sc.isClosed() && SettingsBean.getInstance().isConnectedToSim()) {
            LockSupport.parkNanos(705032704L);
        }
        this.dt.tryStop();
        SimConnectUtil.closeQuietly(this.sc);
        if (this.sc != null) {
            try {
                this.sc.unsubscribeFromSystemEvent((Enum)ID.EVENT_FPS_RECORD);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.debug("SimConnectGetFpsTask: FINISHED");
    }

    private boolean initGetFpsData(SimConnect sc) {
        try {
            this.dt = new DispatcherTask(sc);
            sc.subscribeToSystemEvent((Enum)ID.EVENT_FPS_RECORD, "frame");
            this.dt.addEventFrameHandler((EventFrameHandler)this);
            this.dt.createThread().start();
            this.init = true;
        }
        catch (IOException e) {
            log.error(e, e);
            this.init = false;
        }
        return this.init;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectBean getBean() {
        return this.bean;
    }

    public void setBean(SimConnectBean bean) {
        this.bean = bean;
    }

    public void handleEventFrame(SimConnect sender, RecvEventFrame event) {
        FpsEntry entry = new FpsEntry(System.currentTimeMillis(), Float.valueOf(event.getFrameRate()));
        SimConnectUtil.getInstance().getFpsEntries().add(entry);
    }

    public static enum ID {
        EVENT_FPS_RECORD;

    }
}

