/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimConnectPeriod;
import flightsim.simconnect.recv.AbstractDispatcher;
import flightsim.simconnect.recv.RecvException;
import flightsim.simconnect.recv.RecvPacket;
import flightsim.simconnect.recv.RecvSimObjectData;
import java.io.IOException;
import main.java.guru.vfrflight.bean.SimConnectBean;
import org.apache.log4j.Logger;

public class SimConnectGetFloatValueTask
implements Runnable {
    private static final Logger log = Logger.getLogger(SimConnectGetFloatValueTask.class);
    private boolean running = true;
    private SimConnect sc;
    private SimConnectBean bean;
    private String variableName;
    private String variableUnit;
    private Float result = null;

    public SimConnectGetFloatValueTask(SimConnect sc, String variableName, String variableUnit) {
        this.sc = sc;
        this.variableName = variableName;
        this.variableUnit = variableUnit;
    }

    @Override
    public void run() {
        int loops = 0;
        this.running = this.init(this.sc);
        while (this.running && this.sc != null && !this.sc.isClosed() && loops++ < 10) {
            try {
                this.sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                    public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                        SimConnectGetFloatValueTask.this.onDispatchGetUserDataAction(recv);
                    }
                });
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                this.running = false;
            }
        }
    }

    private void onDispatchGetUserDataAction(RecvPacket recv) {
        if (recv instanceof RecvException) {
            RecvException exc = (RecvException)recv;
            log.error("Error : " + exc.getException());
        } else if (recv instanceof RecvSimObjectData) {
            RecvSimObjectData data = (RecvSimObjectData)recv;
            this.result = Float.valueOf(data.getDataFloat32());
            this.running = false;
        }
    }

    private boolean init(SimConnect sc) {
        try {
            sc.addToDataDefinition(1, this.variableName, this.variableUnit, SimConnectDataType.FLOAT32);
            sc.requestDataOnSimObject(1, 1, 0, SimConnectPeriod.ONCE);
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectBean getBean() {
        return this.bean;
    }

    public void setBean(SimConnectBean bean) {
        this.bean = bean;
    }

    public Float getResult() {
        return this.result;
    }

    public void setResult(Float result) {
        this.result = result;
    }
}

