/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.simconnect;

import flightsim.simconnect.SimConnect;
import java.util.Random;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.util.SimConnectUtil;
import org.apache.log4j.Logger;

public class SimConnectFailureTask
implements Runnable {
    private static final Logger log = Logger.getLogger(SimConnectFailureTask.class);
    private boolean running = true;
    private Random randomGenerator;
    private SimConnectConfigBean configBean;
    private int probability = 0;
    private SimConnect sc;

    public SimConnectFailureTask(SimConnectConfigBean configBean) {
        this.configBean = configBean;
        this.sc = SimConnectUtil.initConnection();
        this.randomGenerator = new Random();
        this.probability = Constants.ENGINE_FAILURES_PROBABILITIES[configBean.getProbability()];
    }

    @Override
    public void run() {
        log.debug("SimConnectFailureTask: STARTED");
        if (this.sc != null && !this.sc.isClosed() && this.configBean.isEngineFailure()) {
            do {
                try {
                    int ran;
                    Thread.sleep(6000L);
                    SimConnectBean bean = null;
                    bean = !this.configBean.isTraceUserPosition() && !this.configBean.isSaveUserTrack() ? SimConnectUtil.getUserData(this.sc) : (SimConnectBean)SimConnectUtil.getInstance().getExtConnectBean();
                    if (bean == null || !(bean.getUserGs().floatValue() >= 20.0f) || (ran = this.randomGenerator.nextInt(bean.getUserAltAboveTerrain().floatValue() <= 500.0f ? this.probability / 5 : this.probability)) != 0) continue;
                    if (this.configBean.isThrottleCutOff() && !SimConnectUtil.sendEvent(this.sc, "THROTTLE_CUT")) {
                        log.debug("Couldn't connect to FSX/P3D. Finishing.");
                        this.running = false;
                    }
                    if (!this.configBean.isMixtureLean() || SimConnectUtil.sendEvent(this.sc, "MIXTURE_LEAN")) continue;
                    log.debug("Couldn't connect to FSX/P3D. Finishing.");
                    this.running = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.running && this.sc != null && !this.sc.isClosed() && SettingsBean.getInstance().isConnectedToSim());
            SimConnectUtil.closeQuietly(this.sc);
        }
        log.debug("SimConnectFailureTask: FINISHED");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectConfigBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(SimConnectConfigBean configBean) {
        this.configBean = configBean;
    }
}

