/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.nmea;

import java.util.LinkedList;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTask;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTaskSupport;
import main.java.guru.vfrflight.nmea.NmeaReader;
import main.java.guru.vfrflight.nmea.message.GpMessage;
import main.java.guru.vfrflight.nmea.util.NmeaReaderFactory;
import main.java.guru.vfrflight.util.SimConnectUtil;
import org.apache.log4j.Logger;

public class GpsConnectTask
implements ExtConnectTask {
    private static final Logger log = Logger.getLogger(GpsConnectTask.class);
    private boolean running = true;
    private SimConnectConfigBean configBean;
    private int failedDataCount = 0;
    private boolean receivedFirstData = true;
    private boolean forcedDisconnect = false;
    private String outputFile;

    public GpsConnectTask(SimConnectConfigBean configBean) {
        this.configBean = configBean;
    }

    @Override
    public void run() {
        PleaseWaitDialog.getInstance().start();
        log.info("GpsConnectTask: START");
        NmeaReader reader = null;
        if (this.configBean.isNmeaLogInsteadOfGps()) {
            log.info("Reading NMEA log file " + this.configBean.getNmeaLogFile());
            reader = NmeaReaderFactory.initNmeaLogConnection(this.configBean.getNmeaLogFile());
        } else {
            log.info("Connecting to real GPS device");
            reader = NmeaReaderFactory.initGpsConnection(15000L, this.outputFile);
        }
        PleaseWaitDialog.getInstance().stop();
        if (reader != null && reader.isRunning()) {
            SimConnectUtil.getInstance().setExtConnectBean(new GpMessage());
            if (this.configBean.isSaveUserTrack()) {
                SimConnectUtil.getInstance().clearUserTrack();
                SimConnectUtil.getInstance().setFpsEntries(new LinkedList<FpsEntry>());
            }
            SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
            if (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack()) {
                int interval = 0;
                long milis = 0L;
                do {
                    try {
                        long diff;
                        GpMessage bean;
                        if (this.configBean.getInterval() > 0) {
                            interval = this.configBean.getInterval();
                            milis = System.currentTimeMillis();
                        }
                        if ((bean = reader.getData()) != null && bean.hasData() && bean.isValid() && (bean.getLastMessageTimestamp() == null || System.currentTimeMillis() - bean.getLastMessageTimestamp() <= 5000L)) {
                            this.failedDataCount = 0;
                            SimConnectUtil.getInstance().setExtConnectBean(bean);
                            if (SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack() && (SimConnectUtil.getInstance().getUserTrack().size() == 0 || !SimConnectUtil.getInstance().getUserTrack().get(SimConnectUtil.getInstance().getUserTrack().size() - 1).positionEquals(bean))) {
                                SimConnectUtil.getInstance().addUserTrack(bean.clone());
                            }
                            if (SettingsBean.getInstance().isFollowUserPosition() || this.receivedFirstData && (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack())) {
                                MapFrame.getInstance().centerOnPoint(bean.getGpsPlace(), false);
                            }
                            MapFrame.getInstance().updateMap();
                            this.receivedFirstData = false;
                        } else {
                            ++this.failedDataCount;
                            if (this.failedDataCount >= 10) {
                                log.info("DISCONNECTING [failedDataCount= " + this.failedDataCount + "]");
                                if (reader != null) {
                                    reader.setRunning(false);
                                }
                                this.disconnect();
                            }
                        }
                        if (this.configBean.getInterval() <= 0 || (diff = System.currentTimeMillis() - milis) >= (long)interval) continue;
                        Thread.sleep((long)interval - diff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.running && reader != null && reader.isRunning() && reader.isConnected());
            }
            if (reader != null) {
                reader.setRunning(false);
            }
        } else {
            this.disconnect();
            this.forcedDisconnect = true;
        }
        if (this.forcedDisconnect) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("gps_disconnect_error", this.configBean.isNmeaLogInsteadOfGps() ? "nmea_log" : "gps"), "", 0);
        }
        log.info("SimConnectTask: FINISHED");
    }

    private void disconnect() {
        log.error("Couldn't connect to FSX/P3D. Using LOG file? " + this.configBean.isNmeaLogInsteadOfGps());
        MapFrame.getInstance().getUIPanel().doDisconnectAction();
        this.running = false;
        this.forcedDisconnect = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    public SimConnectConfigBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(SimConnectConfigBean configBean) {
        this.configBean = configBean;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public ExtConnectTaskSupport getSupport() {
        return new ExtConnectTaskSupport(){

            @Override
            public boolean isSupportForMoveHere() {
                return false;
            }

            @Override
            public boolean isSupportForVector() {
                return true;
            }

            @Override
            public boolean isSupportForFollowPosition() {
                return true;
            }

            @Override
            public boolean isSupportForSetAltitude() {
                return false;
            }

            @Override
            public boolean isSupportForUpdateWind() {
                return false;
            }

            @Override
            public boolean isSupportForUpdateTas() {
                return false;
            }

            @Override
            public boolean isSupportForOptimizeForPerformance() {
                return true;
            }
        };
    }
}

