/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.flightgear;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTask;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTaskSupport;
import main.java.guru.vfrflight.gui.task.extconnect.flightgear.FlightgearConnectBean;
import main.java.guru.vfrflight.gui.task.extconnect.flightgear.FlightgearConnectUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.FlightGearConnectConfigBean;
import org.apache.log4j.Logger;

public class FlightgearConnectTask
implements ExtConnectTask {
    private static final Logger log = Logger.getLogger(FlightgearConnectTask.class);
    private static final int PACKETSIZE = 1024;
    private boolean running;
    private boolean receivedFirstData = true;
    private final SimConnectConfigBean configBean;
    private final FlightGearConnectConfigBean fgConfigBean;

    public FlightgearConnectTask(SimConnectConfigBean configBean, FlightGearConnectConfigBean fgConfigBean) {
        this.configBean = configBean;
        this.fgConfigBean = fgConfigBean;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("FlightgearConnectTask: START");
        this.running = true;
        if (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack()) {
            try (DatagramSocket socket = null;){
                socket = new DatagramSocket(this.fgConfigBean.getPort());
                socket.setSoTimeout(15000);
                DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
                do {
                    Float tas;
                    socket.receive(packet);
                    FlightgearConnectBean bean = FlightgearConnectUtil.parseBean(new String(packet.getData()));
                    if (bean == null) continue;
                    SimConnectUtil.getInstance().setExtConnectBean(bean);
                    if (SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack() && (SimConnectUtil.getInstance().getUserTrack().size() == 0 || !SimConnectUtil.getInstance().getUserTrack().get(SimConnectUtil.getInstance().getUserTrack().size() - 1).positionEquals(bean))) {
                        SimConnectUtil.getInstance().addUserTrack(bean.clone());
                    }
                    if (SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim()) {
                        double windDir = Math.round(bean.getWindDirection().floatValue());
                        double windSpeed = bean.getWindVelocity().floatValue();
                        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
                            windSpeed = UnitUtil.recalculateWindSpeed(windSpeed, "kt", SettingsBean.getInstance().getParamUnitsWindSpeed(), false);
                        }
                        if (!NumberUtil.doubleEqualsDouble(windSpeed = NumberUtil.roundDouble(windSpeed, 1), FlightPlanBean.getInstance().getRoute().getWindSpeed(), 1) || !NumberUtil.doubleEqualsDouble(windDir, FlightPlanBean.getInstance().getRoute().getWindDirection(), 0)) {
                            FlightPlanBean.getInstance().getRoute().setWindSpeed(windSpeed);
                            FlightPlanBean.getInstance().getRoute().setWindDirection(windDir);
                            MapFrame.getInstance().getUIPanel().updateWindData();
                        }
                    }
                    if (SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim() && (tas = bean.getUserTas()) != null) {
                        String txt;
                        double dTas = tas.doubleValue();
                        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                            dTas = UnitUtil.recalculateWindSpeed(dTas, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
                        }
                        if (!(txt = String.valueOf(Math.round(dTas))).equals(MapFrame.getInstance().getUIPanel().getPerformanceCollapsablePanel().getCruiseSpeedTextField().getText())) {
                            MapFrame.getInstance().getUIPanel().getPerformanceCollapsablePanel().getCruiseSpeedTextField().setText(txt);
                            MapFrame.getInstance().getUIPanel().cruiseSpeedChanged();
                        }
                    }
                    if (SettingsBean.getInstance().isFollowUserPosition() || this.receivedFirstData && (this.configBean.isTraceUserPosition() || this.configBean.isSaveUserTrack())) {
                        MapFrame.getInstance().centerOnPoint(bean.getUserLat().floatValue(), bean.getUserLon().floatValue(), false);
                    }
                    MapFrame.getInstance().updateMap();
                    this.receivedFirstData = false;
                } while (this.running);
                this.disconnect("Task stopped.", false);
            }
        }
        log.info("FlightgearConnectTask: FINISHED");
    }

    private void disconnect(String reason, boolean error) {
        log.error("Finishing flightgear listener. Reason: " + reason);
        MapFrame.getInstance().getUIPanel().doDisconnectAction();
        if (error) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("sim_disconnect_error"), "", 0);
        }
    }

    @Override
    public ExtConnectTaskSupport getSupport() {
        return new ExtConnectTaskSupport(){

            @Override
            public boolean isSupportForMoveHere() {
                return false;
            }

            @Override
            public boolean isSupportForVector() {
                return true;
            }

            @Override
            public boolean isSupportForFollowPosition() {
                return true;
            }

            @Override
            public boolean isSupportForSetAltitude() {
                return false;
            }

            @Override
            public boolean isSupportForUpdateWind() {
                return true;
            }

            @Override
            public boolean isSupportForUpdateTas() {
                return true;
            }

            @Override
            public boolean isSupportForOptimizeForPerformance() {
                return false;
            }
        };
    }
}

