/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task.extconnect.flightgear;

import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.NumberUtil;

public class FlightgearConnectBean
implements ExtConnectBean {
    private Float userLat;
    private Float userLon;
    private Float userAlt;
    private Float userIndicatedAlt;
    private Float userAltAboveTerrain;
    private Float userGs;
    private Float userIndicatedSpeed;
    private Float userVerticalSpeed;
    private Float userTas;
    private Float userTrueHeading;
    private Float userMagHeading;
    private Float userPitch;
    private Float userBank;
    private Float gForce;
    private Float windVelocity;
    private Float windDirection;
    private Short flapsHandle;
    private Float yokeXPosition;
    private Float yokeYPosition;
    private Float rudderPedalsPosition;
    private boolean onGround;
    private Long timestamp;
    private Float groundLevel;
    private Float fps;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FlightgearConnectBean [userLat=");
        builder.append(this.userLat);
        builder.append(", userLon=");
        builder.append(this.userLon);
        builder.append(", userAlt=");
        builder.append(this.userAlt);
        builder.append(", userIndicatedAlt=");
        builder.append(this.userIndicatedAlt);
        builder.append(", userAltAboveTerrain=");
        builder.append(this.userAltAboveTerrain);
        builder.append(", userGs=");
        builder.append(this.userGs);
        builder.append(", userIndicatedSpeed=");
        builder.append(this.userIndicatedSpeed);
        builder.append(", userVerticalSpeed=");
        builder.append(this.userVerticalSpeed);
        builder.append(", userTas=");
        builder.append(this.userTas);
        builder.append(", userTrueHeading=");
        builder.append(this.userTrueHeading);
        builder.append(", userMagHeading=");
        builder.append(this.userMagHeading);
        builder.append(", userPitch=");
        builder.append(this.userPitch);
        builder.append(", userBank=");
        builder.append(this.userBank);
        builder.append(", gForce=");
        builder.append(this.gForce);
        builder.append(", windVelocity=");
        builder.append(this.windVelocity);
        builder.append(", windDirection=");
        builder.append(this.windDirection);
        builder.append(", flapsHandle=");
        builder.append(this.flapsHandle);
        builder.append(", yokeXPosition=");
        builder.append(this.yokeXPosition);
        builder.append(", yokeYPosition=");
        builder.append(this.yokeYPosition);
        builder.append(", rudderPedalsPosition=");
        builder.append(this.rudderPedalsPosition);
        builder.append(", onGround=");
        builder.append(this.onGround);
        builder.append(", timestamp=");
        builder.append(this.timestamp);
        builder.append(", groundLevel=");
        builder.append(this.groundLevel);
        builder.append(", fps=");
        builder.append(this.fps);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Float getUserLat() {
        return this.userLat;
    }

    public void setUserLat(Float userLat) {
        this.userLat = userLat;
    }

    @Override
    public Float getUserLon() {
        return this.userLon;
    }

    public void setUserLon(Float userLon) {
        this.userLon = userLon;
    }

    @Override
    public Float getUserAlt() {
        return this.userAlt;
    }

    public void setUserAlt(Float userAlt) {
        this.userAlt = userAlt;
    }

    @Override
    public Float getUserIndicatedAlt() {
        return this.userIndicatedAlt;
    }

    public void setUserIndicatedAlt(Float userIndicatedAlt) {
        this.userIndicatedAlt = userIndicatedAlt;
    }

    @Override
    public Float getUserGs() {
        return this.userGs;
    }

    public void setUserGs(Float userGs) {
        this.userGs = userGs;
    }

    @Override
    public Float getUserTrueHeading() {
        return this.userTrueHeading;
    }

    public void setUserTrueHeading(Float userTrueHeading) {
        this.userTrueHeading = userTrueHeading;
    }

    @Override
    public Float getUserMagHeading() {
        return this.userMagHeading;
    }

    public void setUserMagHeading(Float userMagHeading) {
        this.userMagHeading = userMagHeading;
    }

    @Override
    public Float getMagVariation() {
        if (this.userTrueHeading == null || this.userMagHeading == null) {
            return null;
        }
        float res = this.userTrueHeading.floatValue() - this.userMagHeading.floatValue();
        if (res < -150.0f) {
            res += 360.0f;
        } else if (res > 150.0f) {
            res -= 360.0f;
        }
        return Float.valueOf(res);
    }

    @Override
    public Float getUserAltAboveTerrain() {
        return this.userAltAboveTerrain;
    }

    public void setUserAltAboveTerrain(Float userAltAboveTerrain) {
        this.userAltAboveTerrain = userAltAboveTerrain;
    }

    @Override
    public Float getUserVerticalSpeed() {
        return this.userVerticalSpeed;
    }

    public void setUserVerticalSpeed(Float userVerticalSpeed) {
        this.userVerticalSpeed = userVerticalSpeed;
    }

    @Override
    public Float getUserIndicatedSpeed() {
        return this.userIndicatedSpeed;
    }

    public void setUserIndicatedSpeed(Float userIndicatedSpeed) {
        this.userIndicatedSpeed = userIndicatedSpeed;
    }

    @Override
    public Float getUserPitch() {
        return this.userPitch;
    }

    public void setUserPitch(Float userPitch) {
        this.userPitch = userPitch;
    }

    @Override
    public Float getUserBank() {
        return this.userBank;
    }

    public void setUserBank(Float userBank) {
        this.userBank = userBank;
    }

    @Override
    public Float getgForce() {
        return this.gForce;
    }

    public void setgForce(Float gForce) {
        this.gForce = gForce;
    }

    @Override
    public Float getWindVelocity() {
        return this.windVelocity;
    }

    public void setWindVelocity(Float windVelocity) {
        this.windVelocity = windVelocity;
    }

    @Override
    public Float getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(Float windDirection) {
        this.windDirection = windDirection;
    }

    @Override
    public Short getFlapsHandle() {
        return this.flapsHandle;
    }

    public void setFlapsHandle(Short flapsHandle) {
        this.flapsHandle = flapsHandle;
    }

    @Override
    public Float getYokeXPosition() {
        return this.yokeXPosition;
    }

    public void setYokeXPosition(Float yokeXPosition) {
        this.yokeXPosition = yokeXPosition;
    }

    @Override
    public Float getYokeYPosition() {
        return this.yokeYPosition;
    }

    public void setYokeYPosition(Float yokeYPosition) {
        this.yokeYPosition = yokeYPosition;
    }

    @Override
    public Float getRudderPeddalsPosition() {
        return this.rudderPedalsPosition;
    }

    public void setRudderPedalsPosition(Float rudderPedalsPosition) {
        this.rudderPedalsPosition = rudderPedalsPosition;
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public float getGroundLevel() {
        return this.groundLevel.floatValue();
    }

    public void setGroundLevel(Float groundLevel) {
        this.groundLevel = groundLevel;
    }

    @Override
    public GpsPlace getGpsPlace() {
        if (this.userLat == null || this.userLon == null) {
            return null;
        }
        if (this.userAlt == null) {
            return new GpsPlace(this.userLat.floatValue(), this.userLon.floatValue());
        }
        return new GpsPlace(this.userLat.floatValue(), this.userLon.floatValue(), this.userAlt.floatValue());
    }

    @Override
    public Float getUserTas() {
        return this.userTas;
    }

    public void setUserTas(Float userTas) {
        this.userTas = userTas;
    }

    @Override
    public Float getFps() {
        return this.fps;
    }

    public void setFps(Float fps) {
        this.fps = fps;
    }

    @Override
    public boolean hasData() {
        return this.getUserLat() != null && this.getUserLon() != null;
    }

    @Override
    public boolean isInside(GpsArea area) {
        return (double)this.userLat.floatValue() <= area.getMaxLat() && (double)this.userLat.floatValue() >= area.getMinLat() && (double)this.userLon.floatValue() >= area.getMinLon() && (double)this.userLon.floatValue() <= area.getMaxLon();
    }

    @Override
    public ExtConnectBean clone() {
        FlightgearConnectBean newBean = new FlightgearConnectBean();
        newBean.userLat = this.userLat;
        newBean.userLon = this.userLon;
        newBean.userAlt = this.userAlt;
        newBean.userIndicatedAlt = this.userIndicatedAlt;
        newBean.userGs = this.userGs;
        newBean.userTrueHeading = this.userTrueHeading;
        newBean.userMagHeading = this.userMagHeading;
        newBean.userAltAboveTerrain = this.userAltAboveTerrain;
        newBean.userVerticalSpeed = this.userVerticalSpeed;
        newBean.userIndicatedSpeed = this.userIndicatedSpeed;
        newBean.userPitch = this.userPitch;
        newBean.userBank = this.userBank;
        newBean.gForce = this.gForce;
        newBean.windVelocity = this.windVelocity;
        newBean.windDirection = this.windDirection;
        newBean.flapsHandle = this.flapsHandle;
        newBean.yokeXPosition = this.yokeXPosition;
        newBean.yokeYPosition = this.yokeYPosition;
        newBean.rudderPedalsPosition = this.rudderPedalsPosition;
        newBean.onGround = this.onGround;
        newBean.timestamp = this.timestamp;
        newBean.groundLevel = this.groundLevel;
        return newBean;
    }

    @Override
    public boolean positionEquals(ExtConnectBean bean) {
        if (bean == null) {
            return false;
        }
        if (!(bean instanceof FlightgearConnectBean)) {
            return false;
        }
        return NumberUtil.floatEqualsFloat(this.userLat.floatValue(), bean.getUserLat().floatValue(), 5) && NumberUtil.floatEqualsFloat(this.userLon.floatValue(), bean.getUserLon().floatValue(), 5) && Math.round(this.userAlt.floatValue()) == Math.round(bean.getUserAlt().floatValue());
    }
}

